/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.types.UserDefinedTypeIdImpl;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ParameterQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.JSQLType;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public final class ParameterNode
extends ValueNode {
    private boolean defaultValueIsArray = false;
    private int parameterNumber;
    private DataTypeDescriptor[] userParameterTypes;
    protected DataValueDescriptor defaultValue;
    private JSQLType jsqlType;
    private int orderableVariantType = 2;
    private ValueNode returnOutputParameter;
    private ValueNode valToGenerate;
    public static String GFXDPARAM = "GFXD";

    @Override
    public void init(Object parameterNumber, Object defaultValue) {
        this.defaultValue = (DataValueDescriptor)defaultValue;
        this.parameterNumber = (Integer)parameterNumber;
    }

    public int getParameterNumber() {
        return this.parameterNumber;
    }

    public void setDescriptors(DataTypeDescriptor[] descriptors) {
        this.userParameterTypes = descriptors;
    }

    @Override
    public void setType(DataTypeDescriptor descriptor) throws StandardException {
        if (DVDSet.class.getName().equals(descriptor.getTypeId().getSQLTypeName())) {
            assert (!this.getCompilerContext().createQueryInfo()) : " DVDSet shouldn't have occured in QueryNode";
            descriptor = (DataTypeDescriptor)((UserDefinedTypeIdImpl)descriptor.getTypeId().getBaseTypeId()).getClassParam();
            assert (descriptor != null) : "DVDSet underlying result type is not expected to null";
        }
        if (!this.getCompilerContext().createQueryInfo() && this.defaultValueIsArray) {
            descriptor = new DataTypeDescriptor(TypeId.getUserDefinedTypeId("com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet", descriptor, false), true);
        }
        descriptor = descriptor.getNullabilityType(true);
        if (this.userParameterTypes != null) {
            this.userParameterTypes[this.parameterNumber] = descriptor;
        }
        super.setType(descriptor);
        if (this.getJSQLType() == null) {
            this.setJSQLType(new JSQLType(descriptor));
        }
    }

    public void setReturnOutputParam(ValueNode valueNode) {
        this.returnOutputParameter = valueNode;
    }

    public boolean isReturnOutputParam() {
        return this.returnOutputParameter != null;
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.checkReliability("?", 8);
        return this;
    }

    @Override
    public boolean isConstantExpression() {
        return true;
    }

    @Override
    public boolean constantExpression(PredicateList whereClause) {
        return true;
    }

    @Override
    protected int getOrderableVariantType() {
        return this.orderableVariantType;
    }

    void setOrderableVariantType(int type) {
        this.orderableVariantType = type;
    }

    public void setJSQLType(JSQLType type) {
        this.jsqlType = type;
    }

    public JSQLType getJSQLType() {
        return this.jsqlType;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.valToGenerate != null) {
            this.valToGenerate.generateExpression(acb, mb);
            return;
        }
        DataTypeDescriptor dtd = this.getTypeServices();
        if (dtd != null && dtd.getTypeId().isXMLTypeId()) {
            throw StandardException.newException("42Z70");
        }
        mb.pushThis();
        mb.push(this.parameterNumber);
        mb.callMethod((short)182, "com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "getParameter", "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor", 1);
        switch (dtd.getJDBCTypeId()) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                mb.dup();
                mb.push(dtd.getMaximumWidth());
                mb.callMethod((short)185, null, "checkHostVariable", "void", 1);
                break;
            }
        }
        if (this.defaultValueIsArray) {
            mb.cast("com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet");
        } else {
            mb.cast(this.getTypeCompiler().interfaceName());
        }
    }

    @Override
    public TypeId getTypeId() throws StandardException {
        return this.returnOutputParameter != null ? this.returnOutputParameter.getTypeId() : super.getTypeId();
    }

    public static void generateParameterValueSet(ExpressionClassBuilder acb, int numberOfParameters, Vector parameterList) throws StandardException {
        if (numberOfParameters > 0) {
            MethodBuilder constructor = acb.getConstructor();
            boolean hasReturnParam = ((ParameterNode)parameterList.elementAt(0)).isReturnOutputParam();
            constructor.pushThis();
            constructor.push(numberOfParameters);
            constructor.push(hasReturnParam);
            constructor.callMethod((short)182, "com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "setParameterValueSet", "void", 2);
            MethodBuilder executeMethod = acb.getExecuteMethod();
            executeMethod.pushThis();
            executeMethod.callMethod((short)182, "com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "throwIfMissingParms", "void", 0);
        }
    }

    DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean requiresTypeFromContext() {
        return true;
    }

    @Override
    public boolean isParameterNode() {
        return true;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) {
        return this == o;
    }

    protected void setValueToGenerate(ValueNode vn) {
        this.valToGenerate = vn;
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        if (this.valToGenerate != null) {
            return this.valToGenerate.computeQueryInfo(qic);
        }
        int length = this.userParameterTypes[this.parameterNumber].getMaximumWidth();
        ParameterQueryInfo pqi = new ParameterQueryInfo(this.parameterNumber - qic.getAbsoluteStart());
        pqi.setMaximumWidth(length);
        qic.foundParameter(this.parameterNumber - qic.getAbsoluteStart());
        return pqi;
    }

    @Override
    public String ncjGenerateSql() {
        return GFXDPARAM + this.parameterNumber + GFXDPARAM;
    }

    public void setDefaultValueIsArray() {
        this.defaultValueIsArray = true;
    }
}

