/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderedColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SetOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;

public class OrderByColumn
extends OrderedColumn {
    private ResultColumn resultCol;
    private boolean ascending = true;
    private boolean nullsOrderedLow = false;
    private ValueNode expression;
    private OrderByList list;
    private int addedColumnOffset = -1;

    @Override
    public void init(Object expression) {
        this.expression = (ValueNode)expression;
    }

    @Override
    public String toString() {
        return this.expression.toString();
    }

    public void setDescending() {
        this.ascending = false;
    }

    @Override
    public boolean isAscending() {
        return this.ascending;
    }

    public void setNullsOrderedLow() {
        this.nullsOrderedLow = true;
    }

    @Override
    public boolean isNullsOrderedLow() {
        return this.nullsOrderedLow;
    }

    @Override
    ResultColumn getResultColumn() {
        return this.resultCol;
    }

    ValueNode getNonRedundantExpression() {
        ColumnReference colref = null;
        ResultColumn rc = this.resultCol;
        while (rc.isRedundant()) {
            ValueNode value = rc.getExpression();
            if (value instanceof ColumnReference) {
                colref = (ColumnReference)value;
            } else {
                SanityManager.THROWASSERT((String)("value should be a ColumnReference, but is a " + value.getClass().getName()));
            }
            rc = colref.getSource();
        }
        return rc.getExpression();
    }

    public void bindOrderByColumn(ResultSetNode target, OrderByList oblist) throws StandardException {
        this.list = oblist;
        if (this.expression instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)this.expression;
            this.resultCol = this.resolveColumnReference(target, cr);
            this.columnPosition = this.resultCol.getColumnPosition();
            if (this.addedColumnOffset >= 0 && target instanceof SelectNode && ((SelectNode)target).hasDistinct()) {
                throw StandardException.newException("42879", cr.columnName);
            }
        } else if (OrderByColumn.isReferedColByNum(this.expression)) {
            ResultColumnList targetCols = target.getResultColumns();
            this.columnPosition = (Integer)this.expression.getConstantValueAsObject();
            this.resultCol = targetCols.getOrderByColumn(this.columnPosition);
            if (this.resultCol == null || this.resultCol.getColumnPosition() > targetCols.visibleSize()) {
                throw StandardException.newException("42X77", String.valueOf(this.columnPosition));
            }
        } else {
            SanityManager.ASSERT((this.addedColumnOffset >= 0 ? 1 : 0) != 0, (String)"Order by expression was not pulled into the result column list");
            this.resolveAddedColumn(target);
            if (this.resultCol == null) {
                throw StandardException.newException("42878");
            }
        }
        this.resultCol.verifyOrderable();
    }

    private void resolveAddedColumn(ResultSetNode target) {
        ResultColumnList targetCols = target.getResultColumns();
        this.columnPosition = targetCols.visibleSize() + this.addedColumnOffset + 1;
        this.resultCol = targetCols.getResultColumn(this.columnPosition);
    }

    public void pullUpOrderByColumn(ResultSetNode target) throws StandardException {
        ResultColumnList targetCols = target.getResultColumns();
        if (this.expression instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)this.expression;
            this.resultCol = targetCols.findResultColumnForOrderBy(cr.getColumnName(), cr.getTableNameNode());
            if (this.resultCol == null) {
                this.resultCol = (ResultColumn)this.getNodeFactory().getNode(80, cr.getColumnName(), cr, this.getContextManager());
                targetCols.addResultColumn(this.resultCol);
                this.addedColumnOffset = targetCols.getOrderBySelect();
                targetCols.incOrderBySelect();
            }
        } else if (!OrderByColumn.isReferedColByNum(this.expression)) {
            this.resultCol = (ResultColumn)this.getNodeFactory().getNode(80, null, this.expression, this.getContextManager());
            targetCols.addResultColumn(this.resultCol);
            this.addedColumnOffset = targetCols.getOrderBySelect();
            targetCols.incOrderBySelect();
        }
    }

    void resetToSourceRC() {
        if (!(this.resultCol.getExpression() instanceof VirtualColumnNode)) {
            SanityManager.THROWASSERT((String)("resultCol.getExpression() expected to be instanceof VirtualColumnNode , not " + this.resultCol.getExpression().getClass().getName()));
        }
        this.resultCol = this.resultCol.getExpression().getSourceResultColumn();
    }

    boolean constantColumn(PredicateList whereClause) {
        ValueNode sourceExpr = this.resultCol.getExpression();
        return sourceExpr.constantExpression(whereClause);
    }

    void remapColumnReferencesToExpressions() throws StandardException {
        this.resultCol.setExpression(this.resultCol.getExpression().remapColumnReferencesToExpressions());
    }

    private static boolean isReferedColByNum(ValueNode expression) throws StandardException {
        if (!expression.isConstantExpression()) {
            return false;
        }
        return expression.getConstantValueAsObject() instanceof Integer;
    }

    private ResultColumn resolveColumnReference(ResultSetNode target, ColumnReference cr) throws StandardException {
        ResultColumnList targetCols;
        ResultColumn resultCol = null;
        int sourceTableNumber = -1;
        if (target instanceof SetOperatorNode && cr.getTableName() != null) {
            String fullName = cr.getSQLColumnName();
            throw StandardException.newException("42877", fullName);
        }
        if (cr.getTableNameNode() != null) {
            TableName tableNameNode = cr.getTableNameNode();
            FromTable fromTable = target.getFromTableByName(tableNameNode.getTableName(), tableNameNode.hasSchema() ? tableNameNode.getSchemaName() : null, true);
            if (fromTable == null && (fromTable = target.getFromTableByName(tableNameNode.getTableName(), tableNameNode.hasSchema() ? tableNameNode.getSchemaName() : null, false)) == null) {
                String fullName = cr.getTableNameNode().toString();
                throw StandardException.newException("42X10", fullName);
            }
            sourceTableNumber = target instanceof SetOperatorNode ? ((FromTable)target).getTableNumber() : fromTable.getTableNumber();
        }
        if ((resultCol = (targetCols = target.getResultColumns()).getOrderByColumnToBind(cr.getColumnName(), cr.getTableNameNode(), sourceTableNumber, this)) == null && this.addedColumnOffset >= 0) {
            this.resolveAddedColumn(target);
        }
        if (resultCol == null || resultCol.isNameGenerated()) {
            String errString = cr.columnName;
            throw StandardException.newException("42X78", errString);
        }
        return resultCol;
    }

    void clearAddedColumnOffset() {
        this.list.closeGap(this.addedColumnOffset);
        this.addedColumnOffset = -1;
    }

    void collapseAddedColumnGap(int gap) {
        if (this.addedColumnOffset > gap) {
            --this.addedColumnOffset;
        }
    }
}

