/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.sql.compile.DistributedHashFetchRowsJoinStrategy;
import com.pivotal.gemfirexd.internal.engine.sql.compile.DistributedJoinStrategy;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.JoinStrategy;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizableList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizerFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RequiredRowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CostEstimateImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HashJoinStrategy;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NestedLoopJoinStrategy;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OptimizerImpl;
import java.util.Properties;

public class OptimizerFactoryImpl
implements ModuleControl,
OptimizerFactory {
    protected String optimizerId = null;
    protected boolean ruleBasedOptimization = false;
    protected boolean noTimeout = false;
    protected boolean useStatistics = true;
    protected int maxMemoryPerTable = 0x100000;
    protected JoinStrategy[] joinStrategySet;
    protected DistributedJoinStrategy[] distJoinStrategySet;

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        String us;
        int intValue;
        this.ruleBasedOptimization = Boolean.valueOf(PropertyUtil.getSystemProperty("gemfirexd.optimizer.ruleBasedOptimization"));
        this.noTimeout = Boolean.valueOf(PropertyUtil.getSystemProperty("gemfirexd.optimizer.noTimeout"));
        String maxMemValue = PropertyUtil.getSystemProperty("gemfirexd.language.maxMemoryPerTable");
        if (maxMemValue != null && (intValue = Integer.parseInt(maxMemValue)) >= 0) {
            this.maxMemoryPerTable = intValue * 1024;
        }
        if ((us = PropertyUtil.getSystemProperty("gemfirexd.language.useStatistics")) != null) {
            this.useStatistics = Boolean.valueOf(us);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public Optimizer getOptimizer(OptimizableList optimizableList, OptimizablePredicateList predList, DataDictionary dDictionary, RequiredRowOrdering requiredRowOrdering, int numTablesInQuery, LanguageConnectionContext lcc) throws StandardException {
        if (this.joinStrategySet == null) {
            JoinStrategy[] jss = new JoinStrategy[]{new NestedLoopJoinStrategy(), new HashJoinStrategy()};
            this.joinStrategySet = jss;
        }
        if (this.distJoinStrategySet == null) {
            DistributedJoinStrategy[] djss = new DistributedJoinStrategy[]{new DistributedHashFetchRowsJoinStrategy()};
            this.distJoinStrategySet = djss;
        }
        return this.getOptimizerImpl(optimizableList, predList, dDictionary, requiredRowOrdering, numTablesInQuery, lcc);
    }

    @Override
    public CostEstimate getCostEstimate() throws StandardException {
        return new CostEstimateImpl();
    }

    @Override
    public boolean supportsOptimizerTrace() {
        return false;
    }

    protected Optimizer getOptimizerImpl(OptimizableList optimizableList, OptimizablePredicateList predList, DataDictionary dDictionary, RequiredRowOrdering requiredRowOrdering, int numTablesInQuery, LanguageConnectionContext lcc) throws StandardException {
        return new OptimizerImpl(optimizableList, predList, dDictionary, this.ruleBasedOptimization, this.noTimeout, this.useStatistics, this.maxMemoryPerTable, this.joinStrategySet, this.distJoinStrategySet, lcc.getLockEscalationThreshold(), requiredRowOrdering, numTablesInQuery);
    }

    @Override
    public int getMaxMemoryPerTable() {
        return this.maxMemoryPerTable;
    }
}

