/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInfo;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleSupportable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.NodeFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import java.util.Properties;
import java.util.Vector;

public class NodeFactoryImpl
extends NodeFactory
implements ModuleControl,
ModuleSupportable {
    private Boolean joinOrderOptimization = Boolean.TRUE;
    private final ClassInfo[] nodeCi = new ClassInfo[234];
    private static final Vector emptyVector = new Vector(0);

    @Override
    public boolean canSupport(String identifier, Properties startParams) {
        return Monitor.isDesiredType(startParams, 130);
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        String opt = PropertyUtil.getSystemProperty("gemfirexd.optimizer.optimizeJoinOrder");
        if (opt != null) {
            this.joinOrderOptimization = Boolean.valueOf(opt);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public Boolean doJoinOrderOptimization() {
        return this.joinOrderOptimization;
    }

    @Override
    public QueryTreeNode getNode(int nodeType, ContextManager cm) throws StandardException {
        ClassInfo ci = this.nodeCi[nodeType];
        Class<?> nodeClass = null;
        if (ci == null) {
            String nodeName = this.nodeName(nodeType);
            try {
                nodeClass = Class.forName(nodeName);
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println("XXXNodeFactoryImpl:nodename=" + nodeName + " " + nodeType);
                SanityManager.THROWASSERT((String)"Unexpected ClassNotFoundException", (Throwable)cnfe);
            }
            this.nodeCi[nodeType] = ci = new ClassInfo(nodeClass);
        }
        QueryTreeNode retval = null;
        try {
            retval = (QueryTreeNode)ci.getNewInstance();
        }
        catch (Exception iae) {
            SanityManager.THROWASSERT((String)"Unexpected Exception", (Throwable)iae);
        }
        retval.setContextManager(cm);
        retval.setNodeType(nodeType);
        return retval;
    }

    protected String nodeName(int nodeType) throws StandardException {
        switch (nodeType) {
            case 2: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CurrentRowLocationNode";
            }
            case 3: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList";
            }
            case 7: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByList";
            }
            case 8: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList";
            }
            case 9: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList";
            }
            case 11: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList";
            }
            case 12: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.TableElementList";
            }
            case 13: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.UntypedNullConstantNode";
            }
            case 14: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.TableElementNode";
            }
            case 15: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNodeList";
            }
            case 16: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.AllResultColumn";
            }
            case 18: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.GetCurrentConnectionNode";
            }
            case 19: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.NOPStatementNode";
            }
            case 21: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.SetTransactionIsolationNode";
            }
            case 23: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.LengthOperatorNode";
            }
            case 24: 
            case 25: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.IsNullNode";
            }
            case 26: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.NotNode";
            }
            case 28: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.SQLToJavaValueNode";
            }
            case 34: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.TableName";
            }
            case 35: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByColumn";
            }
            case 36: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.JavaToSQLValueNode";
            }
            case 37: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.FromList";
            }
            case 38: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.BooleanConstantNode";
            }
            case 39: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode";
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryRelationalOperatorNode";
            }
            case 40: 
            case 46: 
            case 48: 
            case 49: 
            case 194: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryArithmeticOperatorNode";
            }
            case 192: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CoalesceFunctionNode";
            }
            case 50: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ConcatenationOperatorNode";
            }
            case 51: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.LikeEscapeOperatorNode";
            }
            case 52: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.OrNode";
            }
            case 53: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.BetweenOperatorNode";
            }
            case 54: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ConditionalNode";
            }
            case 55: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.InListOperatorNode";
            }
            case 58: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.BitConstantNode";
            }
            case 59: 
            case 72: 
            case 195: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.VarbitConstantNode";
            }
            case 60: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CastNode";
            }
            case 61: 
            case 73: 
            case 77: 
            case 196: 
            case 204: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CharConstantNode";
            }
            case 199: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.XMLConstantNode";
            }
            case 62: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference";
            }
            case 63: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DropIndexNode";
            }
            case 65: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DropTriggerNode";
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 75: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.NumericConstantNode";
            }
            case 76: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.UserTypeConstantNode";
            }
            case 78: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate";
            }
            case 80: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn";
            }
            case 212: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.SetRoleNode";
            }
            case 81: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.SetSchemaNode";
            }
            case 83: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.SimpleStringOperatorNode";
            }
            case 84: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.StaticClassFieldReferenceNode";
            }
            case 85: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.StaticMethodCallNode";
            }
            case 87: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ExtractOperatorNode";
            }
            case 88: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode";
            }
            case 79: {
                return "com.pivotal.gemfirexd.internal.engine.sql.compile.ParameterizedConstantNode";
            }
            case 90: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DropSchemaNode";
            }
            case 214: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DropRoleNode";
            }
            case 91: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DropTableNode";
            }
            case 92: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DropViewNode";
            }
            case 93: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryNode";
            }
            case 94: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.BaseColumnNode";
            }
            case 95: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CallStatementNode";
            }
            case 97: 
            case 113: 
            case 186: 
            case 187: 
            case 193: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ModifyColumnNode";
            }
            case 98: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.NonStaticMethodCallNode";
            }
            case 99: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CurrentOfNode";
            }
            case 100: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DefaultNode";
            }
            case 101: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DeleteNode";
            }
            case 102: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.UpdateNode";
            }
            case 104: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByColumn";
            }
            case 105: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.RowResultSetNode";
            }
            case 107: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode";
            }
            case 108: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CurrentDatetimeOperatorNode";
            }
            case 4: 
            case 5: 
            case 6: 
            case 109: 
            case 110: 
            case 125: 
            case 126: 
            case 210: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.SpecialFunctionNode";
            }
            case 111: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.IsNode";
            }
            case 112: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.LockTableNode";
            }
            case 114: {
                return "com.pivotal.gemfirexd.internal.engine.ddl.GfxdAlterTableNode";
            }
            case 115: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.AggregateNode";
            }
            case 116: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnDefinitionNode";
            }
            case 118: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ExecSPSNode";
            }
            case 119: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.FKConstraintDefinitionNode";
            }
            case 120: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.FromVTI";
            }
            case 121: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.MaterializeResultSetNode";
            }
            case 122: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.NormalizeResultSetNode";
            }
            case 123: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ScrollInsensitiveResultSetNode";
            }
            case 140: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByNode";
            }
            case 124: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DistinctNode";
            }
            case 145: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.NcjPullScanNode";
            }
            case 127: 
            case 154: 
            case 184: 
            case 185: 
            case 190: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.TernaryOperatorNode";
            }
            case 129: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode";
            }
            case 130: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CreateViewNode";
            }
            case 131: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ConstraintDefinitionNode";
            }
            case 133: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.NewInvocationNode";
            }
            case 211: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CreateRoleNode";
            }
            case 134: {
                return "com.pivotal.gemfirexd.internal.engine.ddl.GfxdCreateSchemaNode";
            }
            case 135: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable";
            }
            case 136: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.FromSubquery";
            }
            case 137: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByNode";
            }
            case 138: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.InsertNode";
            }
            case 139: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.JoinNode";
            }
            case 141: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CreateTableNode";
            }
            case 191: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.RenameNode";
            }
            case 142: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.UnionNode";
            }
            case 157: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.IntersectOrExceptNode";
            }
            case 143: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CreateTriggerNode";
            }
            case 144: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.HalfOuterJoinNode";
            }
            case 146: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CreateIndexNode";
            }
            case 147: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CursorNode";
            }
            case 148: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.HashTableNode";
            }
            case 149: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.IndexToBaseRowNode";
            }
            case 150: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CreateAliasNode";
            }
            case 151: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode";
            }
            case 31: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.SQLBooleanConstantNode";
            }
            case 156: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DropAliasNode";
            }
            case 1: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.TestConstraintNode";
            }
            case 29: 
            case 30: 
            case 188: 
            case 189: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryArithmeticOperatorNode";
            }
            case 198: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.SavepointNode";
            }
            case 32: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryDateTimestampOperatorNode";
            }
            case 33: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.TimestampOperatorNode";
            }
            case 20: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DB2LengthOperatorNode";
            }
            case 200: 
            case 201: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode";
            }
            case 202: 
            case 203: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryOperatorNode";
            }
            case 89: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.GrantNode";
            }
            case 86: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.RevokeNode";
            }
            case 215: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.GrantRoleNode";
            }
            case 216: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.RevokeRoleNode";
            }
            case 103: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.PrivilegeNode";
            }
            case 106: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.TablePrivilegesNode";
            }
            case 220: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.WindowNode";
            }
            case 221: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.RowNumberColumnNode";
            }
            case 230: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.RowCountNode";
            }
            case 117: {
                return "com.pivotal.gemfirexd.internal.engine.sql.compile.DistributionDefinitionNode";
            }
            case 152: {
                return "com.pivotal.gemfirexd.internal.engine.procedure.coordinate.DistributedProcedureCallNode";
            }
            case 153: {
                return "com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProcedureProcessorNode";
            }
            case 222: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CreateDiskStoreNode";
            }
            case 223: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DropDiskStoreNode";
            }
            case 231: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CreateHDFSStoreNode";
            }
            case 232: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DropHDFSStoreNode";
            }
            case 233: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.AlterHDFSStoreNode";
            }
            case 224: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CreateGatewaySenderNode";
            }
            case 225: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CreateAsyncEventListenerNode";
            }
            case 226: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.CreateGatewayReceiverNode";
            }
            case 227: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DropGatewaySenderNode";
            }
            case 228: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DropAsyncEventListenerNode";
            }
            case 229: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.DropGatewayReceiverNode";
            }
            case 128: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.ExplainNode";
            }
            case 158: {
                return "com.pivotal.gemfirexd.internal.impl.sql.compile.OrListNode";
            }
        }
        throw StandardException.newException("0A000.S");
    }

    @Override
    public QueryTreeNode getCreateAliasNode(Object aliasName, Object targetName, Object aliasSpecificInfo, char aliasType, Boolean delimitedIdentifier, ContextManager cm) throws StandardException {
        String methodName = null;
        Object targetMethodName = null;
        Object targetClassName = null;
        int nodeType = 150;
        if (aliasType != 'S' && aliasType != 'A' && aliasType != 'R') {
            String fullStaticMethodName = (String)targetName;
            int paren = fullStaticMethodName.indexOf(40);
            int lastPeriod = paren == -1 ? fullStaticMethodName.lastIndexOf(46) : fullStaticMethodName.substring(0, paren).lastIndexOf(46);
            if (lastPeriod == -1 || lastPeriod == fullStaticMethodName.length() - 1) {
                throw StandardException.newException("42Y04", fullStaticMethodName);
            }
            String javaClassName = fullStaticMethodName.substring(0, lastPeriod);
            methodName = fullStaticMethodName.substring(lastPeriod + 1);
            targetName = javaClassName;
        }
        return this.getNode(nodeType, aliasName, targetName, methodName, aliasSpecificInfo, Character.valueOf(aliasType), delimitedIdentifier, cm);
    }

    @Override
    public ResultSetNode mapTableAsVTI(TableDescriptor td, String correlationName, ResultColumnList resultColumns, Properties tableProperties, ContextManager cm) throws StandardException {
        QueryTreeNode vtiNode;
        QueryTreeNode newNode = this.getNode(133, null, td, emptyVector, Boolean.FALSE, cm);
        if (correlationName != null) {
            vtiNode = this.getNode(120, newNode, correlationName, resultColumns, tableProperties, cm);
        } else {
            TableName exposedName = newNode.makeTableName(td.getSchemaName(), td.getDescriptorName());
            vtiNode = this.getNode(120, newNode, correlationName, resultColumns, tableProperties, exposedName, cm);
        }
        return (ResultSetNode)vtiNode;
    }
}

