/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.DefaultInfoImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DefaultDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.KeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnDefinitionNode;

public class ModifyColumnNode
extends ColumnDefinitionNode {
    int columnPosition = -1;
    UUID oldDefaultUUID;

    @Override
    UUID getOldDefaultUUID() {
        return this.oldDefaultUUID;
    }

    public int getColumnPosition() {
        SanityManager.ASSERT((this.columnPosition > 0 ? 1 : 0) != 0, (String)"columnPosition expected to be > 0");
        return this.columnPosition;
    }

    @Override
    public void checkUserType(TableDescriptor td) throws StandardException {
        if (this.getNodeType() != 186) {
            return;
        }
        ColumnDescriptor cd = td.getColumnDescriptor(this.name);
        if (cd == null) {
            throw StandardException.newException("42X14", (Object)this.name, (Object)td.getName());
        }
        DataTypeDescriptor oldType = cd.getType();
        this.setNullability(oldType.isNullable());
        if (!oldType.getTypeId().equals(this.getType().getTypeId())) {
            throw StandardException.newException("42Z15", this.name);
        }
        String typeName = this.getType().getTypeName();
        if (!typeName.equals("VARCHAR") && !typeName.equals("VARCHAR () FOR BIT DATA")) {
            throw StandardException.newException("42Z16");
        }
        if (this.getType().getMaximumWidth() < oldType.getMaximumWidth()) {
            throw StandardException.newException("42Z17", this.name);
        }
    }

    public void checkExistingConstraints(TableDescriptor td) throws StandardException {
        if (this.getNodeType() != 186 && this.getNodeType() != 187 && this.getNodeType() != 193) {
            return;
        }
        DataDictionary dd = this.getDataDictionary();
        ConstraintDescriptorList cdl = dd.getConstraintDescriptors(td);
        int[] intArray = new int[]{this.columnPosition};
        for (int index = 0; index < cdl.size(); ++index) {
            ConstraintDescriptor existingConstraint = cdl.elementAt(index);
            if (!(existingConstraint instanceof KeyConstraintDescriptor) || !existingConstraint.columnIntersects(intArray)) continue;
            int constraintType = existingConstraint.getConstraintType();
            if (constraintType == 6 && this.getNodeType() == 186) {
                throw StandardException.newException("42Z18", (Object)this.name, (Object)existingConstraint.getConstraintName());
            }
            if (!dd.checkVersion(160, null) && this.getNodeType() == 187 && existingConstraint.getConstraintType() == 3) {
                throw StandardException.newException("42Z20", this.name);
            }
            if (this.getNodeType() == 187 && existingConstraint.getConstraintType() == 2) {
                throw StandardException.newException("42Z20", this.name);
            }
            ConstraintDescriptorList refcdl = dd.getForeignKeys(existingConstraint.getUUID());
            if (refcdl.size() > 0) {
                throw StandardException.newException("42Z19", (Object)this.name, (Object)refcdl.elementAt(0).getConstraintName());
            }
            this.getCompilerContext().createDependency(existingConstraint);
        }
    }

    public void useExistingCollation(TableDescriptor td) throws StandardException {
        ColumnDescriptor cd = td.getColumnDescriptor(this.name);
        if (cd == null) {
            throw StandardException.newException("42X14", (Object)this.name, (Object)td.getName());
        }
        if (this.getType() != null && this.getType().getTypeId().isStringTypeId()) {
            this.setCollationType(cd.getType().getCollationType());
        }
    }

    @Override
    int getAction() {
        switch (this.getNodeType()) {
            case 97: {
                if (this.autoinc_create_or_modify_Start_Increment == 1L) {
                    return 5;
                }
                if (this.autoinc_create_or_modify_Start_Increment == 2L) {
                    return 6;
                }
                if (this.setAutoIncrement) {
                    return 8;
                }
                return 7;
            }
            case 186: {
                return 2;
            }
            case 187: {
                return 3;
            }
            case 193: {
                return 4;
            }
            case 113: {
                return 1;
            }
        }
        SanityManager.THROWASSERT((String)("Unexpected nodeType = " + this.getNodeType()));
        return 0;
    }

    @Override
    void bindAndValidateDefault(DataDictionary dd, TableDescriptor td) throws StandardException {
        ColumnDescriptor cd = td.getColumnDescriptor(this.name);
        if (cd == null) {
            throw StandardException.newException("42X14", (Object)this.name, (Object)td.getName());
        }
        DefaultDescriptor defaultDescriptor = cd.getDefaultDescriptor(dd);
        this.oldDefaultUUID = defaultDescriptor == null ? null : defaultDescriptor.getUUID();
        this.columnPosition = cd.getPosition();
        if (this.getNodeType() != 97) {
            return;
        }
        if (this.defaultNode == null) {
            this.defaultInfo = (DefaultInfoImpl)cd.getDefaultInfo();
        }
        if (this.autoinc_create_or_modify_Start_Increment == 1L) {
            this.autoincrementIncrement = cd.getAutoincInc();
        }
        if (this.autoinc_create_or_modify_Start_Increment == 2L) {
            this.autoincrementStart = cd.getAutoincStart();
        }
        this.type = cd.getType();
        this.validateDefault(dd, td);
    }

    private ColumnDescriptor getLocalColumnDescriptor(String name, TableDescriptor td) throws StandardException {
        ColumnDescriptor cd = td.getColumnDescriptor(name);
        if (cd == null) {
            throw StandardException.newException("42X14", (Object)name, (Object)td.getName());
        }
        return cd;
    }

    @Override
    public void validateAutoincrement(DataDictionary dd, TableDescriptor td, int tableType) throws StandardException {
        ColumnDescriptor cd;
        if (this.getNodeType() == 187 && (cd = this.getLocalColumnDescriptor(this.name, td)).isAutoincrement()) {
            throw StandardException.newException("42Z26", this.getColumnName());
        }
        if (this.autoincrementVerify && !(cd = this.getLocalColumnDescriptor(this.name, td)).isAutoincrement()) {
            throw StandardException.newException("42837", (Object)td.getQualifiedName(), (Object)this.name);
        }
        if (!this.isAutoincrement) {
            return;
        }
        super.validateAutoincrement(dd, td, tableType);
        if (this.getType().isNullable()) {
            throw StandardException.newException("42Z27", this.getColumnName());
        }
    }
}

