/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;
import com.pivotal.gemfirexd.internal.catalog.types.TypeDescriptorImpl;
import com.pivotal.gemfirexd.internal.catalog.types.UserDefinedTypeIdImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.JSQLType;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectNodesVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SQLToJavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import java.lang.reflect.Member;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class MethodCallNode
extends JavaValueNode {
    String methodName;
    public String javaClassName;
    protected RoutineAliasInfo routineInfo;
    boolean internalCall;
    private String[] procedurePrimitiveArrayType;
    protected JSQLType[] signature;
    public JavaValueNode[] methodParms;
    protected Member method;
    protected String actualMethodReturnType;
    protected String[] methodParameterTypes;

    @Override
    public void init(Object methodName) {
        this.methodName = (String)methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public RoutineAliasInfo getRoutineInfo() {
        return this.routineInfo;
    }

    public void addParms(Vector parameterList) throws StandardException {
        this.methodParms = new JavaValueNode[parameterList.size()];
        int plSize = parameterList.size();
        for (int index = 0; index < plSize; ++index) {
            QueryTreeNode qt = (QueryTreeNode)parameterList.elementAt(index);
            if (!(qt instanceof JavaValueNode)) {
                qt = (SQLToJavaValueNode)this.getNodeFactory().getNode(28, qt, this.getContextManager());
            }
            this.methodParms[index] = (JavaValueNode)qt;
        }
    }

    public Class[] getMethodParameterClasses() {
        ClassInspector ci = this.getClassFactory().getClassInspector();
        Class[] parmTypeClasses = new Class[this.methodParms.length];
        for (int i = 0; i < this.methodParms.length; ++i) {
            String className = this.methodParameterTypes[i];
            try {
                parmTypeClasses[i] = ci.getClass(className);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                SanityManager.THROWASSERT((String)"Unexpected exception", (Throwable)cnfe);
                return null;
            }
        }
        return parmTypeClasses;
    }

    void getCorrelationTables(JBitSet correlationMap) throws StandardException {
        CollectNodesVisitor getCRs = new CollectNodesVisitor(ColumnReference.class);
        this.accept(getCRs);
        Vector colRefs = getCRs.getList();
        Enumeration e = colRefs.elements();
        while (e.hasMoreElements()) {
            ColumnReference ref = (ColumnReference)e.nextElement();
            if (!ref.getCorrelated()) continue;
            correlationMap.set(ref.getTableNumber());
        }
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.methodParms != null) {
            for (int parm = 0; parm < this.methodParms.length; ++parm) {
                if (this.methodParms[parm] == null) continue;
                this.printLabel(depth, "methodParms[" + parm + "] :");
                this.methodParms[parm].treePrint(depth + 1);
            }
        }
    }

    @Override
    public String toString() {
        return "methodName: " + (this.methodName != null ? this.methodName : "null") + "\n" + super.toString();
    }

    final void bindParameters(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        if (this.methodParms != null) {
            int count = this.methodParms.length;
            if (this.signature == null) {
                this.signature = new JSQLType[count];
            }
            for (int parm = 0; parm < count; ++parm) {
                String type;
                if (this.methodParms[parm] == null) continue;
                this.methodParms[parm] = this.methodParms[parm].bindExpression(fromList, subqueryList, aggregateVector);
                if (this.routineInfo == null) {
                    this.signature[parm] = this.methodParms[parm].getJSQLType();
                }
                if (this.signature[parm] != null && !(type = this.signature[parm].getSQLType().getTypeId().getSQLTypeName()).equals("CLOB") && !type.equals("NCLOB")) continue;
            }
        }
    }

    protected boolean areParametersQueryInvariant() throws StandardException {
        return this.getVariantTypeOfParams() == 2;
    }

    void throwNoMethodFound(String receiverTypeName, String[] parmTypeNames, String[] primParmTypeNames, boolean staticMethod) throws StandardException {
        StringBuilder parmTypes = new StringBuilder();
        for (int i = 0; i < parmTypeNames.length; ++i) {
            if (i != 0) {
                parmTypes.append(", ");
            }
            parmTypes.append(parmTypeNames[i].length() != 0 ? parmTypeNames[i] : "UNTYPED");
            if (primParmTypeNames == null || primParmTypeNames[i].equals(parmTypeNames[i])) continue;
            parmTypes.append("(" + primParmTypeNames[i] + ")");
        }
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        String foundMethod = "";
        try {
            Member m;
            int spaceIndex = receiverTypeName.lastIndexOf(32);
            String typeName = receiverTypeName;
            if (spaceIndex != -1) {
                typeName = receiverTypeName.substring(spaceIndex + 1);
            }
            if ((m = classInspector.findPublicMethod(typeName, this.methodName, null, null, null, staticMethod, false)) != null) {
                foundMethod = " Close match: '" + m.toString() + "'.";
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw StandardException.newException("42X50", receiverTypeName, (Object)this.methodName, (Object)parmTypes, (Object)foundMethod);
    }

    @Override
    public void preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        if (this.methodParms != null) {
            for (int parm = 0; parm < this.methodParms.length; ++parm) {
                if (this.methodParms[parm] == null) continue;
                this.methodParms[parm].preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
            }
        }
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        if (simplePredsOnly) {
            return false;
        }
        boolean pushable = true;
        if (this.methodParms != null) {
            for (int param = 0; param < this.methodParms.length; ++param) {
                if (this.methodParms[param] == null) continue;
                pushable = this.methodParms[param].categorize(referencedTabs, simplePredsOnly) && pushable;
            }
        }
        return pushable;
    }

    @Override
    public JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.methodParms != null) {
            for (int param = 0; param < this.methodParms.length; ++param) {
                if (this.methodParms[param] == null) continue;
                this.methodParms[param] = this.methodParms[param].remapColumnReferencesToExpressions();
            }
        }
        return this;
    }

    public int generateParameters(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        String[] expectedTypes = this.methodParameterTypes;
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        for (int param = 0; param < this.methodParms.length; ++param) {
            this.generateOneParameter(acb, mb, param);
            String argumentType = MethodCallNode.getParameterTypeName(this.methodParms[param]);
            String parameterType = expectedTypes[param];
            if (parameterType.equals(argumentType)) continue;
            if (ClassInspector.primitiveType(parameterType)) {
                mb.cast(parameterType);
                continue;
            }
            if (this.routineInfo != null && this.routineInfo.getParameterModes()[param] != 1) continue;
            SanityManager.ASSERT((boolean)classInspector.assignableTo(argumentType, parameterType), (String)("Argument type " + argumentType + " is not assignable to parameter " + parameterType));
            mb.upCast(parameterType);
        }
        return this.methodParms.length;
    }

    public static String getParameterTypeName(JavaValueNode param) throws StandardException {
        String argumentType = param.isPrimitiveType() ? param.getPrimitiveTypeName() : param.getJavaTypeName();
        return argumentType;
    }

    public void generateOneParameter(ExpressionClassBuilder acb, MethodBuilder mb, int parameterNumber) throws StandardException {
        this.methodParms[parameterNumber].generateExpression(acb, mb);
    }

    public void setNullParameterInfo(String[] parmTypeNames) throws StandardException {
        for (int i = 0; i < this.methodParms.length; ++i) {
            if (!this.methodParms[i].getJavaTypeName().equals("")) continue;
            DataTypeDescriptor dts = DataTypeDescriptor.getSQLDataTypeDescriptor(parmTypeNames[i]);
            ((SQLToJavaValueNode)this.methodParms[i]).value.setType(dts);
            this.methodParms[i].setJavaTypeName(parmTypeNames[i]);
            this.signature[i] = this.methodParms[i].getJSQLType();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resolveMethodCall(String javaClassName, boolean staticMethod) throws StandardException {
        String typeName;
        String[] parmTypeNames;
        if (this.routineInfo == null && !this.internalCall && (this.getCompilerContext().getReliability() & 0x400) != 0) {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append(javaClassName);
            if (staticMethod) {
                string = "::";
                throw StandardException.newException("42X01", stringBuilder.append(string).append(this.methodName).toString());
            }
            string = ".";
            throw StandardException.newException("42X01", stringBuilder.append(string).append(this.methodName).toString());
        }
        int count = this.signature.length;
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        String[] primParmTypeNames = null;
        boolean[] isParam = this.getIsParam();
        boolean hasDynamicResultSets = this.routineInfo != null && count != 0 && count != this.methodParms.length;
        int signatureOffset = this.methodName.indexOf(40);
        if (signatureOffset != -1) {
            parmTypeNames = this.parseValidateSignature(this.methodName, signatureOffset, hasDynamicResultSets);
            this.methodName = this.methodName.substring(0, signatureOffset);
            hasDynamicResultSets = false;
        } else {
            parmTypeNames = this.getObjectSignature();
        }
        try {
            this.method = classInspector.findPublicMethod(javaClassName, this.methodName, parmTypeNames, null, isParam, staticMethod, hasDynamicResultSets);
            if (signatureOffset == -1 && this.routineInfo == null && this.method == null) {
                primParmTypeNames = this.getPrimitiveSignature(false);
                this.method = classInspector.findPublicMethod(javaClassName, this.methodName, parmTypeNames, primParmTypeNames, isParam, staticMethod, hasDynamicResultSets);
            }
        }
        catch (ClassNotFoundException e) {
            this.method = null;
        }
        if (this.method == null) {
            this.throwNoMethodFound(javaClassName, parmTypeNames, primParmTypeNames, staticMethod);
        }
        this.actualMethodReturnType = typeName = classInspector.getType(this.method);
        if (this.routineInfo == null) {
            if (typeName.equals("void") && !this.forCallStatement) {
                throw StandardException.newException("42Y09");
            }
        } else {
            String requiredType;
            String promoteName = null;
            TypeDescriptorImpl returnType = (TypeDescriptorImpl)this.routineInfo.getReturnType();
            if (returnType == null) {
                requiredType = "void";
            } else {
                TypeId returnTypeId = TypeId.getBuiltInTypeId(returnType.getJDBCTypeId());
                if (returnType.isRowMultiSet() && this.routineInfo.getParameterStyle() == 1) {
                    requiredType = "java.sql.ResultSet";
                } else if (returnType.getTypeId().userType()) {
                    requiredType = ((UserDefinedTypeIdImpl)returnType.getTypeId()).getClassName();
                } else {
                    requiredType = returnTypeId.getCorrespondingJavaTypeName();
                    if (!requiredType.equals(typeName)) {
                        switch (returnType.getJDBCTypeId()) {
                            case -5: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: {
                                TypeCompiler tc = this.getTypeCompiler(returnTypeId);
                                requiredType = tc.getCorrespondingPrimitiveTypeName();
                                if (this.routineInfo.calledOnNullInput() || this.routineInfo.getParameterCount() == 0) break;
                                promoteName = returnTypeId.getCorrespondingJavaTypeName();
                                break;
                            }
                        }
                    }
                }
            }
            if (!requiredType.equals(typeName)) {
                this.throwNoMethodFound(requiredType + " " + javaClassName, parmTypeNames, primParmTypeNames, staticMethod);
            }
            if (promoteName != null) {
                typeName = promoteName;
            }
            if (this.routineInfo.getReturnType() != null) {
                this.setCollationType(this.routineInfo.getReturnType().getCollationType());
            }
        }
        this.setJavaTypeName(typeName);
        this.methodParameterTypes = classInspector.getParameterTypes(this.method);
        block10: for (int i = 0; i < this.methodParameterTypes.length; ++i) {
            String methodParameter = this.methodParameterTypes[i];
            if (this.routineInfo != null && i < this.routineInfo.getParameterCount()) {
                int parameterMode = this.routineInfo.getParameterModes()[i];
                switch (parameterMode) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        methodParameter = methodParameter.substring(0, methodParameter.length() - 2);
                        break;
                    }
                    case 4: {
                        continue block10;
                    }
                }
            }
            if (!ClassInspector.primitiveType(methodParameter)) continue;
            this.methodParms[i].castToPrimitive(true);
        }
        if (this.someParametersAreNull()) {
            this.setNullParameterInfo(this.methodParameterTypes);
        }
        DataTypeDescriptor dts = DataTypeDescriptor.getSQLDataTypeDescriptor(typeName);
        if (!this.getCompilerContext().getReturnParameterFlag()) return;
        this.getCompilerContext().getParameterTypes()[0] = dts;
    }

    private String[] parseValidateSignature(String externalName, int offset, boolean hasDynamicResultSets) throws StandardException {
        int siglen = externalName.length();
        if (offset + 1 == siglen || externalName.charAt(siglen - 1) != ')') {
            throw StandardException.newException("46J01");
        }
        StringTokenizer st = new StringTokenizer(externalName.substring(offset + 1, siglen - 1), ",", true);
        String[] signatureTypes = new String[this.signature.length];
        boolean seenClass = false;
        int count = 0;
        while (st.hasMoreTokens()) {
            TypeCompiler tc;
            String type = st.nextToken().trim();
            if (",".equals(type)) {
                if (!seenClass) {
                    throw StandardException.newException("46J01");
                }
                seenClass = false;
                continue;
            }
            if (type.length() == 0) {
                throw StandardException.newException("46J01");
            }
            seenClass = true;
            if (++count > this.signature.length) {
                if (hasDynamicResultSets) {
                    String rsType = this.signature[this.signature.length - 1].getSQLType().getTypeId().getCorrespondingJavaTypeName();
                    if (!type.equals(rsType)) {
                        throw StandardException.newException("22005", (Object)type, (Object)rsType, (Object)null);
                    }
                    if (signatureTypes.length == this.signature.length) {
                        String[] sigs = new String[st.countTokens()];
                        System.arraycopy(signatureTypes, 0, sigs, 0, signatureTypes.length);
                        signatureTypes = sigs;
                    }
                    signatureTypes[count - 1] = type;
                    continue;
                }
                throw StandardException.newException("46J02", (Object)Integer.toString(count), (Object)Integer.toString(this.signature.length));
            }
            TypeId paramTypeId = this.signature[count - 1].getSQLType().getTypeId();
            if (type.equals(paramTypeId.getCorrespondingJavaTypeName())) {
                signatureTypes[count - 1] = type;
                continue;
            }
            if ((paramTypeId.isNumericTypeId() && !paramTypeId.isDecimalTypeId() || paramTypeId.isBooleanTypeId()) && type.equals((tc = this.getTypeCompiler(paramTypeId)).getCorrespondingPrimitiveTypeName())) {
                signatureTypes[count - 1] = type;
                continue;
            }
            throw StandardException.newException("22005", (Object)type, (Object)paramTypeId.getSQLTypeName(), (Object)null);
        }
        if (count != 0 && !seenClass) {
            throw StandardException.newException("46J01");
        }
        if (count < signatureTypes.length) {
            if (hasDynamicResultSets && count == this.signature.length - 1) {
                String[] sigs = new String[count];
                System.arraycopy(signatureTypes, 0, sigs, 0, count);
                return sigs;
            }
            throw StandardException.newException("46J02", (Object)Integer.toString(count), (Object)Integer.toString(this.signature.length));
        }
        return signatureTypes;
    }

    protected boolean someParametersAreNull() {
        int count = this.signature.length;
        for (int ictr = 0; ictr < count; ++ictr) {
            if (this.signature[ictr] != null) continue;
            return true;
        }
        return false;
    }

    protected String[] getObjectSignature() throws StandardException {
        int count = this.signature.length;
        String[] parmTypeNames = new String[count];
        for (int i = 0; i < count; ++i) {
            parmTypeNames[i] = this.getObjectTypeName(this.signature[i]);
        }
        return parmTypeNames;
    }

    protected boolean[] getIsParam() {
        if (this.methodParms == null) {
            return new boolean[0];
        }
        boolean[] isParam = new boolean[this.methodParms.length];
        for (int index = 0; index < this.methodParms.length; ++index) {
            if (!(this.methodParms[index] instanceof SQLToJavaValueNode)) continue;
            SQLToJavaValueNode stjvn = (SQLToJavaValueNode)this.methodParms[index];
            if (!stjvn.value.requiresTypeFromContext() || stjvn.value.isParameterizedConstantNode()) continue;
            isParam[index] = true;
        }
        return isParam;
    }

    private String getObjectTypeName(JSQLType jsqlType) throws StandardException {
        if (jsqlType != null) {
            switch (jsqlType.getCategory()) {
                case 0: {
                    TypeId ctid = this.mapToTypeID(jsqlType);
                    if (ctid == null) {
                        return null;
                    }
                    switch (ctid.getJDBCTypeId()) {
                        case -5: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: {
                            if (this.routineInfo == null) break;
                            TypeCompiler tc = this.getTypeCompiler(ctid);
                            return tc.getCorrespondingPrimitiveTypeName();
                        }
                    }
                    return ctid.getCorrespondingJavaTypeName();
                }
                case 1: {
                    return jsqlType.getJavaClassName();
                }
                case 2: {
                    return JSQLType.primitiveNames[jsqlType.getPrimitiveKind()];
                }
            }
            SanityManager.THROWASSERT((String)("Unknown JSQLType: " + jsqlType));
        }
        return "";
    }

    String[] getPrimitiveSignature(boolean castToPrimitiveAsNecessary) throws StandardException {
        int count = this.signature.length;
        String[] primParmTypeNames = new String[count];
        block5: for (int i = 0; i < count; ++i) {
            JSQLType jsqlType = this.signature[i];
            if (jsqlType == null) {
                primParmTypeNames[i] = "";
                continue;
            }
            switch (jsqlType.getCategory()) {
                case 0: {
                    if (this.procedurePrimitiveArrayType != null && i < this.procedurePrimitiveArrayType.length && this.procedurePrimitiveArrayType[i] != null) {
                        primParmTypeNames[i] = this.procedurePrimitiveArrayType[i];
                        continue block5;
                    }
                    TypeId ctid = this.mapToTypeID(jsqlType);
                    if (ctid.isNumericTypeId() && !ctid.isDecimalTypeId() || ctid.isBooleanTypeId()) {
                        TypeCompiler tc = this.getTypeCompiler(ctid);
                        primParmTypeNames[i] = tc.getCorrespondingPrimitiveTypeName();
                        if (!castToPrimitiveAsNecessary) continue block5;
                        this.methodParms[i].castToPrimitive(true);
                        continue block5;
                    }
                    primParmTypeNames[i] = ctid.getCorrespondingJavaTypeName();
                    continue block5;
                }
                case 1: {
                    primParmTypeNames[i] = jsqlType.getJavaClassName();
                    continue block5;
                }
                case 2: {
                    primParmTypeNames[i] = JSQLType.primitiveNames[jsqlType.getPrimitiveKind()];
                    if (!castToPrimitiveAsNecessary) continue block5;
                    this.methodParms[i].castToPrimitive(true);
                    continue block5;
                }
                default: {
                    SanityManager.THROWASSERT((String)("Unknown JSQLType: " + jsqlType));
                }
            }
        }
        return primParmTypeNames;
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        return this.getVariantTypeOfParams();
    }

    private int getVariantTypeOfParams() throws StandardException {
        int variance = 2;
        if (this.methodParms != null) {
            for (int parm = 0; parm < this.methodParms.length; ++parm) {
                if (this.methodParms[parm] != null) {
                    int paramVariantType = this.methodParms[parm].getOrderableVariantType();
                    if (paramVariantType >= variance) continue;
                    variance = paramVariantType;
                    continue;
                }
                variance = 0;
            }
        }
        return variance;
    }

    @Override
    public DataTypeDescriptor getDataType() throws StandardException {
        TypeDescriptor td;
        if (this.routineInfo != null && (td = this.routineInfo.getReturnType()) != null) {
            return DataTypeDescriptor.getType(td);
        }
        return super.getDataType();
    }

    public JavaValueNode[] getMethodParms() {
        return this.methodParms;
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        for (int parm = 0; !v.stopTraversal() && parm < this.methodParms.length; ++parm) {
            if (this.methodParms[parm] == null) continue;
            this.methodParms[parm] = (JavaValueNode)this.methodParms[parm].accept(v);
        }
        return returnNode;
    }
}

