/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.JSQLType;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public abstract class JavaValueNode
extends QueryTreeNode {
    private boolean mustCastToPrimitive;
    protected boolean forCallStatement;
    private boolean valueReturnedToSQLDomain;
    private boolean returnValueDiscarded;
    protected JSQLType jsqlType;
    private LocalField receiverField;
    private int collationType;

    public DataTypeDescriptor getDataType() throws StandardException {
        return DataTypeDescriptor.getSQLDataTypeDescriptor(this.getJavaTypeName());
    }

    public boolean isPrimitiveType() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return false;
        }
        return myType.getCategory() == 2;
    }

    public String getJavaTypeName() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return "";
        }
        switch (myType.getCategory()) {
            case 1: {
                return myType.getJavaClassName();
            }
            case 2: {
                return JSQLType.primitiveNames[myType.getPrimitiveKind()];
            }
        }
        SanityManager.THROWASSERT((String)("Inappropriate JSQLType: " + myType));
        return "";
    }

    public void setJavaTypeName(String javaTypeName) {
        this.jsqlType = new JSQLType(javaTypeName);
    }

    public String getPrimitiveTypeName() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return "";
        }
        switch (myType.getCategory()) {
            case 2: {
                return JSQLType.primitiveNames[myType.getPrimitiveKind()];
            }
        }
        SanityManager.THROWASSERT((String)("Inappropriate JSQLType: " + myType));
        return "";
    }

    public void castToPrimitive(boolean booleanValue) {
        this.mustCastToPrimitive = booleanValue;
    }

    public boolean mustCastToPrimitive() {
        return this.mustCastToPrimitive;
    }

    public JSQLType getJSQLType() throws StandardException {
        return this.jsqlType;
    }

    public TypeId mapToTypeID(JSQLType jsqlType) throws StandardException {
        DataTypeDescriptor dts = jsqlType.getSQLType();
        if (dts == null) {
            return null;
        }
        return dts.getTypeId();
    }

    public void markForCallStatement() {
        this.forCallStatement = true;
    }

    public abstract JavaValueNode remapColumnReferencesToExpressions() throws StandardException;

    public abstract boolean categorize(JBitSet var1, boolean var2) throws StandardException;

    abstract JavaValueNode bindExpression(FromList var1, SubqueryList var2, Vector var3) throws StandardException;

    public abstract void preprocess(int var1, FromList var2, SubqueryList var3, PredicateList var4) throws StandardException;

    Object getConstantValueAsObject() throws StandardException {
        return null;
    }

    @Override
    protected final void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateExpression(acb, mb);
    }

    protected boolean generateReceiver(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        return false;
    }

    protected int getOrderableVariantType() throws StandardException {
        return 0;
    }

    protected abstract void generateExpression(ExpressionClassBuilder var1, MethodBuilder var2) throws StandardException;

    protected final boolean generateReceiver(ExpressionClassBuilder acb, MethodBuilder mb, JavaValueNode receiver) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        if (!this.valueReturnedToSQLDomain()) {
            if (ClassInspector.primitiveType(this.getJavaTypeName())) {
                return false;
            }
        }
        String receiverClassName = receiver.getJavaTypeName();
        this.receiverField = acb.newFieldDeclaration(2, receiverClassName);
        receiver.generateExpression(acb, mb);
        mb.putField(this.receiverField);
        return true;
    }

    protected final void getReceiverExpression(ExpressionClassBuilder acb, MethodBuilder mb, JavaValueNode receiver) throws StandardException {
        if (this.receiverField != null) {
            mb.getField(this.receiverField);
        } else {
            receiver.generateExpression(acb, mb);
        }
    }

    protected void returnValueToSQLDomain() {
        this.valueReturnedToSQLDomain = true;
    }

    protected boolean valueReturnedToSQLDomain() {
        return this.valueReturnedToSQLDomain;
    }

    protected void markReturnValueDiscarded() {
        this.returnValueDiscarded = true;
    }

    protected boolean returnValueDiscarded() {
        return this.returnValueDiscarded;
    }

    public void checkReliability(ValueNode sqlNode) throws StandardException {
        sqlNode.checkReliability(4, "42Z00.U");
    }

    public int getCollationType() {
        return this.collationType;
    }

    public void setCollationType(int type) {
        this.collationType = type;
    }
}

