/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTypeCompiler;

public class JSONTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        return otherType.isStringTypeId();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        return otherType.isStringTypeId();
    }

    @Override
    public String interfaceName() {
        return "com.pivotal.gemfirexd.internal.iapi.types.StringDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 475: {
                return "com.pivotal.gemfirexd.internal.iapi.types.JSON";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in getCorrespondingPrimitiveTypeName() - " + formatId));
        return null;
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return dts.getMaximumWidth();
    }

    @Override
    String nullMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 475: {
                return "getNullJSON";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in nullMethodName() - " + formatId));
        return null;
    }

    @Override
    String dataValueMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 475: {
                return "getJSONDataValue";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in dataValueMethodName() - " + formatId));
        return null;
    }

    @Override
    boolean pushCollationForDataValue(int collationType) {
        return collationType != 0;
    }
}

