/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstraintDefinitionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ConstraintInfo;

public final class FKConstraintDefinitionNode
extends ConstraintDefinitionNode {
    TableName refTableName;
    ResultColumnList refRcl;
    SchemaDescriptor refTableSd;
    int refActionDeleteRule;
    int refActionUpdateRule;

    @Override
    public void init(Object constraintName, Object refTableName, Object fkRcl, Object refRcl, Object refActions) {
        super.init(constraintName, ReuseFactory.getInteger(6), fkRcl, null, null, null);
        this.refRcl = (ResultColumnList)refRcl;
        this.refTableName = (TableName)refTableName;
        this.refActionDeleteRule = ((int[])refActions)[0];
        this.refActionUpdateRule = ((int[])refActions)[1];
    }

    @Override
    protected void bind(DDLStatementNode ddlNode, DataDictionary dd) throws StandardException {
        if (this.refActionDeleteRule != 2 && this.refActionDeleteRule != 1) {
            throw StandardException.newException("0A000.S.12");
        }
        super.bind(ddlNode, dd);
        this.refTableSd = this.getSchemaDescriptor(this.refTableName.getSchemaName());
        if (this.refTableSd.isSystemSchema()) {
            throw StandardException.newException("42Y08");
        }
        if (this.refTableName.equals(ddlNode.getObjectName())) {
            return;
        }
        TableDescriptor td = this.getTableDescriptor(this.refTableName.getTableName(), this.refTableSd);
        if (td == null && Misc.getMemStoreBooting().isHadoopGfxdLonerMode()) {
            return;
        }
        if (td == null) {
            throw StandardException.newException("X0Y46.S", (Object)this.getConstraintMoniker(), (Object)this.refTableName.getTableName());
        }
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        this.getCompilerContext().createDependency(td);
        if (this.refRcl.size() == 0 && td.getPrimaryKey() != null) {
            int[] refCols = td.getPrimaryKey().getReferencedColumns();
            for (int i = 0; i < refCols.length; ++i) {
                ColumnDescriptor cd = td.getColumnDescriptor(refCols[i]);
                cd.setTableDescriptor(td);
                if (!this.isPrivilegeCollectionRequired()) continue;
                this.getCompilerContext().addRequiredColumnPriv(cd);
            }
        } else {
            for (int i = 0; i < this.refRcl.size(); ++i) {
                ResultColumn rc = (ResultColumn)this.refRcl.elementAt(i);
                ColumnDescriptor cd = td.getColumnDescriptor(rc.getName());
                if (cd == null) continue;
                cd.setTableDescriptor(td);
                if (!this.isPrivilegeCollectionRequired()) continue;
                this.getCompilerContext().addRequiredColumnPriv(cd);
            }
        }
        this.getCompilerContext().popCurrentPrivType();
    }

    public ConstraintInfo getReferencedConstraintInfo() {
        SanityManager.ASSERT((this.refTableSd != null ? 1 : 0) != 0, (String)"You must call bind() before calling getConstraintInfo");
        return new ConstraintInfo(this.refTableName.getTableName(), this.refTableSd, this.refRcl.getColumnNames(), this.refActionDeleteRule, this.refActionUpdateRule);
    }

    public TableName getRefTableName() {
        return this.refTableName;
    }

    int getPrivType() {
        return 2;
    }
}

