/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;

public class DropViewNode
extends DDLStatementNode {
    private boolean onlyIfExists;

    @Override
    public void init(Object dropObjectName, Object onlyIfExists) throws StandardException {
        this.initAndCheck(dropObjectName);
        this.onlyIfExists = (Boolean)onlyIfExists;
    }

    @Override
    public String statementToString() {
        return "DROP VIEW";
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        CompilerContext cc = this.getCompilerContext();
        SchemaDescriptor sd = null;
        try {
            sd = this.getSchemaDescriptor();
        }
        catch (StandardException e) {
            if (e.getSQLState().equals("42Y07") && this.onlyIfExists) {
                return;
            }
            throw e;
        }
        TableDescriptor td = dd.getTableDescriptor(this.getRelativeName(), sd, this.getLanguageConnectionContext().getTransactionCompile());
        if (td != null) {
            cc.createDependency(td);
        }
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        SchemaDescriptor sd;
        block2: {
            sd = null;
            try {
                sd = this.getSchemaDescriptor();
            }
            catch (StandardException e) {
                if (e.getSQLState().equals("42Y07") && this.onlyIfExists) break block2;
                throw e;
            }
        }
        return this.getGenericConstantActionFactory().getDropViewConstantAction(this.getFullName(), this.getRelativeName(), sd, this.onlyIfExists);
    }
}

