/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;

public class DropTableNode
extends DDLStatementNode {
    private long conglomerateNumber;
    private boolean onlyIfExists;
    private SchemaDescriptor sd;
    private int dropBehavior;
    private TableDescriptor td;

    @Override
    public void init(Object dropObjectName, Object onlyIfExists, Object dropBehavior) throws StandardException {
        this.initAndCheck(dropObjectName);
        this.dropBehavior = (Integer)dropBehavior;
        this.onlyIfExists = (Boolean)onlyIfExists;
    }

    @Override
    public String toString() {
        return super.toString() + "conglomerateNumber: " + this.conglomerateNumber + "\ntd: " + (this.td == null ? "null" : this.td.toString()) + "\nonlyIfExists: " + this.onlyIfExists + '\n' + "dropBehavior: \n" + this.dropBehavior + "\n";
    }

    @Override
    public String statementToString() {
        return "DROP TABLE";
    }

    @Override
    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        if (this.onlyIfExists) {
            try {
                this.td = this.getTableDescriptor();
            }
            catch (StandardException se) {
                if ("42Y55".equals(se.getMessageId())) {
                    this.td = null;
                    this.sd = this.getSchemaDescriptor();
                    return;
                }
                if ("42Y07".equals(se.getMessageId())) {
                    this.td = null;
                    this.sd = null;
                    return;
                }
                throw se;
            }
        } else {
            this.td = this.getTableDescriptor();
        }
        this.sd = this.getSchemaDescriptor(this.td.getTableType() != 3);
        this.conglomerateNumber = this.td.getHeapConglomerateId();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(this.conglomerateNumber);
        cc.createDependency(this.td);
        cc.createDependency(cd);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.sd);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropTableConstantAction(this.getFullName(), this.getRelativeName(), this.sd, this.conglomerateNumber, this.td != null ? this.td.getUUID() : null, this.onlyIfExists, this.dropBehavior);
    }
}

