/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;

public class DropAliasNode
extends DDLStatementNode {
    private char aliasType;
    private char nameSpace;
    private Boolean onlyIfExists;

    @Override
    public void init(Object dropAliasName, Object aliasType, Object onlyIfExists) throws StandardException {
        TableName dropItem = (TableName)dropAliasName;
        this.initAndCheck(dropItem);
        this.aliasType = ((Character)aliasType).charValue();
        this.onlyIfExists = (boolean)((Boolean)onlyIfExists);
        switch (this.aliasType) {
            case 'P': {
                this.nameSpace = (char)80;
                break;
            }
            case 'F': {
                this.nameSpace = (char)70;
                break;
            }
            case 'S': {
                this.nameSpace = (char)83;
                break;
            }
            case 'A': {
                this.nameSpace = (char)65;
                break;
            }
            case 'R': {
                this.nameSpace = (char)82;
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("bad type to DropAliasNode: " + this.aliasType));
            }
        }
    }

    public char getAliasType() {
        return this.aliasType;
    }

    @Override
    public String statementToString() {
        return "DROP ".concat(DropAliasNode.aliasTypeName(this.aliasType)) + (this.onlyIfExists != false ? " IF EXISTS" : "");
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        String aliasName = this.getRelativeName();
        AliasDescriptor ad = null;
        SchemaDescriptor sd = null;
        try {
            sd = this.getSchemaDescriptor();
        }
        catch (StandardException e) {
            if (e.getSQLState().equals("42Y07") && this.onlyIfExists.booleanValue()) {
                return;
            }
            throw e;
        }
        if (sd.getUUID() != null) {
            ad = dataDictionary.getAliasDescriptor(sd.getUUID().toString(), aliasName, this.nameSpace);
        }
        if (ad == null) {
            if (this.onlyIfExists.booleanValue()) {
                return;
            }
            throw StandardException.newException("42Y55", (Object)this.statementToString(), (Object)aliasName);
        }
        if (ad.getSystemAlias()) {
            throw StandardException.newException("42Y71", aliasName);
        }
        this.getCompilerContext().createDependency(ad);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        SchemaDescriptor sd;
        block2: {
            sd = null;
            try {
                sd = this.getSchemaDescriptor();
            }
            catch (StandardException e) {
                if (e.getSQLState().equals("42Y07") && this.onlyIfExists.booleanValue()) break block2;
                throw e;
            }
        }
        return this.getGenericConstantActionFactory().getDropAliasConstantAction(sd, this.getRelativeName(), this.nameSpace, this.onlyIfExists);
    }

    private static String aliasTypeName(char actualType) {
        String typeName = null;
        switch (actualType) {
            case 'P': {
                typeName = "PROCEDURE";
                break;
            }
            case 'F': {
                typeName = "FUNCTION";
                break;
            }
            case 'S': {
                typeName = "SYNONYM";
                break;
            }
            case 'A': {
                typeName = "TYPE";
                break;
            }
            case 'R': {
                typeName = "PROCEDURE RESULT PROCESSOR";
            }
        }
        return typeName;
    }
}

