/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTypeCompiler;

public class DateTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (otherType.isStringTypeId() && !otherType.isLongConcatableTypeId()) {
            return true;
        }
        return this.getStoredFormatIdFromTypeId() == otherType.getTypeFormatId();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        int otherJDBCTypeId = otherType.getJDBCTypeId();
        if (otherJDBCTypeId == 91 || otherJDBCTypeId == 1 || otherJDBCTypeId == 12) {
            return true;
        }
        return cf.getClassInspector().assignableTo(otherType.getCorrespondingJavaTypeName(), "java.sql.Date");
    }

    @Override
    public String interfaceName() {
        return "com.pivotal.gemfirexd.internal.iapi.types.DateTimeDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "java.sql.Date";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return 10;
    }

    @Override
    String nullMethodName() {
        return "getNullDate";
    }
}

