/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public final class DB2LengthOperatorNode
extends UnaryOperatorNode {
    @Override
    public void init(Object operand) {
        super.init(operand, "length", "getDB2Length");
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregateVector);
        TypeId operandType = this.operand.getTypeId();
        if (operandType.isXMLTypeId()) {
            throw StandardException.newException("42X25", (Object)this.getOperatorString(), (Object)operandType.getSQLTypeName());
        }
        this.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(4), this.operand.getTypeServices().isNullable()));
        return this;
    }

    @Override
    public String getReceiverInterfaceName() {
        return "com.pivotal.gemfirexd.internal.iapi.types.ConcatableDataValue";
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.operand == null) {
            return;
        }
        int constantLength = this.getConstantLength();
        String resultTypeName = this.getTypeCompiler().interfaceName();
        mb.pushThis();
        this.operand.generateExpression(acb, mb);
        mb.upCast("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor");
        mb.push(constantLength);
        LocalField field = acb.newFieldDeclaration(2, resultTypeName);
        mb.getField(field);
        mb.callMethod((short)182, "com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", this.methodName, resultTypeName, 3);
        mb.putField(field);
    }

    private int getConstantLength() throws StandardException {
        DataTypeDescriptor typeDescriptor = this.operand.getTypeServices();
        switch (typeDescriptor.getJDBCTypeId()) {
            case -5: {
                return 8;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case -2: 
            case 1: {
                return typeDescriptor.getMaximumWidth();
            }
            case 91: {
                return 4;
            }
            case 2: 
            case 3: {
                return typeDescriptor.getPrecision() / 2 + 1;
            }
            case 8: {
                return 8;
            }
            case 4: 
            case 6: 
            case 7: {
                return 4;
            }
            case 5: {
                return 2;
            }
            case 92: {
                return 3;
            }
            case 93: {
                return 10;
            }
            case -6: {
                return 1;
            }
            case -4: 
            case -3: 
            case -1: 
            case 12: 
            case 2004: {
                return this.getConstantNodeLength();
            }
        }
        return -1;
    }

    private int getConstantNodeLength() throws StandardException {
        if (this.operand instanceof ConstantNode) {
            return ((ConstantNode)this.operand).getValue().getLength();
        }
        return -1;
    }
}

