/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.pivotal.gemfirexd.internal.engine.ddl.ServerGroupsTableAttribute;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import java.util.Map;

public class CreateGatewaySenderNode
extends DDLStatementNode {
    private String senderId;
    private int remoteDsId;
    private boolean enableBatchConflation = false;
    private boolean enablePersistence = false;
    private String diskStoreName;
    private boolean diskSynchronous = false;
    private ServerGroupsTableAttribute serverGroups;
    private int socketBufferSize = 524288;
    private boolean manualStart = false;
    private int socketReadTimeout = GatewaySender.DEFAULT_SOCKET_READ_TIMEOUT;
    private int batchSize = 100;
    private int batchTimeInterval = 1000;
    private int maximumQueueMemory = 100;
    private int alertThreshold = 0;
    private boolean isParallel = false;
    public static final String SOCKETBUFFERSIZE = "socketbuffersize";
    public static final String MANUALSTART = "manualstart";
    public static final String SOCKETREADTIMEOUT = "socketreadtimeout";
    public static final String ENABLEBATCHCONFLATION = "enablebatchconflation";
    public static final String BATCHSIZE = "batchsize";
    public static final String BATCHTIMEINTERVAL = "batchtimeinterval";
    public static final String ENABLEPERSISTENCE = "enablepersistence";
    public static final String DISKSYNCHRONOUS = "disksynchronous";
    public static final String DISKSTORENAME = "diskstorename";
    public static final String MAXQUEUEMEMORY = "maxqueuememory";
    public static final String ALERTTHRESHOLD = "alertthreshold";
    public static final String ISPARALLEL = "isparallel";

    public String getName() {
        return "CreateGatewaySender";
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3, Object arg4) throws StandardException {
        this.senderId = (String)arg1;
        this.remoteDsId = (Integer)arg2;
        this.serverGroups = (ServerGroupsTableAttribute)arg3;
        Map attrs = (Map)arg4;
        for (Map.Entry entry : attrs.entrySet()) {
            String key = (String)entry.getKey();
            Object vn = entry.getValue();
            if (key.equalsIgnoreCase(SOCKETBUFFERSIZE)) {
                this.socketBufferSize = (Integer)vn;
                continue;
            }
            if (key.equalsIgnoreCase(MANUALSTART)) {
                this.manualStart = (Boolean)vn;
                continue;
            }
            if (key.equalsIgnoreCase(SOCKETREADTIMEOUT)) {
                this.socketReadTimeout = (Integer)vn;
                continue;
            }
            if (key.equalsIgnoreCase(ENABLEBATCHCONFLATION)) {
                this.enableBatchConflation = (Boolean)vn;
                continue;
            }
            if (key.equalsIgnoreCase(BATCHSIZE)) {
                this.batchSize = (Integer)vn;
                continue;
            }
            if (key.equalsIgnoreCase(BATCHTIMEINTERVAL)) {
                this.batchTimeInterval = (Integer)vn;
                continue;
            }
            if (key.equalsIgnoreCase(ENABLEPERSISTENCE)) {
                this.enablePersistence = (Boolean)vn;
                continue;
            }
            if (key.equalsIgnoreCase(DISKSYNCHRONOUS)) {
                this.diskSynchronous = (Boolean)vn;
                continue;
            }
            if (key.equalsIgnoreCase(DISKSTORENAME)) {
                this.diskStoreName = (String)vn;
                continue;
            }
            if (key.equalsIgnoreCase(MAXQUEUEMEMORY)) {
                this.maximumQueueMemory = (Integer)vn;
                continue;
            }
            if (key.equalsIgnoreCase(ALERTTHRESHOLD)) {
                this.alertThreshold = (Integer)vn;
                continue;
            }
            if (!key.equalsIgnoreCase(ISPARALLEL)) continue;
            this.isParallel = (Boolean)vn;
        }
        DistributionDescriptor.checkAvailableDataStore(this.getLanguageConnectionContext(), this.serverGroups != null ? this.serverGroups.getServerGroupSet() : null, "CREATE GATEWAYSENDER " + this.senderId);
    }

    @Override
    public ConstantAction makeConstantAction() {
        return this.getGenericConstantActionFactory().getCreateGatewaySenderConstantAction(this.senderId, this.serverGroups, this.socketBufferSize, this.manualStart, this.socketReadTimeout, this.enableBatchConflation, this.batchSize, this.batchTimeInterval, this.enablePersistence, this.diskSynchronous, this.diskStoreName, this.maximumQueueMemory, this.alertThreshold, this.remoteDsId, this.isParallel);
    }

    @Override
    public String statementToString() {
        return "CREATE GATEWAYSENDER";
    }

    public static void dummy() {
    }
}

