/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ConstantQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public abstract class ConstantNode
extends ValueNode {
    DataValueDescriptor value;
    protected String columnName;
    protected int columnNumber;
    protected int maxWidth;

    @Override
    public void init(Object typeId, Object nullable, Object maximumWidth) throws StandardException {
        this.setType((TypeId)typeId, (Boolean)nullable, (Integer)maximumWidth);
    }

    ConstantNode() {
    }

    public void setValue(DataValueDescriptor value) {
        this.value = value;
    }

    public DataValueDescriptor getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "value: " + this.value + "\n" + super.toString();
    }

    @Override
    public boolean isCloneable() {
        return true;
    }

    @Override
    public ValueNode getClone() {
        return this;
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        return this;
    }

    @Override
    public boolean isConstantExpression() {
        return true;
    }

    @Override
    public boolean constantExpression(PredicateList whereClause) {
        return true;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.isNull()) {
            acb.generateNull(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        } else {
            this.generateConstant(acb, mb);
            acb.generateDataValue(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType(), null);
        }
    }

    abstract void generateConstant(ExpressionClassBuilder var1, MethodBuilder var2) throws StandardException;

    boolean isNull() {
        return this.value == null || this.value.isNull();
    }

    @Override
    protected int getOrderableVariantType() {
        return 3;
    }

    @Override
    public boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            ConstantNode other = (ConstantNode)o;
            return other.getValue() == null && this.getValue() == null || other.getValue() != null && other.getValue().compare(this.getValue()) == 0;
        }
        return false;
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        ConstantQueryInfo cqi = new ConstantQueryInfo(this.value);
        cqi.setMaxWidth(this.maxWidth);
        return cqi;
    }

    public void setCorrespondingColumnInfo(String colName, int colNumber, int maxWidth) {
        this.columnName = colName;
        this.columnNumber = colNumber;
        this.maxWidth = maxWidth;
    }

    @Override
    public String printExplainInfo() {
        try {
            return this.value.getTraceString();
        }
        catch (StandardException e) {
            return " ";
        }
    }

    @Override
    public String ncjGenerateSql() {
        try {
            if (this.value instanceof SQLChar) {
                return "'" + this.value.getString() + "'";
            }
            return this.value.getString();
        }
        catch (StandardException e) {
            SanityManager.THROWASSERT((Throwable)e);
            return null;
        }
    }
}

