/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryComparisonOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CastNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UntypedNullConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNodeList;
import java.util.Vector;

public class ConditionalNode
extends ValueNode {
    ValueNode testCondition;
    ValueNodeList thenElseList;
    boolean thisIsNullIfNode;

    @Override
    public void init(Object testCondition, Object thenElseList, Object thisIsNullIfNode) {
        this.testCondition = (ValueNode)testCondition;
        this.thenElseList = (ValueNodeList)thenElseList;
        this.thisIsNullIfNode = (Boolean)thisIsNullIfNode;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.testCondition != null) {
            this.printLabel(depth, "testCondition: ");
            this.testCondition.treePrint(depth + 1);
        }
        if (this.thenElseList != null) {
            this.printLabel(depth, "thenElseList: ");
            this.thenElseList.treePrint(depth + 1);
        }
    }

    private boolean isCastNode(ValueNode node) {
        return node.getNodeType() == 60;
    }

    private boolean isCastToChar(ValueNode node) throws StandardException {
        return node.getTypeServices().getTypeName().equals("CHAR");
    }

    private boolean isNullNode(ValueNode node) {
        return this.isCastNode(node) && ((CastNode)node).castOperand instanceof UntypedNullConstantNode;
    }

    private boolean isConditionalNode(ValueNode node) {
        return node.getNodeType() == 54;
    }

    private boolean shouldCast(DataTypeDescriptor newType, DataTypeDescriptor oldType) throws StandardException {
        return newType != null && (oldType == null || !oldType.getTypeId().equals(newType.getTypeId()));
    }

    private DataTypeDescriptor findType(ValueNodeList thenElseList, FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        ValueNode thenNode = ((ValueNode)thenElseList.elementAt(0)).bindExpression(fromList, subqueryList, aggregateVector);
        ValueNode elseNode = ((ValueNode)thenElseList.elementAt(1)).bindExpression(fromList, subqueryList, aggregateVector);
        DataTypeDescriptor thenType = thenNode.getTypeServices();
        DataTypeDescriptor elseType = elseNode.getTypeServices();
        DataTypeDescriptor theType = null;
        if (thenType != null && !this.isCastNode(thenNode) && !this.isConditionalNode(thenNode)) {
            return thenType;
        }
        if (this.isCastNode(thenNode) && !this.isCastToChar(thenNode)) {
            return thenNode.getTypeServices();
        }
        if (elseType != null && !this.isCastNode(elseNode) && !this.isConditionalNode(elseNode)) {
            return elseType;
        }
        if (this.isCastNode(elseNode) && !this.isCastToChar(elseNode)) {
            return elseNode.getTypeServices();
        }
        if (this.isConditionalNode(thenNode)) {
            theType = this.findType(((ConditionalNode)thenNode).thenElseList, fromList, subqueryList, aggregateVector);
        }
        if (theType != null) {
            return theType;
        }
        if (this.isConditionalNode(elseNode)) {
            theType = this.findType(((ConditionalNode)elseNode).thenElseList, fromList, subqueryList, aggregateVector);
        }
        if (theType != null) {
            return theType;
        }
        return null;
    }

    private void recastNullNodes(ValueNodeList thenElseList, DataTypeDescriptor castType, FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        if (castType == null) {
            return;
        }
        castType = castType.getNullabilityType(true);
        ValueNode thenNode = (ValueNode)thenElseList.elementAt(0);
        ValueNode elseNode = (ValueNode)thenElseList.elementAt(1);
        if (this.isNullNode(thenNode) && this.shouldCast(castType, thenNode.getTypeServices())) {
            thenElseList.setElementAt(this.recastNullNode(thenNode, castType), 0);
            ((ValueNode)thenElseList.elementAt(0)).bindExpression(fromList, subqueryList, aggregateVector);
        } else if (this.isConditionalNode(thenNode)) {
            this.recastNullNodes(((ConditionalNode)thenNode).thenElseList, castType, fromList, subqueryList, aggregateVector);
        }
        if (this.isNullNode(elseNode) && this.shouldCast(castType, elseNode.getTypeServices())) {
            thenElseList.setElementAt(this.recastNullNode(elseNode, castType), 1);
            ((ValueNode)thenElseList.elementAt(1)).bindExpression(fromList, subqueryList, aggregateVector);
        } else if (this.isConditionalNode(elseNode)) {
            this.recastNullNodes(((ConditionalNode)elseNode).thenElseList, castType, fromList, subqueryList, aggregateVector);
        }
    }

    private QueryTreeNode recastNullNode(ValueNode nodeToCast, DataTypeDescriptor typeToUse) throws StandardException {
        QueryTreeNode cast = this.getNodeFactory().getNode(60, ((CastNode)nodeToCast).castOperand, typeToUse, this.getContextManager());
        return cast;
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.testCondition = this.testCondition.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.thisIsNullIfNode) {
            BinaryComparisonOperatorNode bcon = (BinaryComparisonOperatorNode)this.testCondition;
            QueryTreeNode cast = this.getNodeFactory().getNode(60, this.thenElseList.elementAt(0), bcon.getLeftOperand().getTypeServices().getNullabilityType(true), this.getContextManager());
            this.thenElseList.setElementAt(cast, 0);
            this.thenElseList.bindExpression(fromList, subqueryList, aggregateVector);
        } else {
            this.recastNullNodes(this.thenElseList, this.findType(this.thenElseList, fromList, subqueryList, aggregateVector), fromList, subqueryList, aggregateVector);
        }
        ValueNode thenExpression = (ValueNode)this.thenElseList.elementAt(0);
        ValueNode elseExpression = (ValueNode)this.thenElseList.elementAt(1);
        if (this.testCondition.requiresTypeFromContext()) {
            this.testCondition.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, true));
        } else if (!this.testCondition.getTypeServices().getTypeId().equals(TypeId.BOOLEAN_ID)) {
            throw StandardException.newException("42X88");
        }
        if (this.thenElseList.containsAllParameterNodes()) {
            throw StandardException.newException("42X87", "conditional");
        }
        if (this.thenElseList.containsParameterNode()) {
            DataTypeDescriptor dts = thenExpression.requiresTypeFromContext() ? elseExpression.getTypeServices() : thenExpression.getTypeServices();
            this.thenElseList.setParameterDescriptor(dts);
        }
        ClassInspector cu = this.getClassFactory().getClassInspector();
        if (!(thenExpression.getTypeServices().comparable(elseExpression.getTypeServices(), false, this.getClassFactory()) || cu.assignableTo(thenExpression.getTypeId().getCorrespondingJavaTypeName(), elseExpression.getTypeId().getCorrespondingJavaTypeName()) || cu.assignableTo(elseExpression.getTypeId().getCorrespondingJavaTypeName(), thenExpression.getTypeId().getCorrespondingJavaTypeName()))) {
            throw StandardException.newException("42X89", (Object)thenExpression.getTypeId().getSQLTypeName(), (Object)elseExpression.getTypeId().getSQLTypeName());
        }
        this.setType(this.thenElseList.getDominantTypeServices());
        TypeId condTypeId = this.getTypeId();
        TypeId thenTypeId = ((ValueNode)this.thenElseList.elementAt(0)).getTypeId();
        TypeId elseTypeId = ((ValueNode)this.thenElseList.elementAt(1)).getTypeId();
        if (thenTypeId.typePrecedence() != condTypeId.typePrecedence()) {
            ValueNode cast = (ValueNode)this.getNodeFactory().getNode(60, this.thenElseList.elementAt(0), this.getTypeServices(), this.getContextManager());
            cast = cast.bindExpression(fromList, subqueryList, aggregateVector);
            this.thenElseList.setElementAt(cast, 0);
        } else if (elseTypeId.typePrecedence() != condTypeId.typePrecedence()) {
            ValueNode cast = (ValueNode)this.getNodeFactory().getNode(60, this.thenElseList.elementAt(1), this.getTypeServices(), this.getContextManager());
            cast = cast.bindExpression(fromList, subqueryList, aggregateVector);
            this.thenElseList.setElementAt(cast, 1);
        }
        return this;
    }

    @Override
    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.testCondition = this.testCondition.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        this.thenElseList.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        if (simplePredsOnly) {
            return false;
        }
        boolean pushable = this.testCondition.categorize(referencedTabs, simplePredsOnly);
        pushable = this.thenElseList.categorize(referencedTabs, simplePredsOnly) && pushable;
        return pushable;
    }

    @Override
    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.testCondition = this.testCondition.remapColumnReferencesToExpressions();
        this.thenElseList = this.thenElseList.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    public boolean isConstantExpression() {
        return this.testCondition.isConstantExpression() && this.thenElseList.isConstantExpression();
    }

    @Override
    public boolean constantExpression(PredicateList whereClause) {
        return this.testCondition.constantExpression(whereClause) && this.thenElseList.constantExpression(whereClause);
    }

    @Override
    public ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        if (!underNotNode) {
            return this;
        }
        ValueNode thenExpression = (ValueNode)this.thenElseList.elementAt(0);
        ValueNode elseExpression = (ValueNode)this.thenElseList.elementAt(1);
        this.thenElseList.setElementAt(elseExpression, 0);
        this.thenElseList.setElementAt(thenExpression, 1);
        return this;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.testCondition.generateExpression(acb, mb);
        mb.cast("com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue");
        mb.push(true);
        mb.callMethod((short)185, null, "equals", "boolean", 1);
        mb.conditionalIf();
        ((ValueNode)this.thenElseList.elementAt(0)).generateExpression(acb, mb);
        mb.startElseCode();
        ((ValueNode)this.thenElseList.elementAt(1)).generateExpression(acb, mb);
        mb.completeConditional();
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.testCondition != null && !v.stopTraversal()) {
            this.testCondition = (ValueNode)this.testCondition.accept(v);
        }
        if (this.thenElseList != null && !v.stopTraversal()) {
            this.thenElseList = (ValueNodeList)this.thenElseList.accept(v);
        }
        return returnNode;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            ConditionalNode other = (ConditionalNode)o;
            if (this.thenElseList.size() == other.thenElseList.size() && this.testCondition.isEquivalent(other.testCondition)) {
                int sz = this.thenElseList.size();
                for (int i = 0; i < sz; ++i) {
                    ValueNode v2;
                    ValueNode v1 = (ValueNode)this.thenElseList.elementAt(i);
                    if (v1.isEquivalent(v2 = (ValueNode)other.thenElseList.elementAt(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        return QueryInfoConstants.DUMMY;
    }

    @Override
    public ValueNode genExpressionOperands(ResultColumnList outerResultColumns, ResultColumn parentRC, boolean remapToNew) throws StandardException {
        if (parentRC != null) {
            parentRC.markExpanded();
        }
        this.testCondition = this.testCondition.genExpressionOperands(outerResultColumns, null, remapToNew);
        int tELsize = this.thenElseList.size();
        if (tELsize > 0) {
            ValueNodeList vnl = new ValueNodeList();
            for (int i = 0; i < tELsize; ++i) {
                ValueNode vn = ((ValueNode)this.thenElseList.elementAt(i)).genExpressionOperands(outerResultColumns, null, remapToNew);
                vnl.addElement(vn);
            }
            this.thenElseList = vnl;
        }
        return this;
    }
}

