/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.types.StringDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public final class CharConstantNode
extends ConstantNode {
    @Override
    public void init(Object arg1) throws StandardException {
        if (arg1 instanceof TypeId) {
            super.init(arg1, Boolean.TRUE, ReuseFactory.getInteger(0));
        } else {
            String val = (String)arg1;
            super.init(this.getCompilerContext().convertCharConstToVarchar() ? TypeId.VARCHAR_ID : TypeId.CHAR_ID, val == null ? Boolean.TRUE : Boolean.FALSE, val != null ? ReuseFactory.getInteger(val.length()) : ReuseFactory.getInteger(0));
            this.setValue(this.getDataValueFactory().getCharDataValue(val));
        }
    }

    @Override
    public void init(Object newValue, Object newLength) throws StandardException {
        String val = (String)newValue;
        int newLen = (Integer)newLength;
        super.init(TypeId.CHAR_ID, val == null ? Boolean.TRUE : Boolean.FALSE, newLength);
        if (val != null) {
            if (val.length() > newLen) {
                throw StandardException.newException("22001", (Object)"CHAR", (Object)val, (Object)String.valueOf(newLen));
            }
            while (val.length() < newLen) {
                val = val + ' ';
            }
        }
        this.setValue(this.getDataValueFactory().getCharDataValue(val));
    }

    public String getString() throws StandardException {
        return this.value.getString();
    }

    @Override
    public Object getConstantValueAsObject() throws StandardException {
        return this.value.getString();
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.setCollationUsingCompilationSchema();
        this.value = ((StringDataValue)this.value).getValue(this.getLanguageConnectionContext().getDataValueFactory().getCharacterCollator(this.getTypeServices().getCollationType()));
        return this;
    }

    @Override
    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        mb.push(this.getString());
    }
}

