/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.sql.compile.ParameterizedConstantNode;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryLogicalOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryRelationalOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BooleanConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrListNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RelationalOperator;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class AndNode
extends BinaryLogicalOperatorNode {
    @Override
    public void init(Object leftOperand, Object rightOperand) {
        super.init(leftOperand, rightOperand, "and");
        this.shortCircuitValue = false;
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        super.bindExpression(fromList, subqueryList, aggregateVector);
        this.postBindFixup();
        return this;
    }

    @Override
    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        if (this.leftOperand instanceof OrNode) {
            ((OrNode)this.leftOperand).setFirstOr();
            if (!this.rightOperand.isBooleanTrue()) {
                CompilerContext cc = this.getCompilerContext();
                if (cc.hasOrList()) {
                    throw StandardException.newException("0A000.S.23");
                }
                cc.setOrListOptimizationFlag(false);
            }
        }
        this.leftOperand = this.leftOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (this.leftOperand instanceof AndNode) {
            if (this.leftOperand instanceof OrListNode) {
                if (this.rightOperand.isBooleanTrue()) {
                    return this.leftOperand;
                }
            } else {
                this.changeToCNF(false);
            }
        }
        this.rightOperand = this.rightOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    @Override
    public ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        this.leftOperand = this.leftOperand.eliminateNots(underNotNode);
        this.rightOperand = this.rightOperand.eliminateNots(underNotNode);
        if (!underNotNode) {
            return this;
        }
        ValueNode orNode = (ValueNode)this.getNodeFactory().getNode(52, this.leftOperand, this.rightOperand, this.getContextManager());
        orNode.setType(this.getTypeServices());
        return orNode;
    }

    @Override
    public ValueNode putAndsOnTop() throws StandardException {
        SanityManager.ASSERT((this.rightOperand != null ? 1 : 0) != 0, (String)"rightOperand is expected to be non-null");
        this.rightOperand = this.rightOperand.putAndsOnTop();
        return this;
    }

    @Override
    public boolean verifyPutAndsOnTop() {
        boolean isValid = true;
        boolean bl = isValid = this.rightOperand instanceof AndNode || this.rightOperand.isBooleanTrue();
        if (this.rightOperand instanceof AndNode) {
            isValid = this.rightOperand.verifyPutAndsOnTop();
        }
        return isValid;
    }

    @Override
    public ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        AndNode curAnd = this;
        if (!(this.rightOperand instanceof AndNode) && !this.rightOperand.isBooleanTrue()) {
            BooleanConstantNode trueNode = (BooleanConstantNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
            curAnd.setRightOperand((ValueNode)this.getNodeFactory().getNode(39, curAnd.getRightOperand(), trueNode, this.getContextManager()));
            ((AndNode)curAnd.getRightOperand()).postBindFixup();
        }
        while (this.leftOperand instanceof AndNode) {
            ValueNode newLeft = ((AndNode)this.leftOperand).getLeftOperand();
            AndNode oldLeft = (AndNode)this.leftOperand;
            AndNode newRight = (AndNode)this.leftOperand;
            ValueNode oldRight = this.rightOperand;
            this.leftOperand = newLeft;
            this.rightOperand = newRight;
            newRight.setLeftOperand(oldLeft.getRightOperand());
            newRight.setRightOperand(oldRight);
        }
        this.leftOperand = this.leftOperand.changeToCNF(underTopAndNode);
        this.rightOperand = this.rightOperand.changeToCNF(underTopAndNode);
        return this;
    }

    @Override
    public boolean verifyChangeToCNF() {
        boolean isValid = true;
        boolean bl = isValid = this.rightOperand instanceof AndNode || this.rightOperand.isBooleanTrue();
        if (this.rightOperand instanceof AndNode) {
            isValid = this.rightOperand.verifyChangeToCNF();
        }
        isValid = this.leftOperand instanceof AndNode ? false : isValid && this.leftOperand.verifyChangeToCNF();
        return isValid;
    }

    void postBindFixup() throws StandardException {
        this.setType(this.resolveLogicalBinaryOperator(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices()));
    }

    @Override
    public double selectivity(Optimizable optTable) throws StandardException {
        return this.getLeftOperand().selectivity(optTable);
    }

    public int getLeftOperatorForCompare() {
        return ((RelationalOperator)((Object)this.getLeftOperand())).getOperator();
    }

    public boolean isUsableInSelectivity() {
        BinaryRelationalOperatorNode bron;
        ValueNode vn = this.getLeftOperand();
        return !BinaryRelationalOperatorNode.class.isAssignableFrom(vn.getClass()) || !((bron = (BinaryRelationalOperatorNode)vn).getLeftOperand() instanceof ParameterizedConstantNode) || !(bron.getRightOperand() instanceof ParameterizedConstantNode);
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        this.leftOperand.optimizeForOffHeap(shouldOptimize);
        this.rightOperand.optimizeForOffHeap(shouldOptimize);
    }

    @Override
    public int setColocatedWith(Optimizable src, Optimizable tgt, JBitSet srcPCols, JBitSet tgtPCols) throws StandardException {
        JBitSet tgtCols;
        JBitSet srcCols = new JBitSet(srcPCols.size());
        int ret = this.leftOperand.setColocatedWith(src, tgt, srcCols, tgtCols = new JBitSet(tgtPCols.size()));
        if (ret == 0) {
            return ret;
        }
        if (ret == -1 || !srcCols.equals(tgtCols)) {
            return -1;
        }
        srcPCols.or(srcCols);
        tgtPCols.or(tgtCols);
        srcCols.clearAll();
        tgtCols.clearAll();
        ret = this.rightOperand.setColocatedWith(src, tgt, srcCols, tgtCols);
        if (ret == 0) {
            return ret;
        }
        if (ret == -1 || !srcCols.equals(tgtCols)) {
            return -1;
        }
        srcPCols.or(srcCols);
        tgtPCols.or(tgtCols);
        return 0;
    }
}

