/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINResultSetDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINStatementDescriptor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class XPLAINTableDescriptor {
    protected static final List<XPLAINTableDescriptor> statDescriptors = new ArrayList<XPLAINTableDescriptor>(7);
    private String tableInsertStmt;

    public static Iterator<XPLAINTableDescriptor> getRegisteredDescriptors() {
        return statDescriptors.iterator();
    }

    public static final void registerStatements(EmbedConnection conn) throws StandardException {
        LanguageConnectionContext lcc = conn.getLanguageConnection();
        if (lcc.explainStatementsExists()) {
            return;
        }
        Iterator<XPLAINTableDescriptor> i = XPLAINTableDescriptor.getRegisteredDescriptors();
        while (i.hasNext()) {
            XPLAINTableDescriptor t = i.next();
            String ins = t.getTableInsert();
            try {
                conn.prepareStatement(ins).close();
            }
            catch (SQLException e) {
                String trace = e.toString();
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    trace = SanityManager.getStackTrace((Throwable)e);
                }
                SanityManager.DEBUG_PRINT((String)"warning:TracePlanGeneration", (String)("StatementPlanCollector::doXPLAIN: got exception while enabling plan collection: " + trace));
                throw StandardException.newException(e.getSQLState(), (Throwable)e, (Object)e.getMessage());
            }
            lcc.setExplainStatement(t.getCatalogName(), ins);
        }
    }

    public abstract String getCatalogName();

    protected abstract SystemColumn[] buildColumnList();

    protected abstract void addConstraints(StringBuilder var1);

    public String[] getTableDDL(String schemaName) {
        String escapedSchema = IdUtil.normalToDelimited(schemaName);
        String escapedTableName = IdUtil.normalToDelimited(this.getCatalogName());
        SystemColumn[] cols = this.buildColumnList();
        StringBuilder buf = new StringBuilder();
        StringBuilder idx = new StringBuilder();
        StringBuilder insBuf = new StringBuilder();
        StringBuilder valsBuf = new StringBuilder();
        for (int c = 0; c < cols.length; ++c) {
            if (c == 0) {
                buf.append("(");
                insBuf.append("(");
                valsBuf.append("(");
            } else {
                buf.append(",");
                insBuf.append(",");
                valsBuf.append(",");
            }
            buf.append(cols[c].getName());
            insBuf.append(cols[c].getName());
            valsBuf.append("?");
            buf.append(" ");
            buf.append(cols[c].getType().getCatalogType().getSQLstring());
        }
        this.addConstraints(buf);
        buf.append(")");
        buf.append(" LOCAL");
        insBuf.append(")");
        valsBuf.append(")");
        String query = "create table " + escapedSchema + "." + escapedTableName + buf.toString();
        this.createIndex(idx, schemaName);
        this.tableInsertStmt = "insert into " + escapedSchema + "." + escapedTableName + insBuf.toString() + " values " + valsBuf.toString();
        return new String[]{query, idx.toString()};
    }

    protected abstract void createIndex(StringBuilder var1, String var2);

    public String getTableInsert() {
        return this.tableInsertStmt;
    }

    static {
        statDescriptors.add(new XPLAINStatementDescriptor());
        statDescriptors.add(new XPLAINResultSetDescriptor());
    }
}

