/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.StreamStorable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.RowChanger;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TupleFilter;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.IndexInfoImpl;
import java.util.Properties;

public class TabInfoImpl {
    static final int ROWNOTDUPLICATE = -1;
    private IndexInfoImpl[] indexes;
    private long heapConglomerate = -1L;
    private int numIndexesSet;
    private boolean heapSet;
    private final CatalogRowFactory crf;
    private TableDescriptor tableDescriptor;
    private boolean computedStreamStorableHeapColIds = false;
    private int[] streamStorableHeapColIds;

    TabInfoImpl(CatalogRowFactory crf) {
        this.crf = crf;
        int numIndexes = crf.getNumIndexes();
        if (numIndexes > 0) {
            this.indexes = new IndexInfoImpl[numIndexes];
            for (int indexCtr = 0; indexCtr < numIndexes; ++indexCtr) {
                this.indexes[indexCtr] = new IndexInfoImpl(indexCtr, crf);
            }
        }
    }

    long getHeapConglomerate() {
        return this.heapConglomerate;
    }

    void setHeapConglomerate(long heapConglomerate) {
        this.heapConglomerate = heapConglomerate;
        this.heapSet = true;
    }

    public long getIndexConglomerate(int indexID) {
        SanityManager.ASSERT((this.indexes != null ? 1 : 0) != 0, (String)"indexes is expected to be non-null");
        if (indexID >= this.indexes.length) {
            SanityManager.THROWASSERT((String)("indexID (" + indexID + ") is out of range(0-" + this.indexes.length + ")"));
        }
        return this.indexes[indexID].getConglomerateNumber();
    }

    public IndexInfoImpl getIndexInfoImpl(int indexId) {
        return this.indexes[indexId];
    }

    void setIndexConglomerate(int index, long indexConglomerate) {
        SanityManager.ASSERT((this.indexes[index] != null ? 1 : 0) != 0, (String)"indexes[index] expected to be non-null");
        SanityManager.ASSERT((this.indexes[index].getConglomerateNumber() == -1L ? 1 : 0) != 0, (String)"indexes[index] expected to be -1");
        this.indexes[index].setConglomerateNumber(indexConglomerate);
        ++this.numIndexesSet;
    }

    void setIndexConglomerate(ConglomerateDescriptor cd) {
        int index;
        String indexName = cd.getConglomerateName();
        SanityManager.ASSERT((this.indexes != null ? 1 : 0) != 0, (String)"indexes is expected to be non-null");
        for (index = 0; index < this.indexes.length; ++index) {
            SanityManager.ASSERT((this.indexes[index] != null ? 1 : 0) != 0, (String)"indexes[index] expected to be non-null");
            SanityManager.ASSERT((this.indexes[index].getIndexName() != null ? 1 : 0) != 0, (String)"indexes[index].getIndexName() expected to be non-null");
            if (!this.indexes[index].getIndexName().equals(indexName)) continue;
            this.indexes[index].setConglomerateNumber(cd.getConglomerateNumber());
            break;
        }
        if (index == this.indexes.length) {
            SanityManager.THROWASSERT((String)("match not found for " + indexName));
        }
        ++this.numIndexesSet;
    }

    public String getTableName() {
        return this.crf.getCatalogName();
    }

    public TableDescriptor getTableDescriptor() {
        return this.tableDescriptor;
    }

    void setTableDescriptor(TableDescriptor td) {
        this.tableDescriptor = td;
    }

    String getIndexName(int indexId) {
        return this.indexes[indexId].getIndexName();
    }

    public CatalogRowFactory getCatalogRowFactory() {
        return this.crf;
    }

    boolean isComplete() {
        if (!this.heapSet) {
            return false;
        }
        return this.indexes == null || this.indexes.length == this.numIndexesSet;
    }

    int getIndexColumnCount(int indexNumber) {
        SanityManager.ASSERT((this.indexes != null ? 1 : 0) != 0, (String)"indexes is expected to be non-null");
        if (indexNumber >= this.indexes.length) {
            SanityManager.THROWASSERT((String)("indexNumber (" + indexNumber + ") is out of range(0-" + this.indexes.length + ")"));
        }
        return this.indexes[indexNumber].getColumnCount();
    }

    IndexRowGenerator getIndexRowGenerator(int indexNumber) {
        SanityManager.ASSERT((this.indexes != null ? 1 : 0) != 0, (String)"indexes is expected to be non-null");
        if (indexNumber >= this.indexes.length) {
            SanityManager.THROWASSERT((String)("indexNumber (" + indexNumber + ") is out of range(0-" + this.indexes.length + ")"));
        }
        return this.indexes[indexNumber].getIndexRowGenerator();
    }

    void setIndexRowGenerator(int indexNumber, IndexRowGenerator irg) {
        SanityManager.ASSERT((this.indexes != null ? 1 : 0) != 0, (String)"indexes is expected to be non-null");
        if (indexNumber >= this.indexes.length) {
            SanityManager.THROWASSERT((String)("indexNumber (" + indexNumber + ") is out of range(0-" + this.indexes.length + ")"));
        }
        this.indexes[indexNumber].setIndexRowGenerator(irg);
    }

    int getNumberOfIndexes() {
        if (this.indexes == null) {
            return 0;
        }
        return this.indexes.length;
    }

    int getBaseColumnPosition(int indexNumber, int colNumber) {
        SanityManager.ASSERT((this.indexes != null ? 1 : 0) != 0, (String)"indexes is expected to be non-null");
        if (indexNumber >= this.indexes.length) {
            SanityManager.THROWASSERT((String)("indexNumber (" + indexNumber + ") is out of range(0-" + this.indexes.length + ")"));
        }
        return this.indexes[indexNumber].getBaseColumnPosition(colNumber);
    }

    boolean isIndexUnique(int indexNumber) {
        SanityManager.ASSERT((this.indexes != null ? 1 : 0) != 0, (String)"indexes is expected to be non-null");
        if (indexNumber >= this.indexes.length) {
            SanityManager.THROWASSERT((String)("indexNumber (" + indexNumber + ") is out of range(0-" + this.indexes.length + ")"));
        }
        return this.indexes[indexNumber].isIndexUnique();
    }

    int insertRow(ExecRow row, TransactionController tc, boolean wait) throws StandardException {
        RowLocation[] notUsed = new RowLocation[1];
        return this.insertRowListImpl(new ExecRow[]{row}, tc, notUsed, wait);
    }

    int insertRowList(ExecRow[] rowList, TransactionController tc) throws StandardException {
        RowLocation[] notUsed = new RowLocation[1];
        return this.insertRowListImpl(rowList, tc, notUsed, true);
    }

    private int insertRowListImpl(ExecRow[] rowList, TransactionController tc, RowLocation[] rowLocationOut, boolean wait) throws StandardException {
        RowLocation heapLocation;
        int ictr;
        int retCode = -1;
        int indexCount = this.crf.getNumIndexes();
        ConglomerateController[] indexControllers = new ConglomerateController[indexCount];
        ConglomerateController heapController = tc.openConglomerate(this.getHeapConglomerate(), false, 4 | (wait ? 0 : 128), 6, 4);
        for (ictr = 0; ictr < indexCount; ++ictr) {
            long conglomNumber = this.getIndexConglomerate(ictr);
            if (conglomNumber <= -1L) continue;
            indexControllers[ictr] = tc.openConglomerate(conglomNumber, false, 4 | (wait ? 0 : 128), 6, 4);
        }
        rowLocationOut[0] = heapLocation = heapController.newRowLocationTemplate();
        for (int rowNumber = 0; rowNumber < rowList.length; ++rowNumber) {
            ExecRow row = rowList[rowNumber];
            heapLocation = heapController.insertAndFetchLocation(row.getRowArray(), heapLocation);
            for (int ictr2 = 0; ictr2 < indexCount; ++ictr2) {
                ExecIndexRow indexableRow;
                int insertRetCode;
                if (indexControllers[ictr2] == null || (insertRetCode = indexControllers[ictr2].insert((indexableRow = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(ictr2), heapLocation, row)).getRowArray())) != 1) continue;
                retCode = rowNumber;
            }
        }
        for (ictr = 0; ictr < indexCount; ++ictr) {
            if (indexControllers[ictr] == null) continue;
            indexControllers[ictr].close();
        }
        heapController.close();
        return retCode;
    }

    public int deleteRow(TransactionController tc, ExecIndexRow key, int indexNumber) throws StandardException {
        return this.deleteRows(tc, key, 1, null, null, key, -1, indexNumber, true);
    }

    int deleteRow(TransactionController tc, ExecIndexRow key, int indexNumber, boolean wait) throws StandardException {
        return this.deleteRows(tc, key, 1, null, null, key, -1, indexNumber, wait);
    }

    int deleteRows(TransactionController tc, ExecIndexRow startKey, int startOp, Qualifier[][] qualifier, TupleFilter filter, ExecIndexRow stopKey, int stopOp, int indexNumber) throws StandardException {
        return this.deleteRows(tc, startKey, startOp, qualifier, filter, stopKey, stopOp, indexNumber, true);
    }

    private int deleteRows(TransactionController tc, ExecIndexRow startKey, int startOp, Qualifier[][] qualifier, TupleFilter filter, ExecIndexRow stopKey, int stopOp, int indexNumber, boolean wait) throws StandardException {
        ExecRow baseRow = this.crf.makeEmptyRow();
        int rowsDeleted = 0;
        boolean passedFilter = true;
        RowChanger rc = this.getRowChanger(tc, null, baseRow);
        int lockMode = startKey != null && stopKey != null ? 6 : 7;
        int isolation = startKey != null && stopKey != null && startKey == stopKey ? 4 : 5;
        rc.open(lockMode, wait);
        DataValueDescriptor[] startKeyRow = startKey == null ? null : startKey.getRowArray();
        DataValueDescriptor[] stopKeyRow = stopKey == null ? null : stopKey.getRowArray();
        ConglomerateController heapCC = tc.openConglomerate(this.getHeapConglomerate(), false, 4 | (wait ? 0 : 128), lockMode, 4);
        ScanController drivingScan = tc.openScan(this.getIndexConglomerate(indexNumber), false, 4 | (wait ? 0 : 128), lockMode, isolation, null, startKeyRow, startOp, qualifier, stopKeyRow, stopOp, null);
        ExecIndexRow drivingIndexRow = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(indexNumber), heapCC.newRowLocationTemplate(), this.crf.makeEmptyRow());
        while (drivingScan.fetchNext(drivingIndexRow)) {
            boolean base_row_exists;
            RowLocation baseRowLocation = (RowLocation)drivingIndexRow.getLastColumn();
            boolean bl = base_row_exists = (baseRowLocation = heapCC.fetch(baseRowLocation, baseRow, (FormatableBitSet)null, false)) != null;
            if (base_row_exists) {
                drivingIndexRow.setColumn(drivingIndexRow.nColumns(), baseRowLocation);
            }
            SanityManager.ASSERT((boolean)base_row_exists, (String)"base row not found");
            if (filter != null) {
                passedFilter = filter.execute(baseRow).equals(true);
            }
            if (!passedFilter) continue;
            rc.deleteRow(baseRow, baseRowLocation);
            ++rowsDeleted;
        }
        heapCC.close();
        drivingScan.close();
        rc.close();
        return rowsDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecRow getRow(TransactionController tc, ExecIndexRow key, int indexNumber) throws StandardException {
        try (ConglomerateController heapCC = tc.openConglomerate(this.getHeapConglomerate(), false, 0, 6, 4);){
            ExecRow execRow = this.getRow(tc, heapCC, key, indexNumber);
            return execRow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowLocation getRowLocation(TransactionController tc, ExecIndexRow key, int indexNumber) throws StandardException {
        try (ConglomerateController heapCC = tc.openConglomerate(this.getHeapConglomerate(), false, 0, 6, 4);){
            RowLocation[] rl = new RowLocation[1];
            ExecRow notUsed = this.getRowInternal(tc, heapCC, key, indexNumber, rl);
            RowLocation rowLocation = rl[0];
            return rowLocation;
        }
    }

    ExecRow getRow(TransactionController tc, ConglomerateController heapCC, ExecIndexRow key, int indexNumber) throws StandardException {
        RowLocation[] rl = new RowLocation[1];
        return this.getRowInternal(tc, heapCC, key, indexNumber, rl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecRow getRowInternal(TransactionController tc, ConglomerateController heapCC, ExecIndexRow key, int indexNumber, RowLocation[] rl) throws StandardException {
        ExecRow baseRow = this.crf.makeEmptyRow();
        ScanController drivingScan = tc.openScan(this.getIndexConglomerate(indexNumber), false, 0, 6, 4, null, key.getRowArray(), 1, null, key.getRowArray(), -1, null);
        ExecIndexRow drivingIndexRow = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(indexNumber), heapCC.newRowLocationTemplate(), this.crf.makeEmptyRow());
        try {
            if (drivingScan.fetchNext(drivingIndexRow)) {
                boolean base_row_exists;
                RowLocation baseRowLocation;
                rl[0] = baseRowLocation = (RowLocation)drivingIndexRow.getLastColumn();
                boolean bl = base_row_exists = (baseRowLocation = heapCC.fetch(baseRowLocation, baseRow, (FormatableBitSet)null, true)) != null;
                if (base_row_exists) {
                    rl[0] = baseRowLocation;
                }
                SanityManager.ASSERT((boolean)base_row_exists, (String)"base row not found");
                ExecRow execRow = baseRow;
                return execRow;
            }
            ExecRow execRow = null;
            return execRow;
        }
        finally {
            drivingScan.close();
        }
    }

    public void updateRow(ExecIndexRow key, ExecRow newRow, int indexNumber, boolean[] indicesToUpdate, int[] colsToUpdate, TransactionController tc) throws StandardException {
        this.updateRow(key, newRow, indexNumber, indicesToUpdate, colsToUpdate, tc, true);
    }

    void updateRow(ExecIndexRow key, ExecRow newRow, int indexNumber, boolean[] indicesToUpdate, int[] colsToUpdate, TransactionController tc, boolean wait) throws StandardException {
        ExecRow[] newRows = new ExecRow[]{newRow};
        this.updateRow(key, newRows, indexNumber, indicesToUpdate, colsToUpdate, tc, wait);
    }

    void updateRow(ExecIndexRow key, ExecRow[] newRows, int indexNumber, boolean[] indicesToUpdate, int[] colsToUpdate, TransactionController tc) throws StandardException {
        this.updateRow(key, newRows, indexNumber, indicesToUpdate, colsToUpdate, tc, true);
    }

    private void updateRow(ExecIndexRow key, ExecRow[] newRows, int indexNumber, boolean[] indicesToUpdate, int[] colsToUpdate, TransactionController tc, boolean wait) throws StandardException {
        ExecRow baseRow = this.crf.makeEmptyRow();
        SanityManager.ASSERT((indicesToUpdate.length == this.crf.getNumIndexes() ? 1 : 0) != 0, (String)"Wrong number of indices.");
        RowChanger rc = this.getRowChanger(tc, colsToUpdate, baseRow);
        rc.openForUpdate(indicesToUpdate, 6, wait);
        ConglomerateController heapCC = tc.openConglomerate(this.getHeapConglomerate(), false, 4 | (wait ? 0 : 128), 6, 4);
        ScanController drivingScan = tc.openScan(this.getIndexConglomerate(indexNumber), false, 4 | (wait ? 0 : 128), 6, 4, null, key.getRowArray(), 1, null, key.getRowArray(), -1, null);
        ExecIndexRow drivingIndexRow = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(indexNumber), heapCC.newRowLocationTemplate(), this.crf.makeEmptyRow());
        int rowNum = 0;
        while (drivingScan.fetchNext(drivingIndexRow)) {
            boolean base_row_exists;
            RowLocation baseRowLocation = (RowLocation)drivingIndexRow.getLastColumn();
            boolean bl = base_row_exists = (baseRowLocation = heapCC.fetch(baseRowLocation, baseRow, (FormatableBitSet)null, false)) != null;
            if (base_row_exists) {
                drivingIndexRow.setColumn(drivingIndexRow.nColumns(), baseRowLocation);
            }
            SanityManager.ASSERT((boolean)base_row_exists, (String)"base row not found");
            rc.updateRow(baseRow, rowNum == newRows.length - 1 ? newRows[rowNum] : newRows[rowNum++], baseRowLocation);
        }
        rc.finish();
        heapCC.close();
        drivingScan.close();
        rc.close();
    }

    Properties getCreateHeapProperties() {
        return this.crf.getCreateHeapProperties();
    }

    Properties getCreateIndexProperties(int indexNumber) {
        return this.crf.getCreateIndexProperties(indexNumber);
    }

    private RowChanger getRowChanger(TransactionController tc, int[] changedCols, ExecRow baseRow) throws StandardException {
        int indexCount = this.crf.getNumIndexes();
        IndexRowGenerator[] irgs = new IndexRowGenerator[indexCount];
        long[] cids = new long[indexCount];
        if (changedCols != null) {
            for (int i = changedCols.length - 1; i >= 0; --i) {
                SanityManager.ASSERT((changedCols[i] != 0 ? 1 : 0) != 0, (String)"Column id is 0, but should be 1 based");
            }
        }
        for (int ictr = 0; ictr < indexCount; ++ictr) {
            irgs[ictr] = this.getIndexRowGenerator(ictr);
            cids[ictr] = this.getIndexConglomerate(ictr);
        }
        RowChanger rc = this.crf.getExecutionFactory().getRowChanger(this.getHeapConglomerate(), null, null, irgs, cids, null, null, this.crf.getHeapColumnCount(), tc, changedCols, this.getStreamStorableHeapColIds(baseRow), null);
        return rc;
    }

    private int[] getStreamStorableHeapColIds(ExecRow baseRow) throws StandardException {
        if (!this.computedStreamStorableHeapColIds) {
            int sshcidLen = 0;
            DataValueDescriptor[] ra = baseRow.getRowArray();
            for (int ix = 0; ix < ra.length; ++ix) {
                if (!(ra[ix] instanceof StreamStorable)) continue;
                ++sshcidLen;
            }
            if (sshcidLen > 0) {
                this.streamStorableHeapColIds = new int[sshcidLen];
                int sshcidOffset = 0;
                for (int ix = 0; ix < ra.length; ++ix) {
                    if (!(ra[ix] instanceof StreamStorable)) continue;
                    this.streamStorableHeapColIds[sshcidOffset++] = ix;
                }
            }
            this.computedStreamStorableHeapColIds = true;
        }
        return this.streamStorableHeapColIds;
    }

    private ExecIndexRow getIndexRowFromHeapRow(IndexRowGenerator irg, RowLocation rl, ExecRow heapRow) throws StandardException {
        ExecIndexRow indexRow = irg.getIndexRowTemplate();
        irg.getIndexRow(heapRow, rl, indexRow, null);
        return indexRow;
    }

    public String toString() {
        return "name: " + this.getTableName() + "\n\theapCongolomerate: " + this.heapConglomerate + "\n\tnumIndexes: " + (this.indexes != null ? this.indexes.length : 0) + "\n\tnumIndexesSet: " + this.numIndexesSet + "\n\theapSet: " + this.heapSet + "\n";
    }
}

