/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.ReferencedColumns;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.ReferencedColumnsDescriptorImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;
import java.sql.Timestamp;

public class SYSTRIGGERSRowFactory
extends CatalogRowFactory {
    static final String TABLENAME_STRING = "SYSTRIGGERS";
    public static final int SYSTRIGGERS_TRIGGERID = 1;
    public static final int SYSTRIGGERS_TRIGGERNAME = 2;
    public static final int SYSTRIGGERS_SCHEMAID = 3;
    public static final int SYSTRIGGERS_CREATIONTIMESTAMP = 4;
    public static final int SYSTRIGGERS_EVENT = 5;
    public static final int SYSTRIGGERS_FIRINGTIME = 6;
    public static final int SYSTRIGGERS_TYPE = 7;
    public static final int SYSTRIGGERS_STATE = 8;
    public static final int SYSTRIGGERS_TABLEID = 9;
    public static final int SYSTRIGGERS_WHENSTMTID = 10;
    public static final int SYSTRIGGERS_ACTIONSTMTID = 11;
    public static final int SYSTRIGGERS_REFERENCEDCOLUMNS = 12;
    public static final int SYSTRIGGERS_TRIGGERDEFINITION = 13;
    public static final int SYSTRIGGERS_REFERENCINGOLD = 14;
    public static final int SYSTRIGGERS_REFERENCINGNEW = 15;
    public static final int SYSTRIGGERS_OLDREFERENCINGNAME = 16;
    public static final int SYSTRIGGERS_NEWREFERENCINGNAME = 17;
    public static final int SYSTRIGGERS_COLUMN_COUNT = 17;
    public static final int SYSTRIGGERS_INDEX1_ID = 0;
    public static final int SYSTRIGGERS_INDEX2_ID = 1;
    public static final int SYSTRIGGERS_INDEX3_ID = 2;
    private static final int[][] indexColumnPositions = new int[][]{{1}, {2, 3}, {9, 4}};
    private static final boolean[] uniqueness = new boolean[]{true, true, false};
    private static final String[] uuids = new String[]{"c013800d-00d7-c025-4809-000a0a411200", "c013800d-00d7-c025-480a-000a0a411200", "c013800d-00d7-c025-480b-000a0a411200", "c013800d-00d7-c025-480c-000a0a411200", "c013800d-00d7-c025-480d-000a0a411200"};

    SYSTRIGGERSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(17, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String name = null;
        UUID uuid = null;
        UUID suuid = null;
        UUID tuuid = null;
        UUID actionSPSID = null;
        UUID whenSPSID = null;
        Timestamp createTime = null;
        String event = null;
        String time = null;
        String type = null;
        String enabled = null;
        String triggerDefinition = null;
        String oldReferencingName = null;
        String newReferencingName = null;
        ReferencedColumnsDescriptorImpl rcd = null;
        boolean referencingOld = false;
        boolean referencingNew = false;
        if (td != null) {
            TriggerDescriptor triggerDescriptor = (TriggerDescriptor)td;
            name = triggerDescriptor.getName();
            uuid = triggerDescriptor.getUUID();
            suuid = triggerDescriptor.getSchemaDescriptor().getUUID();
            createTime = triggerDescriptor.getCreationTimestamp();
            event = triggerDescriptor.listensForEvent(1) ? "U" : (triggerDescriptor.listensForEvent(2) ? "D" : "I");
            time = triggerDescriptor.isBeforeTrigger() ? "B" : "A";
            type = triggerDescriptor.isRowTrigger() ? "R" : "S";
            enabled = triggerDescriptor.isEnabled() ? "E" : "D";
            tuuid = triggerDescriptor.getTableDescriptor().getUUID();
            int[] refCols = triggerDescriptor.getReferencedCols();
            rcd = refCols != null ? new ReferencedColumnsDescriptorImpl(refCols) : null;
            actionSPSID = triggerDescriptor.getActionId();
            whenSPSID = triggerDescriptor.getWhenClauseId();
            triggerDefinition = triggerDescriptor.getTriggerDefinition();
            referencingOld = triggerDescriptor.getReferencingOld();
            referencingNew = triggerDescriptor.getReferencingNew();
            oldReferencingName = triggerDescriptor.getOldReferencingName();
            newReferencingName = triggerDescriptor.getNewReferencingName();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(17);
        row.setColumn(1, new SQLChar(uuid == null ? null : uuid.toString()));
        row.setColumn(2, new SQLVarchar(name));
        row.setColumn(3, new SQLChar(suuid == null ? null : suuid.toString()));
        row.setColumn(4, this.dvf.getDataValue(createTime));
        row.setColumn(5, new SQLChar(event));
        row.setColumn(6, new SQLChar(time));
        row.setColumn(7, new SQLChar(type));
        row.setColumn(8, new SQLChar(enabled));
        row.setColumn(9, new SQLChar(tuuid == null ? null : tuuid.toString()));
        row.setColumn(10, new SQLChar(whenSPSID == null ? null : whenSPSID.toString()));
        row.setColumn(11, new SQLChar(actionSPSID == null ? null : actionSPSID.toString()));
        row.setColumn(12, this.dvf.getDataValue(rcd));
        row.setColumn(13, this.dvf.getLongvarcharDataValue(triggerDefinition));
        row.setColumn(14, this.dvf.getDataValue(referencingOld));
        row.setColumn(15, this.dvf.getDataValue(referencingNew));
        row.setColumn(16, new SQLVarchar(oldReferencingName));
        row.setColumn(17, new SQLVarchar(newReferencingName));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        UUID actionSPSID = null;
        UUID whenSPSID = null;
        int eventMask = 0;
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        SanityManager.ASSERT((row.nColumns() == 17 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSTRIGGERS row");
        DataValueDescriptor col = row.getColumn(1);
        String uuidStr = col.getString();
        UUID uuid = this.getUUIDFactory().recreateUUID(uuidStr);
        col = row.getColumn(2);
        String name = col.getString();
        col = row.getColumn(3);
        uuidStr = col.getString();
        UUID suuid = this.getUUIDFactory().recreateUUID(uuidStr);
        col = row.getColumn(4);
        Timestamp createTime = (Timestamp)col.getObject();
        col = row.getColumn(5);
        char theChar = col.getString().charAt(0);
        switch (theChar) {
            case 'U': {
                eventMask = 1;
                break;
            }
            case 'I': {
                eventMask = 4;
                break;
            }
            case 'D': {
                eventMask = 2;
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("bad event mask: " + theChar));
            }
        }
        boolean isBefore = this.getCharBoolean(row.getColumn(6), 'B', 'A');
        boolean isRow = this.getCharBoolean(row.getColumn(7), 'R', 'S');
        boolean isEnabled = this.getCharBoolean(row.getColumn(8), 'E', 'D');
        col = row.getColumn(9);
        uuidStr = col.getString();
        UUID tuuid = this.getUUIDFactory().recreateUUID(uuidStr);
        col = row.getColumn(10);
        uuidStr = col.getString();
        if (uuidStr != null) {
            whenSPSID = this.getUUIDFactory().recreateUUID(uuidStr);
        }
        if ((uuidStr = (col = row.getColumn(11)).getString()) != null) {
            actionSPSID = this.getUUIDFactory().recreateUUID(uuidStr);
        }
        col = row.getColumn(12);
        ReferencedColumns rcd = (ReferencedColumns)col.getObject();
        col = row.getColumn(13);
        String triggerDefinition = col.getString();
        col = row.getColumn(14);
        boolean referencingOld = col.getBoolean();
        col = row.getColumn(15);
        boolean referencingNew = col.getBoolean();
        col = row.getColumn(16);
        String oldReferencingName = col.getString();
        col = row.getColumn(17);
        String newReferencingName = col.getString();
        TriggerDescriptor descriptor = new TriggerDescriptor(dd, dd.getSchemaDescriptor(suuid, null), uuid, name, eventMask, isBefore, isRow, isEnabled, dd.getTableDescriptor(tuuid), whenSPSID, actionSPSID, createTime, rcd == null ? (int[])null : rcd.getReferencedColumnPositions(), triggerDefinition, referencingOld, referencingNew, oldReferencingName, newReferencingName);
        return descriptor;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("TRIGGERID", false), SystemColumnImpl.getIdentifierColumn("TRIGGERNAME", false), SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getColumn("CREATIONTIMESTAMP", 93, false), SystemColumnImpl.getIndicatorColumn("EVENT"), SystemColumnImpl.getIndicatorColumn("FIRINGTIME"), SystemColumnImpl.getIndicatorColumn("TYPE"), SystemColumnImpl.getIndicatorColumn("STATE"), SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getUUIDColumn("WHENSTMTID", true), SystemColumnImpl.getUUIDColumn("ACTIONSTMTID", true), SystemColumnImpl.getJavaColumn("REFERENCEDCOLUMNS", "com.pivotal.gemfirexd.internal.catalog.ReferencedColumns", true), SystemColumnImpl.getColumn("TRIGGERDEFINITION", -1, true, 32700), SystemColumnImpl.getColumn("REFERENCINGOLD", 16, true), SystemColumnImpl.getColumn("REFERENCINGNEW", 16, true), SystemColumnImpl.getIdentifierColumn("OLDREFERENCINGNAME", true), SystemColumnImpl.getIdentifierColumn("NEWREFERENCINGNAME", true)};
    }

    private boolean getCharBoolean(DataValueDescriptor col, char trueValue, char falseValue) throws StandardException {
        char theChar = col.getString().charAt(0);
        if (theChar == trueValue) {
            return true;
        }
        if (theChar == falseValue) {
            return false;
        }
        SanityManager.THROWASSERT((String)("bad char value " + theChar));
        return true;
    }
}

