/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.KeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;

public class SYSKEYSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSKEYS";
    protected static final int SYSKEYS_COLUMN_COUNT = 2;
    protected static final int SYSKEYS_CONSTRAINTID = 1;
    protected static final int SYSKEYS_CONGLOMERATEID = 2;
    protected static final int SYSKEYS_INDEX1_ID = 0;
    private static final boolean[] uniqueness = null;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final String[] uuids = new String[]{"80000039-00d0-fd77-3ed8-000a0a0b1900", "8000003c-00d0-fd77-3ed8-000a0a0b1900", "8000003b-00d0-fd77-3ed8-000a0a0b1900"};

    SYSKEYSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(2, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String constraintID = null;
        String conglomerateID = null;
        if (td != null) {
            KeyConstraintDescriptor constraint = (KeyConstraintDescriptor)td;
            UUID oid = constraint.getUUID();
            constraintID = oid.toString();
            conglomerateID = constraint.getIndexUUIDString();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(2);
        row.setColumn(1, new SQLChar(constraintID));
        row.setColumn(2, new SQLChar(conglomerateID));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        SubKeyConstraintDescriptor keyDesc = null;
        SanityManager.ASSERT((row.nColumns() == 2 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSKEYS row");
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        DataValueDescriptor col = row.getColumn(1);
        String constraintUUIDString = col.getString();
        UUID constraintUUID = this.getUUIDFactory().recreateUUID(constraintUUIDString);
        col = row.getColumn(2);
        String conglomerateUUIDString = col.getString();
        UUID conglomerateUUID = this.getUUIDFactory().recreateUUID(conglomerateUUIDString);
        keyDesc = new SubKeyConstraintDescriptor(constraintUUID, conglomerateUUID);
        return keyDesc;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("CONSTRAINTID", false), SystemColumnImpl.getUUIDColumn("CONGLOMERATEID", false)};
    }
}

