/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.IndexDescriptor;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;
import java.util.Properties;

public class SYSCONGLOMERATESRowFactory
extends CatalogRowFactory {
    public static final String TABLENAME_STRING = "SYSCONGLOMERATES";
    protected static final int SYSCONGLOMERATES_COLUMN_COUNT = 9;
    protected static final int SYSCONGLOMERATES_SCHEMAID = 1;
    protected static final int SYSCONGLOMERATES_TABLEID = 2;
    protected static final int SYSCONGLOMERATES_CONGLOMERATENUMBER = 3;
    public static final int SYSCONGLOMERATES_CONGLOMERATENAME = 4;
    public static final int SYSCONGLOMERATES_SCHEMANAME = 9;
    protected static final int SYSCONGLOMERATES_ISINDEX = 5;
    protected static final int SYSCONGLOMERATES_DESCRIPTOR = 6;
    protected static final int SYSCONGLOMERATES_ISCONSTRAINT = 7;
    protected static final int SYSCONGLOMERATES_CONGLOMERATEID = 8;
    protected static final int SYSCONGLOMERATES_INDEX1_ID = 0;
    protected static final int SYSCONGLOMERATES_INDEX2_ID = 1;
    protected static final int SYSCONGLOMERATES_INDEX3_ID = 2;
    private static final boolean[] uniqueness = new boolean[]{false, true, false};
    private static final int[][] indexColumnPositions = new int[][]{{8}, {4, 1}, {2}};
    private static final String[] uuids = new String[]{"80000010-00d0-fd77-3ed8-000a0a0b1900", "80000027-00d0-fd77-3ed8-000a0a0b1900", "80000012-00d0-fd77-3ed8-000a0a0b1900", "80000014-00d0-fd77-3ed8-000a0a0b1900", "80000016-00d0-fd77-3ed8-000a0a0b1900"};

    SYSCONGLOMERATESRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(9, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String tabID = null;
        Long conglomNumber = null;
        String conglomName = null;
        Boolean supportsIndex = null;
        IndexRowGenerator indexRowGenerator = null;
        Boolean supportsConstraint = null;
        String conglomUUIDString = null;
        String schemaID = null;
        ConglomerateDescriptor conglomerate = (ConglomerateDescriptor)td;
        if (td != null) {
            if (parent != null) {
                SchemaDescriptor sd = (SchemaDescriptor)parent;
                schemaID = sd.getUUID().toString();
            } else {
                schemaID = conglomerate.getSchemaID().toString();
            }
            tabID = conglomerate.getTableID().toString();
            conglomNumber = conglomerate.getConglomerateNumber();
            conglomName = conglomerate.getConglomerateName();
            conglomUUIDString = conglomerate.getUUID().toString();
            supportsIndex = conglomerate.isIndex();
            indexRowGenerator = conglomerate.getIndexDescriptor();
            supportsConstraint = conglomerate.isConstraint();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(9);
        row.setColumn(1, new SQLChar(schemaID));
        row.setColumn(2, new SQLChar(tabID));
        row.setColumn(3, this.dvf.getDataValue(conglomNumber));
        row.setColumn(4, conglomName == null ? new SQLVarchar(tabID) : new SQLVarchar(conglomName));
        row.setColumn(5, this.dvf.getDataValue(supportsIndex));
        row.setColumn(6, this.dvf.getDataValue(indexRowGenerator == null ? (IndexDescriptor)null : indexRowGenerator.getIndexDescriptor()));
        row.setColumn(7, this.dvf.getDataValue(supportsConstraint));
        row.setColumn(8, new SQLChar(conglomUUIDString));
        String schemaName = null;
        if (td != null) {
            SchemaDescriptor sd = (SchemaDescriptor)parent;
            if (sd == null) {
                try {
                    sd = td.getDataDictionary().getSchemaDescriptor(conglomerate.getSchemaID(), null);
                }
                catch (StandardException ex) {
                    sd = null;
                }
            }
            if (sd != null) {
                schemaName = sd.getSchemaName();
            }
        }
        row.setColumn(9, new SQLVarchar(schemaName));
        return row;
    }

    @Override
    public ExecRow makeEmptyRow() throws StandardException {
        return this.makeRow(null, null);
    }

    @Override
    public Properties getCreateHeapProperties() {
        Properties properties = new Properties();
        properties.put("gemfirexd.storage.pageSize", "4096");
        properties.put("gemfirexd.storage.pageReservedSpace", "0");
        properties.put("gemfirexd.storage.minimumRecordSize", "1");
        return properties;
    }

    @Override
    public Properties getCreateIndexProperties(int indexNumber) {
        Properties properties = new Properties();
        properties.put("gemfirexd.storage.pageSize", "4096");
        return properties;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        SanityManager.ASSERT((row.nColumns() == 9 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSCONGLOMERATES row");
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        DataValueDescriptor col = row.getColumn(1);
        String schemaUUIDString = col.getString();
        UUID schemaUUID = this.getUUIDFactory().recreateUUID(schemaUUIDString);
        col = row.getColumn(2);
        String tableUUIDString = col.getString();
        UUID tableUUID = this.getUUIDFactory().recreateUUID(tableUUIDString);
        col = row.getColumn(3);
        long conglomerateNumber = col.getLong();
        col = row.getColumn(4);
        String name = col.getString();
        col = row.getColumn(5);
        boolean isIndex = col.getBoolean();
        col = row.getColumn(6);
        IndexRowGenerator indexRowGenerator = new IndexRowGenerator((IndexDescriptor)col.getObject());
        col = row.getColumn(7);
        boolean isConstraint = col.getBoolean();
        col = row.getColumn(8);
        String conglomUUIDString = col.getString();
        UUID conglomUUID = this.getUUIDFactory().recreateUUID(conglomUUIDString);
        ConglomerateDescriptor conglomerateDesc = ddg.newConglomerateDescriptor(conglomerateNumber, name, isIndex, indexRowGenerator, isConstraint, conglomUUID, tableUUID, schemaUUID);
        return conglomerateDesc;
    }

    protected UUID getConglomerateUUID(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(8);
        String conglomerateUUIDString = col.getString();
        return this.getUUIDFactory().recreateUUID(conglomerateUUIDString);
    }

    protected UUID getTableUUID(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(2);
        String tableUUIDString = col.getString();
        return this.getUUIDFactory().recreateUUID(tableUUIDString);
    }

    protected UUID getSchemaUUID(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(1);
        String schemaUUIDString = col.getString();
        return this.getUUIDFactory().recreateUUID(schemaUUIDString);
    }

    protected String getConglomerateName(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(4);
        return col.getString();
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getColumn("CONGLOMERATENUMBER", -5, false), SystemColumnImpl.getIdentifierColumn("CONGLOMERATENAME", true), SystemColumnImpl.getColumn("ISINDEX", 16, false), SystemColumnImpl.getJavaColumn("DESCRIPTOR", "com.pivotal.gemfirexd.internal.catalog.IndexDescriptor", true), SystemColumnImpl.getColumn("ISCONSTRAINT", 16, true), SystemColumnImpl.getUUIDColumn("CONGLOMERATEID", false), SystemColumnImpl.getIdentifierColumn("CONGLOMSCHEMANAME", true)};
    }
}

