/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdHDFSStoreDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;

public class GfxdSYSHDFSSTORESRowFactory
extends CatalogRowFactory {
    public static final String TABLENAME_STRING = "SYSHDFSSTORES";
    public static final int SYSHDFSSTORES_COLUMN_COUNT = 23;
    public static final int SYSHDFSSTORES_NAME = 1;
    public static final int SYSHDFSSTORES_NAMENODE = 2;
    public static final int SYSHDFSSTORES_HOMEDIR = 3;
    public static final int SYSHDFSSTORES_MAXQUEUEMEMORY = 4;
    public static final int SYSHDFSSTORES_BATCHSIZE = 5;
    public static final int SYSHDFSSTORES_BATCHINTERVAL = 6;
    public static final int SYSHDFSSTORES_ISPERSISTENT = 7;
    public static final int SYSHDFSSTORES_DISKSYNC = 8;
    public static final int SYSHDFSSTORES_DISKSTORE = 9;
    public static final int SYSHDFSSTORES_AUTOCOMPACT = 10;
    public static final int SYSHDFSSTORES_AUTOMAJORCOMPACT = 11;
    public static final int SYSHDFSSTORES_MAXINPUTFILESIZE = 12;
    public static final int SYSHDFSSTORES_MININPUTFILECOUNT = 13;
    public static final int SYSHDFSSTORES_MAXINPUTFILECOUNT = 14;
    public static final int SYSHDFSSTORES_MAXCONCURRENCY = 15;
    public static final int SYSHDFSSTORES_MAJORCOMPACTIONINTERVAL = 16;
    public static final int SYSHDFSSTORES_MAJORCOMPACTIONCONCURRENCY = 17;
    public static final int SYSHDFSSTORES_HDFSCLIENTCONFIGFILE = 18;
    public static final int SYSHDFSSTORES_BLOCKCACHESIZE = 19;
    public static final int SYSHDFSSTORES_MAXFILESIZEWRITEONLYTABLE = 20;
    public static final int SYSHDFSSTORES_FILEROLLOVERINTERVALWRITEONLYTABLE = 21;
    public static final int SYSHDFSSTORES_PURGEINTERVAL = 22;
    public static final int SYSHDFSSTORES_DISPATCHERTHREADS = 23;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"t073400e-00b6-fdfc-71ce-000b0a763800", "t073400e-00b6-fbba-75d4-000b0a763800", "t073400e-00b6-00b9-bbde-000b0a763800"};

    GfxdSYSHDFSSTORESRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(23, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        UUID uuid = null;
        String hdfsStoreName = null;
        String nameNode = null;
        String homeDir = null;
        float blockCacheSize = -1.0f;
        String hdfsClientConfigFile = null;
        int maxQueueMemory = -1;
        int batchSize = -1;
        int batchInterval = -1;
        boolean isPersistent = false;
        boolean isDiskSync = false;
        String diskStore = null;
        boolean autoCompact = false;
        boolean autoMajorCompact = false;
        int maxInputFileSize = -1;
        int minInputFileCount = -1;
        int maxInputFileCount = -1;
        int maxConcurrency = -1;
        int majorCompactionInterval = -1;
        int majorCompactionConcurrency = -1;
        int maxfilesizeWriteOnly = -1;
        int timeForRolloverWriteOnly = -1;
        int purgeInterval = -1;
        int dispatcherThreads = 1;
        if (td != null) {
            GfxdHDFSStoreDescriptor hsd = (GfxdHDFSStoreDescriptor)td;
            hdfsStoreName = hsd.getHDFSStoreName();
            nameNode = hsd.getNameNode();
            homeDir = hsd.getHomeDir();
            hdfsClientConfigFile = hsd.getHDFSClientConfigFile();
            blockCacheSize = hsd.getBlockCacheSize();
            maxQueueMemory = hsd.getMaxQueueMemory();
            batchSize = hsd.getBatchSize();
            batchInterval = hsd.getBatchInterval();
            isPersistent = hsd.isPersistenceEnabled();
            isDiskSync = hsd.isDiskSynchronous();
            diskStore = hsd.getDiskStoreName();
            autoCompact = hsd.isAutoCompact();
            autoMajorCompact = hsd.isAutoMajorCompact();
            maxInputFileSize = hsd.getMaxInputFileSize();
            minInputFileCount = hsd.getMinInputFileCount();
            maxInputFileCount = hsd.getMaxInputFileCount();
            maxConcurrency = hsd.getMaxConcurrency();
            majorCompactionInterval = hsd.getMajorCompactionInterval();
            majorCompactionConcurrency = hsd.getMajorCompactionConcurrency();
            maxfilesizeWriteOnly = hsd.getMaxFileSizeWriteOnly();
            timeForRolloverWriteOnly = hsd.getFileRolloverInterval();
            purgeInterval = hsd.getPurgeInterval();
            uuid = hsd.getUUID();
            dispatcherThreads = hsd.getDispatcherThreads();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(23);
        row.setColumn(1, new SQLChar(hdfsStoreName));
        row.setColumn(2, new SQLVarchar(nameNode));
        row.setColumn(3, new SQLVarchar(homeDir));
        row.setColumn(4, new SQLInteger(maxQueueMemory));
        row.setColumn(5, new SQLInteger(batchSize));
        row.setColumn(6, new SQLInteger(batchInterval));
        row.setColumn(7, new SQLBoolean(isPersistent));
        row.setColumn(8, new SQLBoolean(isDiskSync));
        row.setColumn(9, new SQLVarchar(diskStore));
        row.setColumn(10, new SQLBoolean(autoCompact));
        row.setColumn(11, new SQLBoolean(autoMajorCompact));
        row.setColumn(12, new SQLInteger(maxInputFileSize));
        row.setColumn(13, new SQLInteger(minInputFileCount));
        row.setColumn(14, new SQLInteger(maxInputFileCount));
        row.setColumn(15, new SQLInteger(maxConcurrency));
        row.setColumn(16, new SQLInteger(majorCompactionInterval));
        row.setColumn(17, new SQLInteger(majorCompactionConcurrency));
        row.setColumn(18, new SQLVarchar(hdfsClientConfigFile));
        row.setColumn(19, new SQLDouble(blockCacheSize));
        row.setColumn(20, new SQLLongint(maxfilesizeWriteOnly));
        row.setColumn(21, new SQLLongint(timeForRolloverWriteOnly));
        row.setColumn(22, new SQLInteger(purgeInterval));
        row.setColumn(23, new SQLInteger(dispatcherThreads));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentDesc, DataDictionary dd) throws StandardException {
        SanityManager.ASSERT((row.nColumns() == 23 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSDISKSTORES row");
        DataValueDescriptor col = row.getColumn(1);
        String hdfsStoreName = col.getString();
        UUID id = this.getUUIDFactory().recreateUUID(hdfsStoreName);
        col = row.getColumn(2);
        String nameNode = col.getString();
        col = row.getColumn(3);
        String homeDir = col.getString();
        col = row.getColumn(4);
        int maxQueueMemory = col.getInt();
        col = row.getColumn(5);
        int batchSize = col.getInt();
        col = row.getColumn(6);
        int batchInterval = col.getInt();
        col = row.getColumn(7);
        boolean isPersistent = col.getBoolean();
        col = row.getColumn(8);
        boolean isDiskSync = col.getBoolean();
        col = row.getColumn(9);
        String diskStore = col.getString();
        col = row.getColumn(10);
        boolean autoCompact = col.getBoolean();
        col = row.getColumn(11);
        boolean autoMajorCompact = col.getBoolean();
        col = row.getColumn(12);
        int maxInputFileSize = col.getInt();
        col = row.getColumn(13);
        int minInputFileCount = col.getInt();
        col = row.getColumn(14);
        int maxInputFileCount = col.getInt();
        col = row.getColumn(15);
        int maxConcurrency = col.getInt();
        col = row.getColumn(16);
        int majorCompactionInterval = col.getInt();
        col = row.getColumn(17);
        int majorCompactionConcurrency = col.getInt();
        col = row.getColumn(18);
        String hdfsClientConfigFile = col.getString();
        col = row.getColumn(19);
        float blockCacheSize = col.getFloat();
        col = row.getColumn(20);
        int maxFileSizeWriteOnly = col.getInt();
        col = row.getColumn(21);
        int timeForRollOver = col.getInt();
        col = row.getColumn(22);
        int purgeInterval = col.getInt();
        col = row.getColumn(23);
        int dispatcherThreads = col.getInt();
        return new GfxdHDFSStoreDescriptor(dd, id, hdfsStoreName, nameNode, homeDir, maxQueueMemory, batchSize, batchInterval, isPersistent, isDiskSync, diskStore, autoCompact, autoMajorCompact, maxInputFileSize, minInputFileCount, maxInputFileCount, maxConcurrency, majorCompactionInterval, majorCompactionConcurrency, hdfsClientConfigFile, blockCacheSize, maxFileSizeWriteOnly, timeForRollOver, purgeInterval, dispatcherThreads);
    }

    @Override
    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getIdentifierColumn("NAME", false), SystemColumnImpl.getColumn("NAMENODE", 12, false), SystemColumnImpl.getColumn("HOMEDIR", 12, false), SystemColumnImpl.getColumn("MAXQUEUEMEMORY", 4, false), SystemColumnImpl.getColumn("BATCHSIZE", 4, false), SystemColumnImpl.getColumn("BATCHTIMEINTERVALMILLIS", 4, false), SystemColumnImpl.getColumn("QUEUEPERSISTENT", 16, false), SystemColumnImpl.getColumn("DISKSYNCHRONOUS", 16, false), SystemColumnImpl.getColumn("DISKSTORENAME", 12, true), SystemColumnImpl.getColumn("MINORCOMPACT", 16, false), SystemColumnImpl.getColumn("MAJORCOMPACT", 16, false), SystemColumnImpl.getColumn("MAXINPUTFILESIZE", 4, false), SystemColumnImpl.getColumn("MININPUTFILECOUNT", 4, false), SystemColumnImpl.getColumn("MAXINPUTFILECOUNT", 4, false), SystemColumnImpl.getColumn("MINORCOMPACTIONTHREADS", 4, false), SystemColumnImpl.getColumn("MAJORCOMPACTIONINTERVALMINS", 4, false), SystemColumnImpl.getColumn("MAJORCOMPACTIONTHREADS", 4, false), SystemColumnImpl.getColumn("CLIENTCONFIGFILE", 12, true), SystemColumnImpl.getColumn("BLOCKCACHESIZE", 6, false), SystemColumnImpl.getColumn("MAXWRITEONLYFILESIZE", 4, false), SystemColumnImpl.getColumn("WRITEONLYFILEROLLOVERINTERVALSECS", 4, false), SystemColumnImpl.getColumn("PURGEINTERVALMINS", 4, false), SystemColumnImpl.getColumn("DISPATCHERTHREADS", 4, false)};
    }
}

