/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.Dependable;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableHashtable;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DDdependableFinder;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DDColumnDependableFinder
extends DDdependableFinder {
    private byte[] columnBitMap;

    public DDColumnDependableFinder(int formatId) {
        super(formatId);
    }

    public DDColumnDependableFinder() {
    }

    public DDColumnDependableFinder(int formatId, byte[] columnBitMap) {
        super(formatId);
        this.columnBitMap = columnBitMap;
    }

    public byte[] getColumnBitMap() {
        return this.columnBitMap;
    }

    public void setColumnBitMap(byte[] columnBitMap) {
        this.columnBitMap = columnBitMap;
    }

    @Override
    Dependable findDependable(DataDictionary dd, UUID dependableObjectID) throws StandardException {
        TableDescriptor td = dd.getTableDescriptor(dependableObjectID);
        if (td != null) {
            td.setReferencedColumnMap(new FormatableBitSet(this.columnBitMap));
        }
        return td;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        FormatableHashtable fh = (FormatableHashtable)in.readObject();
        this.columnBitMap = (byte[])fh.get("columnBitMap");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        FormatableHashtable fh = new FormatableHashtable();
        fh.put("columnBitMap", this.columnBitMap);
        out.writeObject(fh);
    }
}

