/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableHashtable;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class GenericColumnDescriptor
implements ResultColumnDescriptor,
Formatable {
    private String name;
    private String schemaName;
    private String tableName;
    private int columnPos;
    private DataTypeDescriptor type;
    private boolean isAutoincrement;
    private boolean updatableByCursor;
    private short primaryKey = (short)-1;

    public GenericColumnDescriptor() {
    }

    public GenericColumnDescriptor(String myName, String mySchemaName, String myTableName, int myColPos, DataTypeDescriptor myDtd, boolean isUpdtbl, boolean isautoIncrement) {
        this.name = myName;
        this.schemaName = mySchemaName;
        this.tableName = myTableName;
        this.columnPos = myColPos;
        this.type = myDtd;
        this.updatableByCursor = isUpdtbl;
        this.isAutoincrement = isautoIncrement;
    }

    public GenericColumnDescriptor(String name, DataTypeDescriptor type) {
        this.name = name;
        this.type = type;
    }

    public GenericColumnDescriptor(ResultColumnDescriptor rcd) {
        this.name = rcd.getName();
        this.tableName = rcd.getSourceTableName();
        this.schemaName = rcd.getSourceSchemaName();
        this.columnPos = rcd.getColumnPosition();
        this.type = rcd.getType();
        this.isAutoincrement = rcd.isAutoincrement();
        this.updatableByCursor = rcd.updatableByCursor();
    }

    @Override
    public DataTypeDescriptor getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSourceSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getSourceTableName() {
        return this.tableName;
    }

    @Override
    public int getColumnPosition() {
        return this.columnPos;
    }

    @Override
    public boolean isAutoincrement() {
        return this.isAutoincrement;
    }

    @Override
    public boolean updatableByCursor() {
        return this.updatableByCursor;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        FormatableHashtable fh = new FormatableHashtable();
        fh.put("name", this.name);
        fh.put("tableName", this.tableName);
        fh.put("schemaName", this.schemaName);
        fh.putInt("columnPos", this.columnPos);
        fh.put("type", this.type);
        fh.putBoolean("isAutoincrement", this.isAutoincrement);
        fh.putBoolean("updatableByCursor", this.updatableByCursor);
        out.writeObject(fh);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FormatableHashtable fh = (FormatableHashtable)in.readObject();
        this.name = (String)fh.get("name");
        this.tableName = (String)fh.get("tableName");
        this.schemaName = (String)fh.get("schemaName");
        this.columnPos = fh.getInt("columnPos");
        this.type = (DataTypeDescriptor)fh.get("type");
        this.isAutoincrement = fh.getBoolean("isAutoincrement");
        this.updatableByCursor = fh.getBoolean("updatableByCursor");
    }

    @Override
    public int getTypeFormatId() {
        return 383;
    }

    public String toString() {
        return "GenericColumnDescriptor\n\tname: " + this.name + "\n\tTable: " + this.schemaName + "." + this.tableName + "\n\tcolumnPos: " + this.columnPos + "\n\tType: " + this.type;
    }

    @Override
    public final short primaryKey(EngineConnection conn) throws StandardException {
        if (this.primaryKey == -1 && this.tableName != null && this.tableName.length() > 0 && !GfxdDataDictionary.isSystemSchema(this.schemaName)) {
            GemFireContainer container = GemFireXDUtils.getGemFireContainer(this.schemaName, this.tableName, conn.getLanguageConnectionContext());
            this.primaryKey = container != null ? ResultColumn.checkPrimaryKey(container.getExtraTableInfo(), this.name, null) : (short)0;
        }
        return this.primaryKey;
    }
}

