/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.uuid;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;

public class BasicUUID
implements UUID,
Formatable {
    private long majorId;
    private long timemillis;
    private int sequence;

    public BasicUUID(long majorId, long timemillis, int sequence) {
        this.majorId = majorId;
        this.timemillis = timemillis;
        this.sequence = sequence;
    }

    public BasicUUID(String uuidstring) {
        StringReader sr = new StringReader(uuidstring);
        this.sequence = (int)BasicUUID.readMSB(sr);
        long ltimemillis = BasicUUID.readMSB(sr) << 32;
        ltimemillis += BasicUUID.readMSB(sr) << 16;
        this.timemillis = ltimemillis += BasicUUID.readMSB(sr);
        this.majorId = BasicUUID.readMSB(sr);
    }

    public BasicUUID(byte[] b) {
        int lsequence = 0;
        for (int ix = 0; ix < 4; ++ix) {
            lsequence <<= 8;
            lsequence |= 0xFF & b[ix];
        }
        long ltimemillis = 0L;
        for (int ix = 4; ix < 10; ++ix) {
            ltimemillis <<= 8;
            ltimemillis |= (long)(0xFF & b[ix]);
        }
        long linetaddr = 0L;
        for (int ix = 10; ix < 16; ++ix) {
            linetaddr <<= 8;
            linetaddr |= (long)(0xFF & b[ix]);
        }
        this.sequence = lsequence;
        this.timemillis = ltimemillis;
        this.majorId = linetaddr;
    }

    public BasicUUID() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.majorId);
        out.writeLong(this.timemillis);
        out.writeInt(this.sequence);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.majorId = in.readLong();
        this.timemillis = in.readLong();
        this.sequence = in.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 131;
    }

    private static void writeMSB(char[] data, int offset, long value, int nbytes) {
        for (int i = nbytes - 1; i >= 0; --i) {
            long b = (value & 255L << 8 * i) >>> 8 * i;
            int c = (int)((b & 0xF0L) >> 4);
            data[offset++] = (char)(c < 10 ? c + 48 : c - 10 + 97);
            c = (int)(b & 0xFL);
            data[offset++] = (char)(c < 10 ? c + 48 : c - 10 + 97);
        }
    }

    private static long readMSB(StringReader sr) {
        long value = 0L;
        try {
            int c;
            while ((c = sr.read()) != -1 && c != 45) {
                value <<= 4;
                int nibble = c <= 57 ? c - 48 : (c <= 70 ? c - 65 + 10 : c - 97 + 10);
                value += (long)nibble;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof BasicUUID)) {
            return false;
        }
        BasicUUID other = (BasicUUID)otherObject;
        return this.sequence == other.sequence && this.timemillis == other.timemillis && this.majorId == other.majorId;
    }

    public int hashCode() {
        long hc = this.majorId ^ this.timemillis;
        return this.sequence ^ (int)(hc >> 4);
    }

    public String toString() {
        return this.stringWorkhorse('-');
    }

    @Override
    public String toANSIidentifier() {
        return "U" + this.stringWorkhorse('X');
    }

    public String stringWorkhorse(char separator) {
        char[] data = new char[36];
        BasicUUID.writeMSB(data, 0, this.sequence, 4);
        int offset = 8;
        if (separator != '\u0000') {
            data[offset++] = separator;
        }
        long ltimemillis = this.timemillis;
        BasicUUID.writeMSB(data, offset, (ltimemillis & 0xFFFF00000000L) >>> 32, 2);
        offset += 4;
        if (separator != '\u0000') {
            data[offset++] = separator;
        }
        BasicUUID.writeMSB(data, offset, (ltimemillis & 0xFFFF0000L) >>> 16, 2);
        offset += 4;
        if (separator != '\u0000') {
            data[offset++] = separator;
        }
        BasicUUID.writeMSB(data, offset, ltimemillis & 0xFFFFL, 2);
        offset += 4;
        if (separator != '\u0000') {
            data[offset++] = separator;
        }
        BasicUUID.writeMSB(data, offset, this.majorId, 6);
        return new String(data, 0, offset += 12);
    }

    @Override
    public byte[] toByteArray() {
        byte[] result = new byte[16];
        int lsequence = this.sequence;
        result[0] = (byte)(lsequence >>> 24);
        result[1] = (byte)(lsequence >>> 16);
        result[2] = (byte)(lsequence >>> 8);
        result[3] = (byte)lsequence;
        long ltimemillis = this.timemillis;
        result[4] = (byte)(ltimemillis >>> 40);
        result[5] = (byte)(ltimemillis >>> 32);
        result[6] = (byte)(ltimemillis >>> 24);
        result[7] = (byte)(ltimemillis >>> 16);
        result[8] = (byte)(ltimemillis >>> 8);
        result[9] = (byte)ltimemillis;
        long linetaddr = this.majorId;
        result[10] = (byte)(linetaddr >>> 40);
        result[11] = (byte)(linetaddr >>> 32);
        result[12] = (byte)(linetaddr >>> 24);
        result[13] = (byte)(linetaddr >>> 16);
        result[14] = (byte)(linetaddr >>> 8);
        result[15] = (byte)linetaddr;
        return result;
    }

    @Override
    public UUID cloneMe() {
        return new BasicUUID(this.majorId, this.timemillis, this.sequence);
    }

    @Override
    public String toHexString() {
        return this.stringWorkhorse('\u0000');
    }

    public void setLocallyExecuted(int salt) {
        this.timemillis = salt;
    }
}

