/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.reflect;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.locks.DefaultGfxdLockable;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLocalLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockSet;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockable;
import com.pivotal.gemfirexd.internal.engine.locks.impl.GfxdReentrantReadWriteLock;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactoryContext;
import com.pivotal.gemfirexd.internal.iapi.services.loader.JarReader;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockOwner;
import com.pivotal.gemfirexd.internal.iapi.services.locks.ShExQual;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PersistentSet;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.services.reflect.DatabaseClasses;
import com.pivotal.gemfirexd.internal.impl.services.reflect.JarLoader;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;

final class UpdateLoader
implements LockOwner {
    private static final String[] RESTRICTED_PACKAGES = new String[]{"javax.", "com.pivotal.gemfirexd."};
    private JarLoader[] jarList;
    private HeaderPrintWriter vs;
    private final ClassLoader myLoader;
    private boolean initDone;
    private String thisClasspath;
    private final GfxdLockable classLoaderLock;
    private int version;
    private boolean normalizeToUpper;
    private DatabaseClasses parent;
    private final GfxdLockSet compat;
    private boolean needReload;
    private JarReader jarReader;

    UpdateLoader(String classpath, DatabaseClasses parent, boolean verbose, boolean normalizeToUpper) throws StandardException {
        this.normalizeToUpper = normalizeToUpper;
        this.parent = parent;
        this.compat = new GfxdLockSet(this, new GfxdLocalLockService("update-loader-service", new GfxdReentrantReadWriteLock("UpdateLoader", true), (long)GfxdLockSet.MAX_VM_LOCKWAIT_VAL));
        if (verbose) {
            this.vs = Monitor.getStream();
        }
        this.myLoader = this.getClass().getClassLoader();
        this.classLoaderLock = new DefaultGfxdLockable("UpdateLoader", null);
        this.initializeFromClassPath(classpath);
    }

    private void initializeFromClassPath(String classpath) throws StandardException {
        final String[][] elements = IdUtil.parseDbClassPath(classpath);
        final int jarCount = elements.length;
        final JarLoader[] prevJarList = this.jarList;
        this.jarList = new JarLoader[jarCount];
        if (jarCount != 0) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (int i = 0; i < jarCount; ++i) {
                        if (prevJarList != null && prevJarList.length > 0) {
                            for (JarLoader prevLoader : prevJarList) {
                                if (prevLoader.isInvalid() || !Arrays.equals(prevLoader.name, elements[i])) continue;
                                ((UpdateLoader)UpdateLoader.this).jarList[i] = prevLoader;
                                break;
                            }
                        }
                        if (UpdateLoader.this.jarList[i] != null) continue;
                        ((UpdateLoader)UpdateLoader.this).jarList[i] = new JarLoader(UpdateLoader.this, elements[i], UpdateLoader.this.vs);
                    }
                    return null;
                }
            });
        }
        if (this.vs != null && (classpath != null && classpath.length() > 0 || GemFireXDUtils.TraceApplicationJars)) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)MessageService.getTextMessage("C005", classpath));
        }
        this.thisClasspath = classpath;
        this.initDone = false;
    }

    /*
     * Exception decompiling
     */
    Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InputStream getResourceAsStream(String name) {
        InputStream is;
        InputStream inputStream = is = this.myLoader == null ? ClassLoader.getSystemResourceAsStream(name) : this.myLoader.getResourceAsStream(name);
        if (is != null) {
            return is;
        }
        boolean unlockLoader = false;
        try {
            unlockLoader = this.lockClassLoader(ShExQual.SH);
            UpdateLoader updateLoader = this;
            synchronized (updateLoader) {
                if (this.needReload) {
                    this.reload();
                }
                if (!this.initDone) {
                    this.initLoaders();
                }
                for (int i = 0; i < this.jarList.length; ++i) {
                    JarLoader jl = this.jarList[i];
                    is = jl.getStream(name);
                    if (is == null) continue;
                    InputStream inputStream2 = is;
                    return inputStream2;
                }
            }
            updateLoader = null;
            return updateLoader;
        }
        catch (StandardException se) {
            InputStream inputStream3 = null;
            return inputStream3;
        }
        finally {
            if (unlockLoader) {
                this.releaseUpdateLoaderLock(false);
            }
        }
    }

    synchronized void modifyClasspath(String classpath) throws StandardException {
        boolean unlockLoader = this.lockClassLoader(ShExQual.EX);
        try {
            ++this.version;
            this.modifyJar(false);
            this.initializeFromClassPath(classpath);
        }
        finally {
            if (unlockLoader) {
                this.releaseUpdateLoaderLock(true);
            }
        }
    }

    void releaseUpdateLoaderLock() {
        LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
        if (lcc == null || !lcc.skipLocks()) {
            GfxdLockSet lockSet = this.compat;
            if (GemFireXDUtils.TraceLock) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("UpdateLoader: releasing all update loader locks for " + lockSet + ", owner=" + lockSet.getOwner() + ", skipLocks=" + (lcc != null ? lcc.skipLocks() : false)));
            }
            lockSet.unlockAll(true, true);
        }
    }

    private void releaseUpdateLoaderLock(boolean forUpdate) {
        LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
        if (lcc == null || !lcc.skipLocks()) {
            GfxdLockSet lockSet = this.getLockSet();
            if (GemFireXDUtils.TraceLock) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("UpdateLoader: attempting release update loader lock for " + lockSet + ", owner=" + lockSet.getOwner() + ", skipLocks=" + (lcc != null ? lcc.skipLocks() : false)));
            }
            lockSet.releaseLock(this.classLoaderLock, forUpdate, true);
        }
    }

    private GfxdLockSet getLockSet() {
        return this.compat;
    }

    synchronized void modifyClasspath(String classpath, int jar_op_type) {
        switch (jar_op_type) {
            case 0: {
                if (this.thisClasspath == null || this.thisClasspath.isEmpty()) {
                    this.thisClasspath = classpath;
                    break;
                }
                this.thisClasspath = this.thisClasspath + ':' + classpath;
                break;
            }
            case 1: {
                JarLoader jl;
                if (this.thisClasspath != null && !this.thisClasspath.isEmpty()) {
                    String[] classpaths;
                    StringBuilder sb = new StringBuilder(this.thisClasspath.length());
                    for (String cp : classpaths = this.thisClasspath.split(":")) {
                        if (cp.equals(classpath)) continue;
                        if (sb.length() > 0) {
                            sb.append(':');
                        }
                        sb.append(cp);
                    }
                    this.thisClasspath = sb.toString();
                }
                if ((jl = this.getJarLoaderForClassPath(classpath)) == null) break;
                jl.invalidateDependents(17);
                break;
            }
            case 2: {
                JarLoader jl = this.getJarLoaderForClassPath(classpath);
                if (jl == null) break;
                jl.invalidateDependents(18);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown jar op type=" + jar_op_type);
            }
        }
    }

    private JarLoader getJarLoaderForClassPath(String cp) {
        for (JarLoader jl : this.jarList) {
            if (!jl.getJarNameAsString().equals(cp)) continue;
            return jl;
        }
        return null;
    }

    JarLoader close(String schemaName, String sqlName) {
        for (JarLoader jarLoader : this.jarList) {
            String[] name = jarLoader.name;
            if (!name[0].equalsIgnoreCase(schemaName) || !name[1].equalsIgnoreCase(sqlName)) continue;
            jarLoader.setInvalid();
            return jarLoader;
        }
        return null;
    }

    synchronized void modifyJar(boolean reload) throws StandardException {
        boolean releaseLock = this.lockClassLoader(ShExQual.EX);
        try {
            ++this.version;
            if (reload) {
                this.initializeFromClassPath(this.thisClasspath);
            }
        }
        finally {
            if (releaseLock) {
                this.releaseUpdateLoaderLock(true);
            }
        }
    }

    private boolean lockClassLoader(ShExQual qualifier) throws StandardException {
        LanguageConnectionContext lcc;
        GfxdLockSet lockSet = this.getLockSet();
        LockOwner lockGroup = lockSet.getOwner();
        if (GemFireXDUtils.TraceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("UpdateLoader: acquiring update loader lock for " + lockSet + ", owner=" + lockGroup));
        }
        if ((lcc = Misc.getLanguageConnectionContext()) == null || !lcc.skipLocks()) {
            return lockSet.acquireLock(this.classLoaderLock, GfxdLockSet.MAX_LOCKWAIT_VAL, qualifier == ShExQual.EX, true, false) != 0;
        }
        return false;
    }

    Class checkLoaded(String className, boolean resolve) {
        for (int i = 0; i < this.jarList.length; ++i) {
            Class c = this.jarList[i].checkLoaded(className, resolve);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    void close() {
        for (int i = 0; i < this.jarList.length; ++i) {
            this.jarList[i].setInvalid();
        }
    }

    private void initLoaders() {
        if (this.initDone) {
            return;
        }
        for (int i = 0; i < this.jarList.length; ++i) {
            this.jarList[i].initialize();
        }
        this.initDone = true;
    }

    int getClassLoaderVersion() {
        return this.version;
    }

    synchronized void needReload() {
        ++this.version;
        this.needReload = true;
    }

    private void reload() throws StandardException {
        this.thisClasspath = this.getClasspath();
        this.close();
        this.initializeFromClassPath(this.thisClasspath);
        this.needReload = false;
    }

    private String getClasspath() throws StandardException {
        ClassFactoryContext cfc = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext");
        PersistentSet ps = cfc.getPersistentSet();
        String classpath = PropertyUtil.getServiceProperty(ps, "gemfirexd.distributedsystem.classpath");
        if (classpath == null) {
            classpath = "";
        }
        return classpath;
    }

    JarReader getJarReader() {
        if (this.jarReader == null) {
            ClassFactoryContext cfc = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext");
            this.jarReader = cfc.getJarReader();
        }
        return this.jarReader;
    }

    @Override
    public boolean noWait() {
        return false;
    }
}

