/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.reflect;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedByteCode;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.services.reflect.DirectCall;
import com.pivotal.gemfirexd.internal.impl.services.reflect.GCInstanceFactory;
import com.pivotal.gemfirexd.internal.impl.services.reflect.LoadedGeneratedClass;
import com.pivotal.gemfirexd.internal.impl.services.reflect.ReflectMethod;
import java.lang.reflect.Method;
import java.util.Hashtable;

public final class ReflectGeneratedClass
extends LoadedGeneratedClass {
    private final Hashtable methodCache = new Hashtable();
    private static final GeneratedMethod[] directs = new GeneratedMethod[10];
    private final Class factoryClass;
    private GCInstanceFactory factory;

    public ReflectGeneratedClass(ClassFactory cf, Class jvmClass, Class factoryClass) {
        super(cf, jvmClass);
        this.factoryClass = factoryClass;
    }

    @Override
    public Object newInstance(LanguageConnectionContext context, boolean addToLCC, ExecPreparedStatement eps) throws StandardException {
        if (this.factoryClass == null) {
            return super.newInstance(context, addToLCC, eps);
        }
        if (this.factory == null) {
            Throwable t;
            try {
                this.factory = (GCInstanceFactory)this.factoryClass.newInstance();
                t = null;
            }
            catch (InstantiationException ie) {
                t = ie;
            }
            catch (IllegalAccessException iae) {
                t = iae;
            }
            catch (LinkageError le) {
                t = le;
            }
            if (t != null) {
                throw StandardException.newException("XBCM2.S", t, (Object)this.getName());
            }
        }
        GeneratedByteCode ni = this.factory.getNewInstance();
        ni.initFromContext(context, addToLCC, eps);
        ni.setGC(this);
        ni.postConstructor();
        return ni;
    }

    @Override
    public GeneratedMethod getMethod(String simpleName) throws StandardException {
        GeneratedMethod rm = (GeneratedMethod)this.methodCache.get(simpleName);
        if (rm != null) {
            return rm;
        }
        try {
            if (simpleName.length() == 2 && simpleName.startsWith("e")) {
                int id = simpleName.charAt(1) - 48;
                rm = directs[id];
            } else {
                Method m = this.getJVMClass().getMethod(simpleName, null);
                rm = new ReflectMethod(m);
            }
            this.methodCache.put(simpleName, rm);
            return rm;
        }
        catch (NoSuchMethodException nsme) {
            throw StandardException.newException("XBCM3.S", nsme, (Object)this.getName(), (Object)simpleName);
        }
    }

    static {
        for (int i = 0; i < directs.length; ++i) {
            ReflectGeneratedClass.directs[i] = new DirectCall(i);
        }
    }
}

