/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.reflect;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedByteCode;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import java.sql.SQLException;

class DirectCall
implements GeneratedMethod {
    private final int which;

    DirectCall(int which) {
        this.which = which;
    }

    @Override
    public Object invoke(Object ref) throws StandardException {
        try {
            GeneratedByteCode gref = (GeneratedByteCode)ref;
            switch (this.which) {
                case 0: {
                    return gref.e0();
                }
                case 1: {
                    return gref.e1();
                }
                case 2: {
                    return gref.e2();
                }
                case 3: {
                    return gref.e3();
                }
                case 4: {
                    return gref.e4();
                }
                case 5: {
                    return gref.e5();
                }
                case 6: {
                    return gref.e6();
                }
                case 7: {
                    return gref.e7();
                }
                case 8: {
                    return gref.e8();
                }
                case 9: {
                    return gref.e9();
                }
            }
            return null;
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            StandardException se = this.checkForSQLExceptionAndStandardException(t);
            if (se != null) {
                throw se;
            }
            throw StandardException.unexpectedUserException(t);
        }
    }

    private StandardException checkForSQLExceptionAndStandardException(Throwable t) {
        if (t instanceof SQLException) {
            return Misc.wrapSQLException((SQLException)t, t);
        }
        for (Throwable innerException = t.getCause(); innerException != null; innerException = innerException.getCause()) {
            if (innerException instanceof StandardException) {
                return (StandardException)innerException;
            }
            if (!(innerException instanceof SQLException)) continue;
            return Misc.wrapSQLException((SQLException)innerException, t);
        }
        return null;
    }
}

