/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.monitor;

import com.pivotal.gemfirexd.internal.iapi.error.PassThroughException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.PersistentService;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.services.monitor.BaseMonitor;
import com.pivotal.gemfirexd.internal.io.WritableStorageFactory;
import java.util.Properties;

public class UpdateServiceProperties
extends Properties {
    private PersistentService serviceType;
    private String serviceName;
    private volatile WritableStorageFactory storageFactory;
    private boolean serviceBooted;

    public UpdateServiceProperties(PersistentService serviceType, String serviceName, Properties actualSet, boolean serviceBooted) {
        super(actualSet);
        this.serviceType = serviceType;
        this.serviceName = serviceName;
        this.serviceBooted = serviceBooted;
    }

    public void setServiceBooted() {
        this.serviceBooted = true;
    }

    public void setStorageFactory(WritableStorageFactory storageFactory) {
        this.storageFactory = storageFactory;
    }

    public WritableStorageFactory getStorageFactory() {
        return this.storageFactory;
    }

    @Override
    public Object put(Object key, Object value) {
        Object ref = this.defaults.put(key, value);
        if (!((String)key).startsWith("gemfirexd.__rt.")) {
            this.update();
        }
        return ref;
    }

    @Override
    public Object remove(Object key) {
        Object ref = this.defaults.remove(key);
        if (ref != null && !((String)key).startsWith("gemfirexd.__rt.")) {
            this.update();
        }
        return ref;
    }

    @Override
    public Object get(Object key) {
        Object ref = super.get(key);
        if (ref == null && this.defaults != null) {
            ref = this.defaults.get(key);
        }
        return ref;
    }

    public void saveServiceProperties() {
        SanityManager.ASSERT((this.storageFactory != null ? 1 : 0) != 0, (String)"UpdateServiceProperties.saveServiceProperties() called before storageFactory set.");
        try {
            this.serviceType.saveServiceProperties(this.serviceName, this.storageFactory, BaseMonitor.removeRuntimeProperties(this.defaults), false);
        }
        catch (StandardException mse) {
            throw new PassThroughException(mse);
        }
    }

    private void update() {
        try {
            if (this.serviceBooted) {
                this.serviceType.saveServiceProperties(this.serviceName, this.storageFactory, BaseMonitor.removeRuntimeProperties(this.defaults), true);
            }
        }
        catch (StandardException mse) {
            throw new PassThroughException(mse);
        }
    }

    @Override
    public synchronized String toString() {
        return super.toString() + " " + this.defaults.toString();
    }
}

