/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.monitor;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;

class ProtocolKey {
    protected Class factoryInterface;
    protected String identifier;

    protected ProtocolKey(Class factoryInterface, String identifier) {
        this.factoryInterface = factoryInterface;
        this.identifier = identifier;
    }

    static ProtocolKey create(String className, String identifier) throws StandardException {
        Exception t;
        try {
            return new ProtocolKey(Class.forName(className), identifier);
        }
        catch (ClassNotFoundException cnfe) {
            t = cnfe;
        }
        catch (IllegalArgumentException iae) {
            t = iae;
        }
        throw Monitor.exceptionStartingModule(t);
    }

    protected Class getFactoryInterface() {
        return this.factoryInterface;
    }

    protected String getIdentifier() {
        return this.identifier;
    }

    public int hashCode() {
        return this.factoryInterface.hashCode() + (this.identifier == null ? 0 : this.identifier.hashCode());
    }

    public boolean equals(Object other) {
        if (other instanceof ProtocolKey) {
            ProtocolKey otherKey = (ProtocolKey)other;
            if (this.factoryInterface != otherKey.factoryInterface) {
                return false;
            }
            if (this.identifier == null) {
                if (otherKey.identifier != null) {
                    return false;
                }
            } else {
                if (otherKey.identifier == null) {
                    return false;
                }
                if (!this.identifier.equals(otherKey.identifier)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.factoryInterface.getName() + " (" + this.identifier + ")";
    }
}

