/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.locks;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.iapi.services.locks.CompatibilitySpace;
import com.pivotal.gemfirexd.internal.iapi.services.locks.Limit;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockFactory;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockOwner;
import com.pivotal.gemfirexd.internal.iapi.services.locks.Lockable;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.util.Matchable;
import com.pivotal.gemfirexd.internal.impl.services.locks.D_LockControl;
import com.pivotal.gemfirexd.internal.impl.services.locks.Lock;
import com.pivotal.gemfirexd.internal.impl.services.locks.LockSpace;
import com.pivotal.gemfirexd.internal.impl.services.locks.LockTable;
import com.pivotal.gemfirexd.internal.impl.services.locks.LockTableVTI;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;

abstract class AbstractPool
implements LockFactory {
    protected final LockTable lockTable = this.createLockTable();
    int deadlockMonitor;

    protected AbstractPool() {
    }

    protected abstract LockTable createLockTable();

    @Override
    public boolean lockObject(CompatibilitySpace compatibilitySpace, Object group, Lockable ref, Object qualifier, int timeout) throws StandardException {
        Lock lock;
        if (SanityManager.DEBUG_ON((String)"LockTrace")) {
            D_LockControl.debugLock("Lock Request before Grant: ", compatibilitySpace, group, ref, qualifier, timeout);
            if (SanityManager.DEBUG_ON((String)"LockStackTrace")) {
                Throwable t = new Throwable();
                PrintWriter istream = SanityManager.GET_DEBUG_STREAM();
                istream.println("Stack trace of lock request:");
                t.printStackTrace(istream);
            }
        }
        if ((lock = this.lockTable.lockObject(compatibilitySpace, ref, qualifier, timeout)) == null) {
            SanityManager.ASSERT((boolean)AbstractPool.noLockWait(timeout, compatibilitySpace), (String)"timeout not NO_WAIT");
            if (timeout == -2) {
                throw StandardException.newException("40XL1");
            }
            return false;
        }
        if (SanityManager.DEBUG_ON((String)"LockTrace")) {
            D_LockControl.debugLock("Lock Request Granted: ", compatibilitySpace, group, ref, qualifier, timeout);
        }
        ((LockSpace)compatibilitySpace).addLock(group, lock);
        return true;
    }

    @Override
    public CompatibilitySpace createCompatibilitySpace(LockOwner owner) {
        return new LockSpace(owner);
    }

    @Override
    public int unlock(CompatibilitySpace compatibilitySpace, Object group, Lockable ref, Object qualifier) {
        int count;
        if (SanityManager.DEBUG_ON((String)"LockTrace")) {
            D_LockControl.debugLock("Lock Unlock: ", compatibilitySpace, group, ref, qualifier, -1);
        }
        SanityManager.ASSERT(((count = ((LockSpace)compatibilitySpace).unlockReference(this.lockTable, ref, qualifier, group)) == 0 || count == 1 ? 1 : 0) != 0, (String)("count = " + count));
        return count;
    }

    @Override
    public void unlockGroup(CompatibilitySpace compatibilitySpace, Object group) {
        if (SanityManager.DEBUG_ON((String)"LockTrace")) {
            D_LockControl.debugLock("Lock Unlock Group: ", compatibilitySpace, group);
        }
        ((LockSpace)compatibilitySpace).unlockGroup(this.lockTable, group);
    }

    @Override
    public void unlockGroup(CompatibilitySpace compatibilitySpace, Object group, Matchable key) {
        if (SanityManager.DEBUG_ON((String)"LockTrace")) {
            D_LockControl.debugLock("Lock Unlock Group: ", compatibilitySpace, group);
        }
        ((LockSpace)compatibilitySpace).unlockGroup(this.lockTable, group, key);
    }

    @Override
    public void transfer(CompatibilitySpace compatibilitySpace, Object oldGroup, Object newGroup) {
        if (SanityManager.DEBUG_ON((String)"LockTrace")) {
            StringBuilder sb = new StringBuilder("Lock Transfer:");
            D_LockControl.debugAppendObject(sb, " CompatibilitySpace=", compatibilitySpace);
            D_LockControl.debugAppendObject(sb, " Old Group=", oldGroup);
            D_LockControl.debugAppendObject(sb, " New Group=", newGroup);
            D_LockControl.debugAddThreadInfo(sb);
            SanityManager.DEBUG((String)"LockTrace", (String)sb.toString());
        }
        ((LockSpace)compatibilitySpace).transfer(oldGroup, newGroup);
    }

    @Override
    public boolean anyoneBlocked() {
        return this.lockTable.anyoneBlocked();
    }

    @Override
    public boolean areLocksHeld(CompatibilitySpace compatibilitySpace, Object group) {
        return ((LockSpace)compatibilitySpace).areLocksHeld(group);
    }

    @Override
    public boolean areLocksHeld(CompatibilitySpace compatibilitySpace) {
        return ((LockSpace)compatibilitySpace).areLocksHeld();
    }

    @Override
    public boolean zeroDurationlockObject(CompatibilitySpace compatibilitySpace, Lockable ref, Object qualifier, int timeout) throws StandardException {
        boolean success = this.lockTable.zeroDurationLockObject(compatibilitySpace, ref, qualifier, timeout);
        if (!success) {
            SanityManager.ASSERT((boolean)AbstractPool.noLockWait(timeout, compatibilitySpace), (String)"Should have timed out");
            if (timeout == -2) {
                throw StandardException.newException("40XL1");
            }
        }
        return success;
    }

    @Override
    public boolean isLockHeld(CompatibilitySpace compatibilitySpace, Object group, Lockable ref, Object qualifier) {
        return ((LockSpace)compatibilitySpace).isLockHeld(group, ref, qualifier);
    }

    @Override
    public void setLimit(CompatibilitySpace compatibilitySpace, Object group, int limit, Limit callback) {
        ((LockSpace)compatibilitySpace).setLimit(group, limit, callback);
    }

    @Override
    public void clearLimit(CompatibilitySpace compatibilitySpace, Object group) {
        ((LockSpace)compatibilitySpace).clearLimit(group);
    }

    static boolean noLockWait(int timeout, CompatibilitySpace compat) {
        if (timeout == 0) {
            return true;
        }
        LockOwner owner = compat.getOwner();
        return owner != null && owner.noWait();
    }

    @Override
    public Enumeration makeVirtualLockTable() {
        LockTableVTI myclone = new LockTableVTI(this.lockTable.shallowClone());
        return myclone;
    }

    @Override
    public void init(boolean dbOnly, Dictionary p) {
        this.getAndApply(dbOnly, p, "gemfirexd.locks.deadlockTimeout");
        this.getAndApply(dbOnly, p, "gemfirexd.locks.waitTimeout");
        this.getAndApply(dbOnly, p, "gemfirexd.locks.monitor");
        this.getAndApply(dbOnly, p, "gemfirexd.locks.deadlockTrace");
    }

    private void getAndApply(boolean dbOnly, Dictionary p, String key) {
        try {
            String value = (String)((Object)PropertyUtil.getPropertyFromSet(dbOnly, p, key));
            if (value != null) {
                this.validate(key, (Serializable)((Object)value), p);
                this.apply(key, (Serializable)((Object)value), p);
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }

    @Override
    public boolean validate(String key, Serializable value, Dictionary p) throws StandardException {
        if (!key.startsWith("gemfirexd.locks.")) {
            return false;
        }
        if (value != null) {
            if (key.equals("gemfirexd.locks.deadlockTimeout")) {
                AbstractPool.getWaitValue((String)((Object)value), 20);
            } else if (key.equals("gemfirexd.locks.waitTimeout")) {
                AbstractPool.getWaitValue((String)((Object)value), 60);
            } else if (key.equals("gemfirexd.locks.monitor")) {
                PropertyUtil.booleanProperty("gemfirexd.locks.monitor", value, false);
            } else if (key.equals("gemfirexd.locks.deadlockTrace")) {
                PropertyUtil.booleanProperty("gemfirexd.locks.deadlockTrace", value, false);
            }
        }
        return true;
    }

    @Override
    public Serviceable apply(String key, Serializable value, Dictionary p) throws StandardException {
        if (value == null) {
            value = PropertyUtil.getPropertyFromSet(p, key);
        }
        String svalue = (String)((Object)value);
        if (key.equals("gemfirexd.locks.deadlockTimeout")) {
            this.lockTable.setDeadlockTimeout(AbstractPool.getWaitValue(svalue, 20));
        } else if (key.equals("gemfirexd.locks.waitTimeout")) {
            this.lockTable.setWaitTimeout(AbstractPool.getWaitValue(svalue, 60));
        } else if (key.equals("gemfirexd.locks.monitor")) {
            this.deadlockMonitor = PropertyUtil.booleanProperty("gemfirexd.locks.monitor", (Serializable)((Object)svalue), false) ? 2 : 0;
        } else if (key.equals("gemfirexd.locks.deadlockTrace")) {
            this.lockTable.setDeadlockTrace(PropertyUtil.booleanProperty("gemfirexd.locks.deadlockTrace", (Serializable)((Object)svalue), false));
        }
        return null;
    }

    @Override
    public Serializable map(String key, Serializable value, Dictionary p) {
        return null;
    }

    private static int getWaitValue(String value, int defaultValue) {
        int wait = PropertyUtil.handleInt(value, Integer.MIN_VALUE, 2147483, defaultValue);
        wait = wait < 0 ? -1 : (wait *= 1000);
        return wait;
    }
}

