/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.cache;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheableFactory;
import com.pivotal.gemfirexd.internal.impl.services.cache.CacheEntry;
import com.pivotal.gemfirexd.internal.impl.services.cache.ConcurrentCache;

final class GfxdConcurrentCache
extends ConcurrentCache {
    GfxdConcurrentCache(CacheableFactory holderFactory, String name, int initialSize, int maxSize) {
        super(holderFactory, name, initialSize, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cacheable find(Object key) throws StandardException {
        block11: {
            Cacheable itemWithIdentity;
            if (this.stopped) {
                return null;
            }
            CacheEntry entry = (CacheEntry)this.cache.get(key);
            while (true) {
                Cacheable item;
                if (entry != null) {
                    entry.lock();
                    if (entry.isValid()) {
                        try {
                            item = entry.getCacheable();
                            entry.keep(true);
                            Cacheable cacheable = item;
                            return cacheable;
                        }
                        finally {
                            entry.unlock();
                        }
                    }
                    entry.unlock();
                    entry = (CacheEntry)this.cache.get(key);
                    continue;
                }
                entry = new CacheEntry(true);
                entry.lock();
                try {
                    item = this.insertIntoFreeSlot(key, entry);
                }
                finally {
                    entry.unlock();
                }
                itemWithIdentity = item.setIdentity(key);
                if (itemWithIdentity == null) break block11;
                entry.setCacheable(itemWithIdentity);
                CacheEntry oldEntry = this.cache.putIfAbsent(key, entry);
                if (oldEntry == null) break;
                entry = oldEntry;
            }
            return itemWithIdentity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cacheable create(Object key, Object createParameter) throws StandardException {
        Cacheable item;
        if (this.stopped) {
            return null;
        }
        CacheEntry entry = new CacheEntry(true);
        entry.lock();
        try {
            item = this.insertIntoFreeSlot(key, entry);
        }
        finally {
            entry.unlock();
        }
        Cacheable itemWithIdentity = item.createIdentity(key, createParameter);
        if (itemWithIdentity != null) {
            entry.setCacheable(itemWithIdentity);
            if (this.cache.putIfAbsent(key, entry) != null) {
                throw StandardException.newException("XBCA0.S", (Object)this.name, key);
            }
        }
        return itemWithIdentity;
    }
}

