/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.bytecode;

import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCJava;

class BCMethodDescriptor {
    static final String[] EMPTY = new String[0];
    private final String[] vmParameterTypes;
    private final String vmReturnType;
    private final String vmDescriptor;

    BCMethodDescriptor(String[] vmParameterTypes, String vmReturnType, BCJava factory) {
        this.vmParameterTypes = vmParameterTypes;
        this.vmReturnType = vmReturnType;
        this.vmDescriptor = factory.vmType(this);
    }

    static String get(String[] vmParameterTypes, String vmReturnType, BCJava factory) {
        return new BCMethodDescriptor(vmParameterTypes, vmReturnType, factory).toString();
    }

    String buildMethodDescriptor() {
        int paramCount = this.vmParameterTypes.length;
        int approxLength = 30 * (paramCount + 1);
        StringBuilder methDesc = new StringBuilder(approxLength);
        methDesc.append('(');
        for (int i = 0; i < paramCount; ++i) {
            methDesc.append(this.vmParameterTypes[i]);
        }
        methDesc.append(')');
        methDesc.append(this.vmReturnType);
        return methDesc.toString();
    }

    public String toString() {
        return this.vmDescriptor;
    }

    public int hashCode() {
        return this.vmParameterTypes.length | this.vmReturnType.hashCode() & 0xFFFFFF00;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BCMethodDescriptor)) {
            return false;
        }
        BCMethodDescriptor o = (BCMethodDescriptor)other;
        if (o.vmParameterTypes.length != this.vmParameterTypes.length) {
            return false;
        }
        for (int i = 0; i < this.vmParameterTypes.length; ++i) {
            if (this.vmParameterTypes[i].equals(o.vmParameterTypes[i])) continue;
            return false;
        }
        return this.vmReturnType.equals(o.vmReturnType);
    }
}

