/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.load;

import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitInputStream;
import com.pivotal.gemfirexd.internal.impl.load.ImportFileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class ImportLobFile {
    private ImportFileInputStream lobInputStream = null;
    private LimitInputStream lobLimitIn;
    private Reader lobReader = null;
    private String dataCodeset;

    ImportLobFile(File lobFile, String dataCodeset) throws Exception {
        this.dataCodeset = dataCodeset;
        this.openLobFile(lobFile);
    }

    private void openLobFile(final File lobFile) throws Exception {
        RandomAccessFile lobRaf;
        try {
            try {
                lobRaf = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new RandomAccessFile(lobFile, "r");
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (FileNotFoundException ex) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0P.S", lobFile.getPath()));
        }
        this.lobInputStream = new ImportFileInputStream(lobRaf);
        this.lobLimitIn = new LimitInputStream(this.lobInputStream);
    }

    public InputStream getBinaryStream(long offset, long length) throws IOException {
        this.lobInputStream.seek(offset);
        this.lobLimitIn.clearLimit();
        this.lobLimitIn.setLimit((int)length);
        return this.lobLimitIn;
    }

    public String getString(int offset, int length) throws IOException {
        this.lobInputStream.seek(offset);
        this.lobLimitIn.clearLimit();
        this.lobLimitIn.setLimit(length);
        this.lobReader = this.dataCodeset == null ? new InputStreamReader(this.lobLimitIn) : new InputStreamReader((InputStream)this.lobLimitIn, this.dataCodeset);
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        int noChars = this.lobReader.read(buf, 0, 1024);
        while (noChars != -1) {
            sb.append(buf, 0, noChars);
            noChars = this.lobReader.read(buf, 0, 1024);
        }
        return sb.toString();
    }

    public Reader getCharacterStream(long offset, long length) throws IOException {
        this.lobInputStream.seek(offset);
        this.lobLimitIn.clearLimit();
        this.lobLimitIn.setLimit((int)length);
        this.lobReader = this.dataCodeset == null ? new InputStreamReader(this.lobLimitIn) : new InputStreamReader((InputStream)this.lobLimitIn, this.dataCodeset);
        return this.lobReader;
    }

    public long getClobDataLength(long offset, long length) throws IOException {
        this.lobInputStream.seek(offset);
        this.lobLimitIn.clearLimit();
        this.lobLimitIn.setLimit((int)length);
        this.lobReader = this.dataCodeset == null ? new InputStreamReader(this.lobLimitIn) : new InputStreamReader((InputStream)this.lobLimitIn, this.dataCodeset);
        char[] buf = new char[1024];
        long lengthInChars = 0L;
        int noChars = this.lobReader.read(buf, 0, 1024);
        while (noChars != -1) {
            lengthInChars += (long)noChars;
            noChars = this.lobReader.read(buf, 0, 1024);
        }
        return lengthInChars;
    }

    public void close() throws IOException {
        if (this.lobReader != null) {
            this.lobReader.close();
        } else if (this.lobLimitIn != null) {
            this.lobLimitIn.close();
        } else if (this.lobInputStream != null) {
            this.lobInputStream.close();
        }
    }
}

