/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.load;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.TransactionFlag;
import com.gemstone.gemfire.internal.concurrent.ConcurrentTLongObjectHashMap;
import com.pivotal.gemfirexd.callbacks.ImportErrorLogger;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockSet;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockOwner;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.load.ColumnInfo;
import com.pivotal.gemfirexd.internal.impl.load.ControlInfo;
import com.pivotal.gemfirexd.internal.impl.load.ImportAbstract;
import com.pivotal.gemfirexd.internal.impl.load.ImportReadData;
import com.pivotal.gemfirexd.internal.impl.load.LoadError;
import com.pivotal.gemfirexd.internal.impl.load.MTImport;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ImportBase
extends ImportAbstract {
    public static final int MINUS_ONE = -1;
    public static boolean TEST_IMPORT = false;
    private static AtomicInteger _importCounter = new AtomicInteger(0);
    static ConcurrentTLongObjectHashMap<ImportBase> _importers = new ConcurrentTLongObjectHashMap(4);
    private String inputFileName;
    private final long offset;
    private final long endPosition;
    char[][] currentRows;
    int currentRowIndex;
    boolean eofReceived;

    public ImportBase(String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, long offset, long endPosition, boolean hasColumnDefinition, int noOfColumnsExpected, String columnTypes, boolean lobsInExtFile, int importCounter, String columnTypeNames, String udtClassNamesString) throws SQLException {
        try {
            this.inputFileName = inputFileName;
            this.offset = offset;
            this.endPosition = endPosition;
            this.noOfColumnsExpected = noOfColumnsExpected;
            this.tableColumnTypesStr = columnTypes;
            this.columnTypeNamesString = columnTypeNames;
            this.udtClassNamesString = udtClassNamesString;
            this.controlFileReader = new ControlInfo();
            this.controlFileReader.setControlProperties(characterDelimiter, columnDelimiter, codeset);
            if (hasColumnDefinition) {
                this.controlFileReader.setcolumnDefinition("True");
            }
            this.lobsInExtFile = lobsInExtFile;
            _importers.putPrimitive((long)importCounter, (Object)this);
            if (GemFireXDUtils.TraceImport) {
                SanityManager.DEBUG_PRINT((String)"TraceImport", (String)("Starting Import from " + inputFileName + ", columnDelimiter=" + columnDelimiter + ", charDelimiter=" + characterDelimiter + ", codeset=" + codeset + ", offset=" + offset + ", endPosition=" + endPosition + ", columnsExpected=" + noOfColumnsExpected + ", columnTypes=" + columnTypes + ", lobsInExtFile=" + lobsInExtFile + ", columnTypeNames=" + columnTypeNames + ", udtClasses=" + udtClassNamesString + ", importCounter=" + importCounter));
            }
            this.doImport();
        }
        catch (Exception e) {
            throw this.importError(e);
        }
    }

    private void doImport() throws Exception {
        if (this.inputFileName == null) {
            throw LoadError.dataFileNull();
        }
        this.doAllTheWork();
    }

    public static void importTable(Connection connection, String schemaName, String tableName, String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, boolean lockTable, int numThreads, String importClassName, boolean lobsInExtFile, String errorFile) throws SQLException {
        ImportBase.performImport(connection, schemaName, null, null, tableName, inputFileName, columnDelimiter, characterDelimiter, codeset, replace, lockTable, numThreads, importClassName, lobsInExtFile, errorFile);
    }

    public static void importData(Connection connection, String schemaName, String tableName, String insertColumnList, String columnIndexes, String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, boolean lockTable, int numThreads, String importClassName, boolean lobsInExtFile, String errorFile) throws SQLException {
        ImportBase.performImport(connection, schemaName, insertColumnList, columnIndexes, tableName, inputFileName, columnDelimiter, characterDelimiter, codeset, replace, lockTable, numThreads, importClassName, lobsInExtFile, errorFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performImport(Connection connection, final String schemaName, final String insertColumnList, final String columnIndexes, final String tableName, final String inputFileName, final String columnDelimiter, final String characterDelimiter, final String codeset, final short replace, boolean lockTable, int numThreads, final String importClass, final boolean lobsInExtFile, String errorFile) throws SQLException {
        block81: {
            EnumSet<TransactionFlag> txFlags;
            boolean skipListeners;
            int lccFlags;
            LockOwner parentLockOwner;
            String mtErrorFile;
            String udtClassNames;
            String columnTypeNames;
            ColumnInfo columnInfo;
            int importCounter;
            block82: {
                importCounter = ImportBase.bumpImportCounter();
                if (connection == null) {
                    throw LoadError.connectionNull();
                }
                if (tableName == null) {
                    throw LoadError.entityNameMissing();
                }
                if (inputFileName == null) {
                    throw LoadError.dataFileNull();
                }
                columnInfo = new ColumnInfo(connection, schemaName, tableName, insertColumnList, columnIndexes, "COLUMN", inputFileName, columnDelimiter);
                try {
                    columnTypeNames = columnInfo.getColumnTypeNames();
                    udtClassNames = columnInfo.getUDTClassNames();
                }
                catch (Throwable t) {
                    throw ImportBase.formatImportError((ImportBase)_importers.getPrimitive((long)importCounter), inputFileName, t);
                }
                if (numThreads < 1) {
                    throw LoadError.unexpectedError(new RuntimeException("numThreads=" + numThreads));
                }
                if (GemFireXDUtils.TraceImport) {
                    SanityManager.DEBUG_PRINT((String)"TraceImport", (String)("Call performImport " + inputFileName + ", numThreads=" + numThreads + " ,errorFile=" + errorFile));
                }
                if (errorFile != null) {
                    StringBuilder filePath = new StringBuilder();
                    int indx = errorFile.lastIndexOf(46);
                    if (indx > -1) {
                        filePath.append(errorFile.substring(0, indx));
                    } else {
                        filePath.append(errorFile);
                    }
                    filePath.append("_");
                    filePath.append(System.currentTimeMillis());
                    if (errorFile.contains(File.separator)) {
                        String basePath = null;
                        GemFireStore store = Misc.getMemStore();
                        if (store != null) {
                            basePath = store.generatePersistentDirName(null);
                            filePath.insert(0, File.separator);
                            filePath.insert(0, basePath);
                        }
                    }
                    mtErrorFile = filePath.toString();
                    if (numThreads == 1) {
                        ++numThreads;
                    }
                } else {
                    mtErrorFile = null;
                }
                if (numThreads != 1) break block82;
                ImportBase.performImport(connection, schemaName, insertColumnList, columnIndexes, tableName, inputFileName, columnDelimiter, characterDelimiter, codeset, replace, lockTable, importClass, lobsInExtFile, 0L, 0L, columnInfo, columnTypeNames, udtClassNames, importCounter, -1L, null);
                break block81;
            }
            final AtomicReference<Throwable> err = new AtomicReference<Throwable>();
            int isolation = connection.getTransactionIsolation();
            GemFireStore memStore = Misc.getMemStoreBooting();
            final long[] queueId = new long[]{-1L};
            ImportBase importer = null;
            if (connection instanceof EmbedConnection) {
                EmbedConnection embedConn = (EmbedConnection)connection;
                LanguageConnectionContext lcc = embedConn.getLanguageConnection();
                parentLockOwner = lcc.getTransactionExecute().getLockSpace().getOwner();
                lccFlags = lcc.getFlags();
                skipListeners = lcc.isSkipListeners();
                txFlags = lcc.getTXFlags();
            } else {
                lccFlags = 0;
                skipListeners = false;
                txFlags = null;
                parentLockOwner = null;
            }
            Thread[] threads = new Thread[--numThreads];
            final AtomicInteger threadId = new AtomicInteger(0);
            final EmbedConnection[] conns = new EmbedConnection[numThreads];
            Runnable mtImportTask = new Runnable(){

                @Override
                public void run() {
                    int id = threadId.getAndIncrement();
                    EmbedConnection conn = conns[id];
                    try {
                        ImportBase.performMTImport(conn, schemaName, insertColumnList, columnIndexes, tableName, inputFileName, columnDelimiter, characterDelimiter, codeset, replace, false, importClass, lobsInExtFile, 0L, 0L, columnInfo, columnTypeNames, udtClassNames, ImportBase.bumpImportCounter(), queueId[0], mtErrorFile);
                    }
                    catch (Throwable t) {
                        ImportBase.checkThrowable(t, "Import: multi-threaded import failure");
                        err.compareAndSet(null, t);
                    }
                }
            };
            try {
                int i;
                ArrayBlockingQueue<MTImport.QueueData> dataQueue;
                int numConns;
                block80: {
                    Properties props = new Properties();
                    props.putAll((Map<?, ?>)memStore.getDatabase().getAuthenticationService().getBootCredentials());
                    for (numConns = 0; numConns < numThreads; ++numConns) {
                        EmbedConnection conn = (EmbedConnection)InternalDriver.activeDriver().connect("jdbc:gemfirexd:", props);
                        if (isolation != conn.getTransactionIsolation()) {
                            conn.setAutoCommit(false);
                            conn.setTransactionIsolation(isolation);
                        }
                        LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
                        if (lccFlags != 0) {
                            lcc.setFlags(lccFlags);
                        }
                        if (skipListeners) {
                            lcc.setSkipListeners();
                        }
                        if (txFlags != null) {
                            lcc.setTXFlags(txFlags);
                        }
                        if (parentLockOwner != null) {
                            ((GfxdLockSet)lcc.getTransactionCompile().getLockSpace()).setOwner(parentLockOwner);
                            ((GfxdLockSet)lcc.getTransactionExecute().getLockSpace()).setOwner(parentLockOwner);
                        }
                        conns[numConns] = conn;
                    }
                    if (lockTable) {
                        Statement statement = connection.createStatement();
                        Thread[] entityName = IdUtil.mkQualifiedName(schemaName, tableName);
                        String lockSql = "LOCK TABLE " + (String)entityName + " IN EXCLUSIVE MODE";
                        statement.executeUpdate(lockSql);
                        statement.close();
                        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                        if (observer != null) {
                            observer.afterLockingTableDuringImport();
                        }
                    }
                    for (int i2 = 0; i2 < numThreads; ++i2) {
                        threads[i2] = new Thread(mtImportTask);
                        threads[i2].setDaemon(true);
                    }
                    dataQueue = new ArrayBlockingQueue<MTImport.QueueData>(numThreads + 2);
                    queueId[0] = MTImport.putNewQueue(dataQueue);
                    for (Thread th : threads) {
                        th.start();
                    }
                    try {
                        char[] line;
                        importer = new ImportBase(inputFileName, columnDelimiter, characterDelimiter, codeset, 0L, 0L, columnInfo.hasColumnDefinitionInFile(), columnInfo.getExpectedNumberOfColumnsInFile(), columnInfo.getExpectedVtiColumnTypesAsString(), lobsInExtFile, importCounter, columnTypeNames, udtClassNames);
                        int bufSize = TEST_IMPORT ? 10 : 1024;
                        char[][] batch = new char[bufSize + 1][];
                        GfxdHeapThresholdListener thresholdListener = memStore.thresholdListener();
                        int bufIndex = 0;
                        int batchSize = 0;
                        int startLineNumber = 0;
                        while ((line = importer.importReadData.readNextLine()) != null) {
                            if (bufIndex > 0 && (bufIndex >= bufSize || (long)(batchSize += line.length * 2) > GemFireXDUtils.DML_MAX_CHUNK_SIZE || thresholdListener.isEviction() || thresholdListener.isCritical())) {
                                bufIndex = 0;
                                if (!ImportBase.addQueueData(dataQueue, new MTImport.QueueData(batch, startLineNumber), err, threads)) break;
                                Throwable t = err.get();
                                if (t != null) {
                                    throw t;
                                }
                                batch = new char[bufSize + 1][];
                                batchSize = 0;
                                startLineNumber = importer.importReadData.getCurrentRowNumber();
                            }
                            batch[bufIndex++] = line;
                        }
                        if (bufIndex <= 0) break block80;
                        ImportBase.addQueueData(dataQueue, new MTImport.QueueData(batch, startLineNumber), err, threads);
                    }
                    catch (Throwable throwable) {
                        int i3;
                        for (int i4 = 0; i4 < numThreads; ++i4) {
                            ImportBase.addQueueData(dataQueue, MTImport.QUEUE_EOF_TOKEN, err, threads);
                        }
                        block41: for (Thread th : threads) {
                            try {
                                while (th.isAlive()) {
                                    if (err.get() != null) {
                                        th.join(100L);
                                        th.join(1000L);
                                        continue block41;
                                    }
                                    th.join(1000L);
                                }
                            }
                            catch (Throwable t) {
                                ImportBase.checkThrowable(t, "Import: multi-threaded import failure in join");
                                err.compareAndSet(null, t);
                            }
                        }
                        boolean doCommit = err.get() == null && numConns == numThreads;
                        for (i3 = 0; i3 < numConns; ++i3) {
                            try {
                                if (doCommit) {
                                    ((GemFireTransaction)conns[i3].getLanguageConnection().getTransactionExecute()).xa_prepare();
                                    continue;
                                }
                                conns[i3].rollback();
                                continue;
                            }
                            catch (Throwable t) {
                                ImportBase.checkThrowable(t, "Import: multi-threaded import failure " + (doCommit ? "in prepare" : "in rollback") + " of connectionId=" + i3);
                                if (!doCommit) continue;
                                doCommit = false;
                                err.compareAndSet(null, t);
                                for (int j = 0; j <= i3; ++j) {
                                    try {
                                        conns[j].rollback();
                                        continue;
                                    }
                                    catch (Throwable e) {
                                        ImportBase.checkThrowable(e, "Import: multi-threaded import failure in rollback of connectionId=" + j);
                                    }
                                }
                            }
                        }
                        if (doCommit) {
                            for (i3 = 0; i3 < numConns; ++i3) {
                                try {
                                    ((GemFireTransaction)conns[i3].getLanguageConnection().getTransactionExecute()).xa_commit(false);
                                    continue;
                                }
                                catch (Throwable t) {
                                    ImportBase.checkThrowable(t, "Import: multi-threaded import failure " + (doCommit ? "in xa_commit" : "in rollback") + " of connectionId=" + i3);
                                }
                            }
                        }
                        if (importer != null) {
                            importer.close();
                            _importers.removePrimitive((long)importCounter);
                        }
                        for (i3 = 0; i3 < numConns; ++i3) {
                            try {
                                conns[i3].close();
                                continue;
                            }
                            catch (Throwable t) {
                                ImportBase.checkThrowable(t, "Import: multi-threaded import failure in close of connectionId=" + i3);
                            }
                        }
                        throw throwable;
                    }
                }
                for (int i5 = 0; i5 < numThreads; ++i5) {
                    ImportBase.addQueueData(dataQueue, MTImport.QUEUE_EOF_TOKEN, err, threads);
                }
                block34: for (Thread th : threads) {
                    try {
                        while (th.isAlive()) {
                            if (err.get() != null) {
                                th.join(100L);
                                th.join(1000L);
                                continue block34;
                            }
                            th.join(1000L);
                        }
                    }
                    catch (Throwable t) {
                        ImportBase.checkThrowable(t, "Import: multi-threaded import failure in join");
                        err.compareAndSet(null, t);
                    }
                }
                boolean doCommit = err.get() == null && numConns == numThreads;
                for (i = 0; i < numConns; ++i) {
                    try {
                        if (doCommit) {
                            ((GemFireTransaction)conns[i].getLanguageConnection().getTransactionExecute()).xa_prepare();
                            continue;
                        }
                        conns[i].rollback();
                        continue;
                    }
                    catch (Throwable t) {
                        ImportBase.checkThrowable(t, "Import: multi-threaded import failure " + (doCommit ? "in prepare" : "in rollback") + " of connectionId=" + i);
                        if (!doCommit) continue;
                        doCommit = false;
                        err.compareAndSet(null, t);
                        for (int j = 0; j <= i; ++j) {
                            try {
                                conns[j].rollback();
                                continue;
                            }
                            catch (Throwable e) {
                                ImportBase.checkThrowable(e, "Import: multi-threaded import failure in rollback of connectionId=" + j);
                            }
                        }
                    }
                }
                if (doCommit) {
                    for (i = 0; i < numConns; ++i) {
                        try {
                            ((GemFireTransaction)conns[i].getLanguageConnection().getTransactionExecute()).xa_commit(false);
                            continue;
                        }
                        catch (Throwable t) {
                            ImportBase.checkThrowable(t, "Import: multi-threaded import failure " + (doCommit ? "in xa_commit" : "in rollback") + " of connectionId=" + i);
                        }
                    }
                }
                if (importer != null) {
                    importer.close();
                    _importers.removePrimitive((long)importCounter);
                }
                for (i = 0; i < numConns; ++i) {
                    try {
                        conns[i].close();
                        continue;
                    }
                    catch (Throwable t) {
                        ImportBase.checkThrowable(t, "Import: multi-threaded import failure in close of connectionId=" + i);
                    }
                }
                Throwable t = err.get();
                if (t != null) {
                    throw t;
                }
            }
            catch (Throwable t) {
                ImportBase.checkThrowable(t, "Import: failure for multi-threaded case");
                throw ImportBase.formatImportError(importer, inputFileName, t);
            }
            finally {
                if (queueId[0] != -1L) {
                    MTImport.removeData(queueId[0]);
                }
            }
        }
    }

    private static boolean addQueueData(ArrayBlockingQueue<MTImport.QueueData> queue, MTImport.QueueData data, AtomicReference<Throwable> err, Thread[] threads) throws CacheClosedException, InterruptedException {
        while (!queue.offer(data, 1L, TimeUnit.SECONDS)) {
            Misc.checkIfCacheClosing(null);
            if (err.get() != null) {
                return false;
            }
            boolean someAlive = false;
            for (Thread thr : threads) {
                if (!thr.isAlive()) continue;
                someAlive = true;
                break;
            }
            if (someAlive) continue;
            return false;
        }
        return true;
    }

    private static void checkThrowable(Throwable t, String traceString) {
        Error err = null;
        if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
            SystemFailure.initiateFailure((Error)err);
            throw err;
        }
        SystemFailure.checkFailure();
        Misc.checkIfCacheClosing(t);
        if (GemFireXDUtils.TraceImport || err != null || t instanceof RuntimeException) {
            SanityManager.DEBUG_PRINT((String)"TraceImport", (String)traceString, (Throwable)t);
        }
    }

    public final int getColumnType(int columnIndex) {
        return this.tableColumnTypes[columnIndex - 1];
    }

    public final String[] getCurrentRow() {
        return this.nextRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performMTImport(Connection connection, String schemaName, String insertColumnList, String columnIndexes, String tableName, String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, boolean lockTable, String importClass, boolean lobsInExtFile, long offset, long endPosition, ColumnInfo columnInfo, String columnTypeNames, String udtClassNames, int importCounter, long mtImportId, String errorFile) throws SQLException {
        try {
            ImportErrorLogger imErrorLogger = null;
            if (errorFile != null) {
                imErrorLogger = new ImportErrorLogger(errorFile + "_" + (importCounter - 1) + ".xml", inputFileName, tableName);
            }
            boolean doRetry = false;
            do {
                if (GemFireXDUtils.TraceImport) {
                    SanityManager.DEBUG_PRINT((String)"TraceImport", (String)("performMTImport for " + inputFileName + ", importCounter=" + importCounter));
                }
                doRetry = ImportBase.performImport(connection, schemaName, insertColumnList, columnIndexes, tableName, inputFileName, columnDelimiter, characterDelimiter, codeset, replace, lockTable, importClass, lobsInExtFile, offset, endPosition, columnInfo, columnTypeNames, udtClassNames, importCounter, mtImportId, imErrorLogger);
                if (errorFile != null) {
                    if (doRetry) {
                        ImportBase importer = (ImportBase)_importers.getPrimitive((long)importCounter);
                        imErrorLogger.isRetry = true;
                        imErrorLogger.currentRowIndex = importer.currentRowIndex;
                        imErrorLogger.currentRows = importer.currentRows;
                    } else {
                        imErrorLogger.isRetry = false;
                        imErrorLogger.currentRowIndex = -1;
                        imErrorLogger.currentRows = null;
                    }
                }
                if (!GemFireXDUtils.TraceImport) continue;
                SanityManager.DEBUG_PRINT((String)"TraceImport", (String)("performMTImport doRetry=" + doRetry + " for " + inputFileName));
            } while (doRetry);
        }
        finally {
            _importers.removePrimitive((long)importCounter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean performImport(Connection connection, String schemaName, String insertColumnList, String columnIndexes, String tableName, String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, boolean lockTable, String importClass, boolean lobsInExtFile, long offset, long endPosition, ColumnInfo columnInfo, String columnTypeNames, String udtClassNames, int importCounter, long mtImportId, ImportErrorLogger imErrorLogger) throws SQLException {
        Statement ips = null;
        ImportBase importer = null;
        try {
            StringBuilder sb = new StringBuilder("new ");
            if (mtImportId != -1L) {
                sb.append(MTImport.class.getName());
                sb.append('(');
                sb.append(mtImportId).append(',');
                sb.append(ImportBase.quoteStringArgument(importClass)).append(',');
            } else {
                sb.append(importClass);
                sb.append('(');
            }
            sb.append(ImportBase.quoteStringArgument(inputFileName));
            sb.append(",");
            sb.append(ImportBase.quoteStringArgument(columnDelimiter));
            sb.append(",");
            sb.append(ImportBase.quoteStringArgument(characterDelimiter));
            sb.append(",");
            sb.append(ImportBase.quoteStringArgument(codeset));
            sb.append(',');
            sb.append(offset);
            sb.append(',');
            sb.append(endPosition);
            if (columnInfo.hasColumnDefinitionInFile()) {
                sb.append(',');
                sb.append(columnInfo.hasColumnDefinitionInFile());
            }
            sb.append(", ");
            sb.append(columnInfo.getExpectedNumberOfColumnsInFile());
            sb.append(", ");
            sb.append(ImportBase.quoteStringArgument(columnInfo.getExpectedVtiColumnTypesAsString()));
            sb.append(", ");
            sb.append(lobsInExtFile);
            sb.append(", ");
            sb.append(importCounter);
            sb.append(", ");
            sb.append(ImportBase.quoteStringArgument(columnTypeNames));
            sb.append(", ");
            sb.append(ImportBase.quoteStringArgument(udtClassNames));
            sb.append(" )");
            String importvti = sb.toString();
            String entityName = IdUtil.mkQualifiedName(schemaName, tableName);
            String insertModeValue = replace > 0 ? "PUT INTO " : "INSERT INTO ";
            String cNamesWithCasts = columnInfo.getColumnNamesWithCasts();
            String insertColumnNames = columnInfo.getInsertColumnNames();
            insertColumnNames = insertColumnNames != null ? "(" + insertColumnNames + ") " : "";
            String insertSql = insertModeValue + entityName + insertColumnNames + " SELECT " + cNamesWithCasts + " from " + importvti + " AS importvti";
            ips = mtImportId != -1L && connection instanceof EmbedConnection ? ((EmbedConnection)connection).prepareMetaDataStatement(insertSql) : connection.prepareStatement(insertSql);
            if (lockTable) {
                Statement statement = connection.createStatement();
                String lockSql = "LOCK TABLE " + entityName + " IN EXCLUSIVE MODE";
                statement.executeUpdate(lockSql);
                statement.close();
                GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                if (observer != null) {
                    observer.afterLockingTableDuringImport();
                }
            }
            try {
                ips.executeUpdate();
                return false;
            }
            catch (Throwable t) {
                block18: {
                    String line;
                    SQLException se;
                    int currLineNumber;
                    block19: {
                        int index;
                        importer = (ImportBase)_importers.getPrimitive((long)importCounter);
                        currLineNumber = importer.getCurrentLineNumber();
                        if (GemFireXDUtils.TraceImport) {
                            char[][] rows = importer.currentRows;
                            Object[] currentRows = new String[rows.length];
                            index = 0;
                            for (char[] row : rows) {
                                currentRows[index++] = row == null ? "" : new String(row);
                            }
                            SanityManager.DEBUG_PRINT((String)"TraceImport", (String)("Caught and ignored an exception in Import from " + inputFileName + " ,imErrorLogger=" + imErrorLogger + ", lineNumber=" + importer.getCurrentLineNumber() + ", currentRows=" + Arrays.toString(currentRows) + ", currentRows.length=" + currentRows.length + ", currentRowIndex=" + importer.currentRowIndex + " ,exception=" + t.getClass().getSimpleName()), (Throwable)t);
                        }
                        if (imErrorLogger == null || !(t instanceof SQLException)) throw ImportBase.formatImportError(importer, inputFileName, t);
                        se = (SQLException)t;
                        if (GemFireXDUtils.TraceImport) {
                            SanityManager.DEBUG_PRINT((String)"TraceImport", (String)("SQLException errorCode=" + se.getErrorCode() + ", SQLstate=" + se.getSQLState()));
                        }
                        line = "null";
                        index = importer.currentRowIndex - 1;
                        if (importer.currentRows == null || importer.currentRows.length <= index || index < 0 || importer.currentRows[index] == null) break block18;
                        line = ImportBase.arrayToString(importer.currentRows[index]);
                        if (!imErrorLogger.isRetry || importer.currentRows != imErrorLogger.currentRows || importer.currentRowIndex != imErrorLogger.currentRowIndex) break block19;
                        boolean bl = false;
                        {
                            catch (Exception e) {
                                SanityManager.DEBUG_PRINT((String)"TraceImport", (String)"Exception in Import Error Logger", (Throwable)e);
                                throw ImportBase.formatImportError(importer, inputFileName, e);
                            }
                        }
                        if (ips == null || ips.isClosed()) return bl;
                        ips.close();
                        return bl;
                    }
                    imErrorLogger.logError(line, currLineNumber, insertSql, se);
                    boolean bl = true;
                    if (ips == null || ips.isClosed()) return bl;
                    ips.close();
                    return bl;
                }
                throw ImportBase.formatImportError(importer, inputFileName, t);
            }
        }
        finally {
            if (ips != null && !ips.isClosed()) {
                ips.close();
            }
        }
    }

    @Override
    ImportReadData getImportReadData() throws Exception {
        return new ImportReadData(this.inputFileName, this.offset, this.endPosition, this.controlFileReader);
    }

    private static int bumpImportCounter() {
        return _importCounter.incrementAndGet();
    }

    private static SQLException formatImportError(ImportBase importer, String inputFile, Throwable t) {
        int lineNumber = -1;
        if (t instanceof SQLException && "XIE0R.S".substring(0, 5).equals(((SQLException)t).getSQLState())) {
            return (SQLException)t;
        }
        if (t instanceof StandardException && "XIE0R.S".equals(((StandardException)t).getMessageId())) {
            return PublicAPI.wrapStandardException((StandardException)t);
        }
        if (importer != null) {
            lineNumber = importer.getCurrentLineNumber();
        }
        StandardException se = StandardException.newException("XIE0R.S", (Object)lineNumber, (Object)inputFile, (Object)t.getMessage());
        se.initCause(t);
        return PublicAPI.wrapStandardException(se);
    }

    private static String quoteStringArgument(String string) {
        if (string == null) {
            return "NULL";
        }
        return StringUtil.quoteStringLiteral(string);
    }

    public static String arrayToString(char[] a) {
        if (a == null) {
            return "";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.toString();
            }
            ++i;
        }
    }
}

