/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc.authentication;

import com.pivotal.gemfirexd.auth.callback.CredentialInitializer;
import com.pivotal.gemfirexd.callbacks.AsyncEventHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.SecurityUtils;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.JNDIAuthenticationSchemeBase;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.JNDIAuthenticationService;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public final class LDAPAuthenticationSchemeImpl
extends JNDIAuthenticationSchemeBase
implements CredentialInitializer {
    private static final String dfltLDAPURL = "ldap://";
    private String searchBaseDN;
    private String leftSearchFilter;
    private String rightSearchFilter;
    private boolean useUserPropertyAsDN;
    private String searchAuthDN;
    private String searchAuthPW;
    private final FileOutputStream traceOut = (FileOutputStream)this.initDirContextEnv.get("com.sun.naming.ldap.trace.ber");
    private static final String[] attrDN = new String[]{"dn", "distinguishedName"};
    private static final String memberOfAttr = "memberOf";
    private String searchGroupBase;
    private String searchGroupFilter;
    private String[] searchGroupAttributes;
    private String[] searchGroupUserAttributes;
    private static final String[] attrGroupDefault = new String[]{"member", "uniqueMember"};
    private static final String[] attrGroupUserDefault = new String[]{"uid"};
    private static final Pattern groupPattern = Pattern.compile("%GROUP%");
    private static final Pattern userAttrPattern = Pattern.compile("\\((\\w+)=$");
    private String auth_ldap_search_pw_attr = "AUTH_LDAP_SEARCH_PW";

    public LDAPAuthenticationSchemeImpl(JNDIAuthenticationService as, Properties dbProperties) {
        super(as, dbProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String authenticateUser(String userName, String userPassword, String databaseName, Properties info) throws SQLException {
        NamingException e;
        block41: {
            String encryptedPwd = this.getEncrypted(userPassword);
            if (encryptedPwd != null) {
                try {
                    userPassword = this.decryptPassword(userName, encryptedPwd, null, -1);
                }
                catch (Exception e2) {
                    throw LDAPAuthenticationSchemeImpl.getLoginSQLException(e2);
                }
            }
            if (userName == null || userName.length() == 0 || userPassword == null || userPassword.length() == 0) {
                return userName == null || userName.length() == 0 ? "Empty user name" : "Empty password";
            }
            Context ctx = null;
            try {
                Properties env = (Properties)this.initDirContextEnv.clone();
                String userDN = null;
                if (this.useUserPropertyAsDN && (userDN = this.authenticationService.getProperty("gemfirexd.user.")) == null) {
                    userDN = this.authenticationService.getProperty("sqlfire.user.");
                }
                if (userDN == (String)null) {
                    try {
                        userDN = this.getDNFromUID(userName);
                    }
                    catch (Exception ex) {
                        throw LDAPAuthenticationSchemeImpl.getLoginSQLException(ex);
                    }
                }
                if (GemFireXDUtils.TraceAuthentication) {
                    SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("User DN = [" + userDN + ']'));
                    GemFireXDUtils.dumpProperties(env, "LDAP connection authentication for uid=" + userName + " with ", "TraceAuthentication", GemFireXDUtils.TraceAuthentication, null);
                }
                env.put("java.naming.security.principal", userDN);
                env.put("java.naming.security.credentials", userPassword);
                ctx = this.privInitialDirContext(env);
                String ex = null;
                return ex;
            }
            catch (AuthenticationException jndiae) {
                String string = jndiae.toString();
                return string;
            }
            catch (NameNotFoundException jndinnfe) {
                String string = jndinnfe.toString();
                return string;
            }
            catch (NamingException jndine) {
                e = jndine;
                break block41;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException nme) {
                        NamingException e3 = nme;
                        if (GemFireXDUtils.TraceAuthentication) {
                            SanityManager.DEBUG_PRINT((String)"warning:TraceAuthentication", (String)"Exception occurred while closing the context acquired.", (Throwable)e3);
                        }
                        throw LDAPAuthenticationSchemeImpl.getLoginSQLException(e3);
                    }
                }
                if (this.traceOut != null) {
                    try {
                        this.traceOut.flush();
                    }
                    catch (IOException nme) {}
                }
            }
        }
        throw LDAPAuthenticationSchemeImpl.getLoginSQLException(e);
    }

    private String decryptPassword(String user, String secret, String transformation, int keySize) throws Exception {
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("Decrypting password for user " + user));
        }
        return AsyncEventHelper.decryptPassword(user, secret, null, -1);
    }

    private DirContext privInitialDirContext(final Properties env) throws NamingException {
        try {
            return (InitialDirContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException, NamingException {
                    return new InitialDirContext(env);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof NamingException) {
                throw (NamingException)e;
            }
            throw (SecurityException)e;
        }
    }

    @Override
    protected void setJNDIProviderProperties() {
        String ldapSearchBase;
        if (this.initDirContextEnv.getProperty("java.naming.factory.initial") == (String)null) {
            this.initDirContextEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        if (this.initDirContextEnv.getProperty("java.naming.provider.url") == (String)null) {
            String ldapServer = this.authenticationService.getProperty("gemfirexd.auth-ldap-server");
            if (ldapServer == (String)null) {
                Monitor.logTextMessage("A011", "gemfirexd.auth-ldap-server");
                this.providerURL = "ldap:///";
            } else {
                this.providerURL = ldapServer.startsWith(dfltLDAPURL) || ldapServer.startsWith("ldaps://") ? ldapServer : (ldapServer.startsWith("//") ? "ldap:" + ldapServer : dfltLDAPURL + ldapServer);
            }
            this.initDirContextEnv.put("java.naming.provider.url", this.providerURL);
        }
        if (this.initDirContextEnv.getProperty("java.naming.security.authentication") == (String)null) {
            this.initDirContextEnv.put("java.naming.security.authentication", "simple");
        }
        this.searchBaseDN = (ldapSearchBase = this.authenticationService.getProperty("gemfirexd.auth-ldap-search-base")) != (String)null ? ldapSearchBase : "";
        this.searchAuthDN = this.authenticationService.getProperty("gemfirexd.auth-ldap-search-dn");
        this.searchAuthPW = this.authenticationService.getProperty("gemfirexd.auth-ldap-search-pw");
        this.searchGroupUserAttributes = attrGroupUserDefault;
        String searchFilterProp = this.authenticationService.getProperty("gemfirexd.auth-ldap-search-filter");
        String defaultLeftSearchFilter = "(&(|(objectclass=user)(objectclass=person)(objectclass=inetOrgPerson)(objectclass=organizationalPerson))(uid=";
        if (searchFilterProp == null) {
            this.leftSearchFilter = defaultLeftSearchFilter;
            this.rightSearchFilter = "))";
        } else if (StringUtil.SQLEqualsIgnoreCase(searchFilterProp, "gemfirexd.user")) {
            this.leftSearchFilter = defaultLeftSearchFilter;
            this.rightSearchFilter = "))";
            this.useUserPropertyAsDN = true;
        } else if (searchFilterProp.indexOf("%USERNAME%") != -1) {
            String userAttr;
            this.leftSearchFilter = searchFilterProp.substring(0, searchFilterProp.indexOf("%USERNAME%"));
            this.rightSearchFilter = searchFilterProp.substring(searchFilterProp.indexOf("%USERNAME%") + "%USERNAME%".length());
            Matcher userAttrMatch = userAttrPattern.matcher(this.leftSearchFilter);
            if (userAttrMatch.find() && (userAttr = userAttrMatch.group(1)) != null && !this.attributeExists(userAttr, this.searchGroupUserAttributes)) {
                int nAttrs = this.searchGroupUserAttributes.length;
                String[] userAttrs = Arrays.copyOf(this.searchGroupUserAttributes, nAttrs + 1);
                userAttrs[nAttrs] = userAttr;
                this.searchGroupUserAttributes = userAttrs;
            }
        } else {
            this.leftSearchFilter = "(&(" + searchFilterProp + ")(objectClass=inetOrgPerson)(uid=";
            this.rightSearchFilter = "))";
        }
        String ldapGroupSearchBase = this.authenticationService.getProperty("gemfirexd.group-ldap-search-base");
        this.searchGroupBase = ldapGroupSearchBase != null ? ldapGroupSearchBase : this.searchBaseDN;
        String ldapGroupSearchFilter = this.authenticationService.getProperty("gemfirexd.group-ldap-search-filter");
        this.searchGroupFilter = ldapGroupSearchFilter != null ? ldapGroupSearchFilter : "(&(|(objectClass=group)(objectClass=groupOfNames)(objectClass=groupOfMembers)(objectClass=groupOfUniqueNames))(|(cn=%GROUP%)(name=%GROUP%)))";
        String ldapGroupSearchAttrs = this.authenticationService.getProperty("gemfirexd.group-ldap-member-attributes");
        if (ldapGroupSearchAttrs != null) {
            this.searchGroupAttributes = ldapGroupSearchAttrs.split(",");
            for (int i = 0; i < this.searchGroupAttributes.length; ++i) {
                this.searchGroupAttributes[i] = this.searchGroupAttributes[i].trim();
            }
        } else {
            this.searchGroupAttributes = attrGroupDefault;
        }
        if (SanityManager.DEBUG_ON((String)"TraceAuthentication")) {
            PrintWriter iDbgStream = SanityManager.GET_DEBUG_STREAM();
            iDbgStream.println("\n\n+ LDAP Authentication Configuration:\n   - provider URL [" + this.providerURL + "]\n   - search base [" + this.searchBaseDN + "]\n   - search filter to be [" + this.leftSearchFilter + "<uid>" + this.rightSearchFilter + "]\n   - use local DN [" + (this.useUserPropertyAsDN ? "true" : "false") + "]\n   - group search base [" + this.searchGroupBase + "]\n   - group search filter [" + this.searchGroupFilter + "]\n   - group search attributes " + Arrays.toString(this.searchGroupAttributes) + '\n' + "   - group user attributes " + Arrays.toString(this.searchGroupUserAttributes) + '\n');
        }
        if (SanityManager.DEBUG_ON((String)"TraceAuthentication")) {
            FileOutputStream fos = null;
            try {
                fos = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws SecurityException, IOException {
                        return new FileOutputStream("GemFireXDLDAP.out");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            if (fos != null) {
                this.initDirContextEnv.put("com.sun.naming.ldap.trace.ber", fos);
            }
        }
    }

    private NamingEnumeration getUserInformation(String uid, DirContext ctx, String[] attributes) throws Exception {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(attributes);
        String searchFilter = this.leftSearchFilter + uid + this.rightSearchFilter;
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("Searching for DN for uid=" + uid + ", baseDN=" + this.searchBaseDN + ", searchFilter=" + searchFilter));
        }
        NamingEnumeration<SearchResult> results = ctx.search(this.searchBaseDN, searchFilter, ctls);
        return results;
    }

    private String getDNFromUID(String uid) throws Exception {
        boolean hasMoreResults;
        DirContext ctx = this.getDirContext(uid);
        NamingEnumeration results = this.getUserInformation(uid, ctx, attrDN);
        if (results == null || !results.hasMore()) {
            throw new NameNotFoundException();
        }
        SearchResult result = (SearchResult)results.next();
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("First User DN obtained=" + result.getName()));
        }
        try {
            hasMoreResults = results.hasMore();
        }
        catch (NamingException ne) {
            hasMoreResults = false;
        }
        if (hasMoreResults) {
            if (SanityManager.DEBUG_ON((String)"TraceAuthentication")) {
                String searchFilter = this.leftSearchFilter + uid + this.rightSearchFilter;
                PrintWriter iDbgStream = SanityManager.GET_DEBUG_STREAM();
                iDbgStream.println(" - LDAP Authentication request failure: search filter [" + searchFilter + "], retrieve more than one occurence in LDAP server [" + this.providerURL + "]");
            }
            throw new NameNotFoundException();
        }
        return this.getDNFromSearchResult(ctx, result);
    }

    private String getDNFromSearchResult(DirContext ctx, SearchResult result) throws Exception {
        NameParser parser = ctx.getNameParser(this.searchBaseDN);
        Name userDN = parser.parse(this.searchBaseDN);
        if (userDN == (Name)null) {
            throw new NameNotFoundException();
        }
        userDN.addAll(parser.parse(result.getName()));
        return userDN.toString();
    }

    private DirContext getDirContext(String uid) throws Exception {
        Properties env = null;
        if (this.searchAuthDN != (String)null) {
            env = (Properties)this.initDirContextEnv.clone();
            env.put("java.naming.security.principal", this.searchAuthDN);
            env.put("java.naming.security.credentials", this.getSearchAuthPwd());
        } else {
            env = this.initDirContextEnv;
        }
        if (GemFireXDUtils.TraceAuthentication) {
            GemFireXDUtils.dumpProperties(env, "Initializing DN for uid=" + uid + " with ", "TraceAuthentication", GemFireXDUtils.TraceAuthentication, null);
        }
        return this.privInitialDirContext(env);
    }

    private String getEncrypted(String pwd) {
        if (pwd != null && pwd.startsWith("v13b607k2j6")) {
            return pwd.substring("v13b607k2j6".length());
        }
        return null;
    }

    private String getSearchAuthPwd() throws Exception {
        String entrypedPwd = this.getEncrypted(this.searchAuthPW);
        if (entrypedPwd != null) {
            return this.decryptPassword(this.auth_ldap_search_pw_attr, entrypedPwd, null, -1);
        }
        return this.searchAuthPW;
    }

    public Set<String> getLDAPGroupMembers(String ldapGroup) throws Exception {
        ArrayList<String> groupMembers = new ArrayList<String>();
        this.recurseGroups(ldapGroup, groupMembers, null);
        return new ObjectOpenHashSet(groupMembers);
    }

    public Set<String> getLdapGroupsOfUser(String uid) throws Exception {
        DirContext ctx = this.getDirContext(uid);
        String[] attributesNeeded = Arrays.copyOf(attrDN, attrDN.length + 1);
        attributesNeeded[attributesNeeded.length - 1] = memberOfAttr;
        NamingEnumeration results = this.getUserInformation(uid, ctx, attributesNeeded);
        if (results == null || !results.hasMore()) {
            throw new NameNotFoundException();
        }
        SearchResult result = (SearchResult)results.next();
        ArrayList<String> ldapGroups = new ArrayList<String>();
        Attribute memberOfAttr = result.getAttributes().get(memberOfAttr);
        if (memberOfAttr != null) {
            NamingEnumeration<?> ne = memberOfAttr.getAll();
            block0: while (ne.hasMore()) {
                String group = (String)ne.next();
                LdapName groupDn = new LdapName(group);
                for (Rdn rdn : groupDn.getRdns()) {
                    if (!rdn.getType().equalsIgnoreCase("cn")) continue;
                    String cn = rdn.getValue().toString();
                    if ((cn = cn.trim()).length() <= 0) continue block0;
                    ldapGroups.add(StringUtil.SQLToUpperCase(cn));
                    continue block0;
                }
            }
        } else {
            String userDN = this.getDNFromSearchResult(ctx, result);
            this.recurseGroups("*", ldapGroups, userDN);
        }
        return new ObjectOpenHashSet(ldapGroups);
    }

    private void recurseGroups(String ldapGroup, List<String> storage, String userDN) throws Exception {
        Properties env = null;
        if (this.searchAuthDN != null) {
            env = (Properties)this.initDirContextEnv.clone();
            env.put("java.naming.security.principal", this.searchAuthDN);
            env.put("java.naming.security.credentials", this.getSearchAuthPwd());
        } else {
            env = this.initDirContextEnv;
        }
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("Initializing search for LDAP group =" + ldapGroup != null ? ldapGroup : userDN));
        }
        DirContext ctx = this.privInitialDirContext(env);
        String searchFilter = null;
        searchFilter = ldapGroup != null ? groupPattern.matcher(this.searchGroupFilter).replaceAll(ldapGroup) : groupPattern.matcher(this.searchGroupFilter).replaceAll("*");
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("Searching for LDAP group=" + ldapGroup + ", groupBase=" + this.searchGroupBase + ", searchFilter=" + searchFilter));
        }
        this.resolveDNForGroup(ctx, this.searchGroupBase, searchFilter, this.searchGroupAttributes, true, ldapGroup, storage, userDN);
        ctx.close();
    }

    /*
     * Exception decompiling
     */
    private void resolveDNForGroup(DirContext ctx, String baseDN, String searchFilter, String[] searchAttributes, boolean topLevel, String group, List<String> storage, String userDN) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void collectGroupMembers(DirContext ctx, String member, String group, List<String> groupMembers, boolean topLevel, String searchFilter, String[] searchAttributes) throws Exception {
        LdapName memberDN;
        if (member.indexOf(61) >= 0 && !(memberDN = new LdapName(member)).isEmpty()) {
            Rdn id = memberDN.getRdn(memberDN.size() - 1);
            if (this.attributeExists(id.getType(), this.searchGroupUserAttributes)) {
                member = id.getValue().toString();
            } else {
                if (topLevel) {
                    searchFilter = "(objectClass=*)";
                    int nAttrs = searchAttributes.length;
                    int nSearchAttrs = this.searchGroupUserAttributes.length;
                    searchAttributes = Arrays.copyOf(searchAttributes, nAttrs + nSearchAttrs);
                    System.arraycopy(this.searchGroupUserAttributes, 0, searchAttributes, nAttrs, nSearchAttrs);
                }
                if (GemFireXDUtils.TraceAuthentication) {
                    SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("Searching DN " + member + " in LDAP group = " + group + " filter = " + searchFilter + " attributes = " + Arrays.toString(searchAttributes)));
                }
                this.resolveDNForGroup(ctx, member, searchFilter, searchAttributes, false, group, groupMembers, null);
                return;
            }
        }
        if ((member = member.trim()).length() > 0) {
            member = StringUtil.SQLToUpperCase(member);
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("Found member " + member + " in LDAP group = " + group));
            }
            groupMembers.add(member);
        }
    }

    private void collectGroups(DirContext ctx, String member, String userDN, List<String> groupsOfUser, String searchFilter, String[] searchAttributes, SearchResult result) throws Exception {
        LdapName memberDN;
        int currentSize = groupsOfUser.size();
        if (member.indexOf(61) >= 0 && !(memberDN = new LdapName(member)).isEmpty()) {
            Rdn id = memberDN.getRdn(memberDN.size() - 1);
            if (this.attributeExists(id.getType(), this.searchGroupUserAttributes)) {
                member = id.getValue().toString();
                String dnOfMember = this.getDNFromUID(member);
                if (dnOfMember.equals(userDN)) {
                    LdapName groupDn = new LdapName(this.getDNFromSearchResult(ctx, result));
                    groupsOfUser.add(StringUtil.SQLToUpperCase(groupDn.getRdn(groupDn.size() - 1).getValue().toString()));
                }
            } else if (userDN.equals(member)) {
                LdapName groupDn = new LdapName(this.getDNFromSearchResult(ctx, result));
                groupsOfUser.add(StringUtil.SQLToUpperCase(groupDn.getRdn(groupDn.size() - 1).getValue().toString()));
            } else {
                if (GemFireXDUtils.TraceAuthentication) {
                    SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("Searching DN " + member + " in LDAP userDN = " + userDN + " filter = " + searchFilter + " attributes = " + Arrays.toString(searchAttributes)));
                }
                LdapName dnOfMember = new LdapName(member);
                String cn = dnOfMember.getRdn(dnOfMember.size() - 1).getValue().toString();
                dnOfMember.remove(dnOfMember.size() - 1);
                String baseDn = dnOfMember.toString();
                searchFilter = groupPattern.matcher(this.searchGroupFilter).replaceAll(cn);
                this.resolveDNForGroup(ctx, baseDn, searchFilter, searchAttributes, true, null, groupsOfUser, userDN);
                if (currentSize < groupsOfUser.size()) {
                    LdapName groupDn = new LdapName(this.getDNFromSearchResult(ctx, result));
                    groupsOfUser.add(StringUtil.SQLToUpperCase(groupDn.getRdn(groupDn.size() - 1).getValue().toString()));
                }
                return;
            }
        }
    }

    private boolean attributeExists(String attr, String[] attrs) {
        for (String a : attrs) {
            if (!attr.equalsIgnoreCase(a)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "LDAP";
    }

    @Override
    public Properties getCredentials(Properties securityProps) throws SQLException {
        return SecurityUtils.getCredentials(securityProps);
    }
}

