/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedBlob;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

class UpdatableBlobStream
extends InputStream {
    private boolean materialized;
    private InputStream stream;
    private long pos;
    private final EmbedBlob blob;
    private final long maxPos;

    UpdatableBlobStream(EmbedBlob blob, InputStream is) throws IOException {
        this(blob, is, 0L, Long.MAX_VALUE);
    }

    UpdatableBlobStream(EmbedBlob blob, InputStream is, long pos, long len) throws IOException {
        this.blob = blob;
        this.stream = is;
        this.maxPos = pos + len;
        if (pos > 0L) {
            this.skip(pos);
        }
    }

    private void updateIfRequired() throws IOException {
        if (this.materialized) {
            return;
        }
        if (this.blob.isMaterialized()) {
            long skipped;
            this.materialized = true;
            try {
                this.stream = this.blob.getBinaryStream();
            }
            catch (SQLException ex) {
                throw Util.newIOException(ex);
            }
            for (long leftToSkip = this.pos; leftToSkip > 0L; leftToSkip -= skipped) {
                skipped = this.stream.skip(leftToSkip);
                if (skipped != 0L) continue;
                if (this.stream.read() < 0) {
                    throw new IOException(MessageService.getCompleteMessage("XJ085.S", new Object[0]));
                }
                skipped = 1L;
            }
        }
    }

    @Override
    public int read() throws IOException {
        this.updateIfRequired();
        if (this.pos >= this.maxPos) {
            return -1;
        }
        int ret = this.stream.read();
        if (ret >= 0) {
            ++this.pos;
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.updateIfRequired();
        int actualLength = (int)Math.min((long)len, this.maxPos - this.pos);
        int retValue = this.stream.read(b, off, actualLength);
        if (retValue > 0) {
            this.pos += (long)retValue;
        }
        return retValue;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.updateIfRequired();
        int actualLength = (int)Math.min((long)b.length, this.maxPos - this.pos);
        int retValue = this.stream.read(b, 0, actualLength);
        if (retValue > 0) {
            this.pos += (long)retValue;
        }
        return retValue;
    }

    @Override
    public long skip(long n) throws IOException {
        this.updateIfRequired();
        long retValue = this.stream.skip(n);
        if (retValue > 0L) {
            this.pos += retValue;
        }
        return retValue;
    }
}

