/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Ref;
import java.sql.SQLException;
import java.util.Map;

public class EmbedResultSet20
extends EmbedResultSet {
    public EmbedResultSet20(EmbedConnection conn, ResultSet resultsToWrap, boolean forMetaData, EmbedStatement stmt, boolean isAtomic) throws SQLException {
        super(conn, resultsToWrap, forMetaData, stmt, isAtomic);
    }

    @Override
    public final BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal ret = this.getBigDecimal(columnIndex);
        if (ret != null) {
            return ret.setScale(scale, 5);
        }
        return null;
    }

    @Override
    public final BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkIfClosed("getBigDecimal");
        if (this.currentRow instanceof AbstractCompactExecRow) {
            this.wasNull = false;
            this.isValid(columnIndex);
            try {
                return ((AbstractCompactExecRow)this.currentRow).getAsBigDecimal(columnIndex, this);
            }
            catch (StandardException se) {
                throw EmbedResultSet20.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            return SQLDecimal.getBigDecimal(dvd);
        }
        catch (StandardException t) {
            throw EmbedResultSet20.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.checkIfClosed("getBigDecimal");
        return this.getBigDecimal(this.findColumnName(columnName), scale);
    }

    @Override
    public final InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw Util.notImplemented("getUnicodeStream");
    }

    @Override
    public final InputStream getUnicodeStream(String columnName) throws SQLException {
        throw Util.notImplemented("getUnicodeStream");
    }

    @Override
    public final BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.checkIfClosed("getBigDecimal");
        return this.getBigDecimal(this.findColumnName(columnName));
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateBigDecimal").setBigDecimal(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet20.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checksBeforeUpdateOrDelete("updateObject", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (x instanceof BigDecimal) {
            this.updateBigDecimal(columnIndex, (BigDecimal)x);
            return;
        }
        super.updateObject(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.checkIfClosed("updateBigDecimal");
        this.updateBigDecimal(this.findColumnName(columnName), x);
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        this.checkIfClosed("getObject");
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.ResultSet.getObject");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(columnIndex);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw Util.notImplemented();
    }

    public Object getObject(String colName, Map map) throws SQLException {
        this.checkIfClosed("getObject");
        return this.getObject(this.findColumn(colName), map);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw Util.notImplemented();
    }
}

