/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProcedureProcessorResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.UpdatableResultSet;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.ResultWasNull;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineResultSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.NewByteArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.StreamStorable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorActivation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecCursorTableReference;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialBlob;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialClob;
import com.pivotal.gemfirexd.internal.iapi.types.RawToBinaryFormatStream;
import com.pivotal.gemfirexd.internal.iapi.types.ReaderToUTF8Stream;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.UserDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.VariableSizeDataValue;
import com.pivotal.gemfirexd.internal.impl.jdbc.BinaryToRawStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.ConnectionChild;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.ReaderToAscii;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.impl.jdbc.UTF8Reader;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScrollInsensitiveResultSet;
import com.pivotal.gemfirexd.procedure.OutgoingResultSet;
import io.snappydata.ResultSetWithNull;
import io.snappydata.thrift.common.BufferedBlob;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;

public abstract class EmbedResultSet
extends ConnectionChild
implements EngineResultSet,
ResultWasNull,
ResultSetWithNull,
Comparable {
    protected static final int FIRST = 1;
    protected static final int NEXT = 2;
    protected static final int LAST = 3;
    protected static final int PREVIOUS = 4;
    protected static final int BEFOREFIRST = 5;
    protected static final int AFTERLAST = 6;
    protected static final int ABSOLUTE = 7;
    protected static final int RELATIVE = 8;
    public ExecRow currentRow;
    boolean isClosed;
    private boolean isOnInsertRow;
    private Object currentStream;
    public final ResultSet theResults;
    private boolean isLocallyProcessing = false;
    private final boolean forMetaData;
    private SQLWarning topWarning;
    Activation singleUseActivation;
    final int order;
    protected boolean wasNull;
    protected ResultDescription resultDescription;
    private int columnCount = -1;
    private boolean requireContext;
    private long id;
    private int maxRows;
    private final int maxFieldSize;
    private int NumberofFetchedRows;
    private final EmbedStatement stmt;
    private EmbedStatement owningStmt;
    private Statement applicationStmt;
    private final long timeoutMillis;
    private final boolean isAtomic;
    private final int concurrencyOfThisResultSet;
    private final ExecRow updateRow;
    private boolean[] columnGotUpdated;
    private boolean currentRowHasBeenUpdated;
    private int fetchDirection;
    private int fetchSize;
    private boolean[] streamUsedFlags;
    private int resultsetIndex = -1;

    public EmbedResultSet(EmbedConnection conn, ResultSet resultsToWrap, boolean forMetaData, EmbedStatement stmt, boolean isAtomic) throws SQLException {
        super(conn);
        SQLWarning w;
        SanityManager.ASSERT((resultsToWrap != null ? 1 : 0) != 0);
        this.theResults = resultsToWrap;
        this.forMetaData = forMetaData;
        if (this.forMetaData) {
            this.singleUseActivation = resultsToWrap.getActivation();
        }
        this.stmt = this.owningStmt = stmt;
        this.applicationStmt = this.owningStmt;
        this.timeoutMillis = stmt == null ? 0L : stmt.timeoutMillis;
        this.isAtomic = isAtomic;
        if (stmt == null) {
            this.concurrencyOfThisResultSet = 1007;
        } else if (stmt.resultSetConcurrency == 1007) {
            this.concurrencyOfThisResultSet = 1007;
        } else if (!this.isForUpdate()) {
            this.concurrencyOfThisResultSet = 1007;
            w = StandardException.newWarning("01J06");
            this.addWarning(w);
        } else {
            this.concurrencyOfThisResultSet = 1008;
            if (conn.getTransactionIsolation() == 0) {
                w = StandardException.newWarning("0A000.S.18");
                this.addWarning(w);
            }
        }
        this.resultDescription = this.theResults.getActivation().getResultDescription();
        if (this.concurrencyOfThisResultSet == 1008) {
            int columnCount = this.resultDescription.getColumnCount();
            ExecutionFactory factory = conn.getLanguageConnection().getLanguageConnectionFactory().getExecutionFactory();
            try {
                this.columnGotUpdated = new boolean[columnCount];
                this.updateRow = factory.getValueRow(columnCount);
                for (int i = 1; i <= columnCount; ++i) {
                    this.updateRow.setColumn(i, this.resultDescription.getColumnDescriptor(i).getType().getNull());
                }
                this.initializeUpdateRowModifiers();
            }
            catch (StandardException t) {
                throw EmbedResultSet.noStateChangeException(t, null);
            }
        } else {
            this.updateRow = null;
        }
        if (stmt != null) {
            if (stmt.resultSetType == 1003) {
                this.maxRows = stmt.maxRows;
            }
            this.maxFieldSize = stmt.maxFieldSize;
        } else {
            this.maxFieldSize = 0;
        }
        this.order = conn.getResultSetOrderId();
        LanguageConnectionContext lcc = conn.getLanguageConnection();
        this.requireContext = !this.theResults.isDistributedResultSet() || lcc.streamingEnabled() && lcc.getStatementDepth() > 0 || lcc.isolationLevelNeedsDistribution();
        GemFireTransaction tran = (GemFireTransaction)lcc.getTransactionExecute();
        if (tran != null && !tran.skipLocks()) {
            this.theResults.addLockReference(tran);
        }
    }

    private void checkNotOnInsertRow() throws SQLException {
        if (this.isOnInsertRow) {
            throw this.newSQLException("24000");
        }
    }

    protected final void checkOnRow() throws SQLException {
        if (this.currentRow == null) {
            throw this.newSQLException("24000");
        }
    }

    private void initializeUpdateRowModifiers() {
        this.currentRowHasBeenUpdated = false;
        Arrays.fill(this.columnGotUpdated, false);
    }

    final int getColumnType(int columnIndex) throws SQLException {
        if (!this.isOnInsertRow) {
            this.checkOnRow();
        }
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw this.newSQLException("S0022", new Integer(columnIndex));
        }
        return this.resultDescription.getColumnDescriptor(columnIndex).getType().getJDBCTypeId();
    }

    @Override
    public final boolean next() throws SQLException {
        if (this.maxRows != 0) {
            ++this.NumberofFetchedRows;
            if (this.NumberofFetchedRows > this.maxRows) {
                this.closeCurrentStream();
                return false;
            }
        }
        return this.movePosition(2, 0, "next", false);
    }

    public final boolean lightWeightNext() throws SQLException {
        if (this.maxRows != 0) {
            ++this.NumberofFetchedRows;
            if (this.NumberofFetchedRows > this.maxRows) {
                this.closeCurrentStream();
                return false;
            }
        }
        return this.movePosition(2, 0, "next", true);
    }

    public final boolean lightWeightPrevious() throws SQLException {
        this.checkScrollCursor("previous()");
        return this.movePosition(4, 0, "previous", true);
    }

    public final EmbedStatement getEmbedStatement() {
        return this.stmt;
    }

    public final EmbedStatement getOwningStatement() {
        return this.owningStmt;
    }

    public final void setID(long id) {
        this.id = id;
    }

    public final long getID() {
        return this.id;
    }

    protected final boolean movePosition(int position, String positionText) throws SQLException {
        return this.movePosition(position, 0, positionText, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean movePosition(int position, int row, String positionText, boolean isLightWeightNext) throws SQLException {
        boolean onRow = false;
        StatementContext statementContext = null;
        LanguageConnectionContext lcc = null;
        if (this.columnCount < 0) {
            this.columnCount = this.resultDescription.getColumnCount();
        }
        this.closeCurrentStream();
        if (!isLightWeightNext) {
            this.checkExecIfClosed(positionText);
        }
        if (this.isOnInsertRow) {
            this.moveToCurrentRow();
        }
        boolean requireCtx = !isLightWeightNext && this.requireContext;
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl;
            block36: {
                if (requireCtx) {
                    this.setupContextStack(false);
                }
                try {
                    ExecRow newRow;
                    lcc = this.getEmbedConnection().getLanguageConnection();
                    try {
                        if (requireCtx) {
                            statementContext = lcc.pushStatementContext(this.isAtomic, this.concurrencyOfThisResultSet == 1007, this.getSQLText(), this.getParameterValueSet(), false, this.timeoutMillis, false);
                        }
                        if (GemFireXDUtils.isOffHeapEnabled() && this.theResults instanceof NoPutResultSet) {
                            ((NoPutResultSet)this.theResults).releasePreviousByteSource();
                        }
                        switch (position) {
                            case 5: {
                                newRow = this.theResults.setBeforeFirstRow();
                                break;
                            }
                            case 1: {
                                newRow = this.theResults.getFirstRow();
                                break;
                            }
                            case 2: {
                                newRow = this.theResults.getNextRow();
                                break;
                            }
                            case 3: {
                                newRow = this.theResults.getLastRow();
                                break;
                            }
                            case 6: {
                                newRow = this.theResults.setAfterLastRow();
                                break;
                            }
                            case 4: {
                                newRow = this.theResults.getPreviousRow();
                                break;
                            }
                            case 7: {
                                newRow = this.theResults.getAbsoluteRow(row);
                                break;
                            }
                            case 8: {
                                newRow = this.theResults.getRelativeRow(row);
                                break;
                            }
                            default: {
                                newRow = null;
                                SanityManager.THROWASSERT((String)("Unexpected value for position - " + position));
                            }
                        }
                        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                        if (observer != null) {
                            observer.onEmbedResultSetMovePosition(this, newRow, this.theResults);
                        }
                        if (requireCtx) {
                            lcc.popStatementContext(statementContext, null);
                        }
                    }
                    catch (Throwable t) {
                        throw this.closeOnTransactionError(t);
                    }
                    Activation activation = this.theResults.getActivation();
                    SQLWarning w = activation.getResultsetWarnings();
                    if (w != null) {
                        activation.clearResultsetWarnings();
                        if (this.topWarning == null) {
                            this.topWarning = w;
                        } else {
                            this.topWarning.setNextWarning(w);
                        }
                    }
                    boolean bl2 = onRow = (this.currentRow = newRow) != null;
                    if (!onRow && position == 2) {
                        GemFireTransaction tran = (GemFireTransaction)this.localConn.getLanguageConnectionContext().getTransactionExecute();
                        if (tran != null) {
                            tran.release();
                        }
                        if (!(this.forMetaData && lcc.getActivationCount() > 1 || this.owningStmt == null || this.owningStmt.getResultSetType() != 1003 || isLightWeightNext)) {
                            this.owningStmt.resultSetClosing(this);
                        }
                        if (this.owningStmt == null || this.owningStmt.getResultSetType() == 1003) {
                            EmbedResultSet.releaseNonTXLocks(isLightWeightNext, lcc, this.theResults);
                        }
                    }
                    if (this.streamUsedFlags != null) {
                        Arrays.fill(this.streamUsedFlags, false);
                    }
                    if (this.columnGotUpdated != null && this.currentRowHasBeenUpdated) {
                        this.initializeUpdateRowModifiers();
                    }
                    bl = onRow;
                    if (!requireCtx) break block36;
                }
                catch (Throwable throwable) {
                    if (requireCtx) {
                        this.restoreContextStack();
                    }
                    throw throwable;
                }
                this.restoreContextStack();
            }
            return bl;
        }
    }

    @Override
    public final void close() throws SQLException {
        this.basicClose(false);
    }

    public final void lightWeightClose() throws SQLException {
        this.basicClose(true);
    }

    public final void pushStatementContext(LanguageConnectionContext lcc, boolean isLightWeight) {
        lcc.pushStatementContext(this.isAtomic, this.concurrencyOfThisResultSet == 1007, this.getSQLText(), this.getParameterValueSet(), false, this.timeoutMillis, isLightWeight);
    }

    public final void popStatementContext() throws SQLException {
        LanguageConnectionContext lcc = this.getEmbedConnection().getLanguageConnection();
        lcc.popStatementContext(lcc.getStatementContext(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicClose(boolean lightWeightClose) throws SQLException {
        if (this.isClosed) {
            return;
        }
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.beforeEmbedResultSetClose(this, this.getSQLText());
        }
        boolean enableStats = this.stmt != null && this.stmt.stats != null;
        this.closeCurrentStream();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            block24: {
                LanguageConnectionContext lcc;
                try {
                    if (lightWeightClose) {
                        lcc = this.getEmbedConnection().getLanguageConnection();
                        lcc.popStatementContext(lcc.getStatementContext(), null);
                    } else {
                        this.setupContextStack(false);
                    }
                }
                catch (SQLException se) {
                    if (enableStats) {
                        this.stmt.stats.incStat(2, false, -1L);
                    }
                    return;
                }
                try {
                    try {
                        this.theResults.close(this.isLocallyProcessing);
                        if (this.singleUseActivation != null) {
                            EmbedStatement.FinalizeStatement finalizer;
                            this.singleUseActivation.close();
                            if (this.stmt != null && (finalizer = this.stmt.finalizer) != null) {
                                finalizer.clearSingleUseActivation(this.singleUseActivation);
                            }
                            this.singleUseActivation = null;
                        }
                    }
                    catch (Throwable t) {
                        throw this.handleException(t);
                    }
                    if (this.forMetaData) {
                        lcc = this.getEmbedConnection().getLanguageConnection();
                        if (lcc.getActivationCount() <= 1 && this.owningStmt != null) {
                            this.owningStmt.resultSetClosing(this);
                        }
                    } else if (this.owningStmt != null) {
                        this.owningStmt.resultSetClosing(this);
                    }
                    EmbedConnection conn = this.getEmbedConnection();
                    EmbedResultSet.releaseNonTXLocks(lightWeightClose, conn.getLanguageConnectionContext(), this.theResults);
                    GemFireTransaction tran = (GemFireTransaction)conn.getLanguageConnectionContext().getTransactionExecute();
                    if (tran != null) {
                        tran.release();
                    }
                    this.isClosed = true;
                    if (lightWeightClose) break block24;
                }
                catch (Throwable throwable) {
                    this.isClosed = true;
                    if (!lightWeightClose) {
                        this.restoreContextStack();
                    }
                    if (enableStats) {
                        this.stmt.stats.incStat(2, !lightWeightClose, -1L);
                        this.stmt.stats.incStat(1, !lightWeightClose, 1L);
                    }
                    throw throwable;
                }
                this.restoreContextStack();
            }
            if (enableStats) {
                this.stmt.stats.incStat(2, !lightWeightClose, -1L);
                this.stmt.stats.incStat(1, !lightWeightClose, 1L);
            }
            this.currentRow = null;
        }
    }

    @Override
    public final boolean wasNull() throws SQLException {
        this.checkIfClosed("wasNull");
        return this.wasNull;
    }

    @Override
    public final String getString(int columnIndex) throws SQLException {
        String value;
        block8: {
            this.checkIfClosed("getString");
            value = null;
            if (this.currentRow instanceof AbstractCompactExecRow) {
                this.wasNull = false;
                this.isValid(columnIndex);
                try {
                    value = ((AbstractCompactExecRow)this.currentRow).getAsString(columnIndex, this);
                    if (value == null) {
                        return null;
                    }
                    break block8;
                }
                catch (StandardException se) {
                    throw EmbedResultSet.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
                }
            }
            try {
                DataValueDescriptor dvd = this.getColumn(columnIndex);
                value = dvd.getString();
                this.wasNull = value == null;
                if (this.wasNull) {
                    return null;
                }
            }
            catch (StandardException t) {
                throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(this.getColumnType(columnIndex)) && value.length() > this.maxFieldSize) {
            value = value.substring(0, this.maxFieldSize);
        }
        return value;
    }

    @Override
    public final boolean getBoolean(int columnIndex) throws SQLException {
        this.checkIfClosed("getBoolean");
        if (this.currentRow instanceof AbstractCompactExecRow) {
            this.wasNull = false;
            this.isValid(columnIndex);
            try {
                return ((AbstractCompactExecRow)this.currentRow).getAsBoolean(columnIndex, this);
            }
            catch (StandardException se) {
                throw EmbedResultSet.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return false;
            }
            return dvd.getBoolean();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final byte getByte(int columnIndex) throws SQLException {
        this.checkIfClosed("getByte");
        if (this.currentRow instanceof AbstractCompactExecRow) {
            this.wasNull = false;
            this.isValid(columnIndex);
            try {
                return ((AbstractCompactExecRow)this.currentRow).getAsByte(columnIndex, this);
            }
            catch (StandardException se) {
                throw EmbedResultSet.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dvd.getByte();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final short getShort(int columnIndex) throws SQLException {
        this.checkIfClosed("getShort");
        if (this.currentRow instanceof AbstractCompactExecRow) {
            this.wasNull = false;
            this.isValid(columnIndex);
            try {
                return ((AbstractCompactExecRow)this.currentRow).getAsShort(columnIndex, this);
            }
            catch (StandardException se) {
                throw EmbedResultSet.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dvd.getShort();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final int getInt(int columnIndex) throws SQLException {
        this.checkIfClosed("getInt");
        if (this.currentRow instanceof AbstractCompactExecRow) {
            this.wasNull = false;
            this.isValid(columnIndex);
            try {
                return ((AbstractCompactExecRow)this.currentRow).getAsInt(columnIndex, this);
            }
            catch (StandardException se) {
                throw EmbedResultSet.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dvd.getInt();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final long getLong(int columnIndex) throws SQLException {
        this.checkIfClosed("getLong");
        if (this.currentRow instanceof AbstractCompactExecRow) {
            this.wasNull = false;
            this.isValid(columnIndex);
            try {
                return ((AbstractCompactExecRow)this.currentRow).getAsLong(columnIndex, this);
            }
            catch (StandardException se) {
                throw EmbedResultSet.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return 0L;
            }
            return dvd.getLong();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final float getFloat(int columnIndex) throws SQLException {
        this.checkIfClosed("getFloat");
        if (this.currentRow instanceof AbstractCompactExecRow) {
            this.wasNull = false;
            this.isValid(columnIndex);
            try {
                return ((AbstractCompactExecRow)this.currentRow).getAsFloat(columnIndex, this);
            }
            catch (StandardException se) {
                throw EmbedResultSet.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return 0.0f;
            }
            return dvd.getFloat();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final double getDouble(int columnIndex) throws SQLException {
        this.checkIfClosed("getDouble");
        if (this.currentRow instanceof AbstractCompactExecRow) {
            this.wasNull = false;
            this.isValid(columnIndex);
            try {
                return ((AbstractCompactExecRow)this.currentRow).getAsDouble(columnIndex, this);
            }
            catch (StandardException se) {
                throw EmbedResultSet.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return 0.0;
            }
            return dvd.getDouble();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final byte[] getBytes(int columnIndex) throws SQLException {
        this.checkIfClosed("getBytes");
        if (this.currentRow instanceof AbstractCompactExecRow) {
            this.wasNull = false;
            this.isValid(columnIndex);
            try {
                return ((AbstractCompactExecRow)this.currentRow).getAsBytes(columnIndex, this);
            }
            catch (StandardException se) {
                throw EmbedResultSet.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            byte[] value = dvd.getBytes();
            if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(this.getColumnType(columnIndex)) && value.length > this.maxFieldSize) {
                byte[] limited_value = new byte[this.maxFieldSize];
                System.arraycopy(value, 0, limited_value, 0, this.maxFieldSize);
                value = limited_value;
            }
            return value;
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, (Calendar)null);
    }

    @Override
    public final Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, (Calendar)null);
    }

    @Override
    public final Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, (Calendar)null);
    }

    @Override
    public final Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkIfClosed("getDate");
        if (this.currentRow instanceof AbstractCompactExecRow) {
            this.wasNull = false;
            this.isValid(columnIndex);
            try {
                Date date;
                if (cal == null) {
                    cal = this.getCal();
                }
                this.wasNull = (date = ((AbstractCompactExecRow)this.currentRow).getAsDate(columnIndex, cal, this)) == null;
                return date;
            }
            catch (StandardException se) {
                throw EmbedResultSet.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            if (cal == null) {
                cal = this.getCal();
            }
            return dvd.getDate(cal);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final Date getDate(String columnName, Calendar cal) throws SQLException {
        this.checkIfClosed("getDate");
        return this.getDate(this.findColumnName(columnName), cal);
    }

    @Override
    public final Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkIfClosed("getTime");
        if (this.currentRow instanceof AbstractCompactExecRow) {
            this.wasNull = false;
            this.isValid(columnIndex);
            try {
                Time time;
                if (cal == null) {
                    cal = this.getCal();
                }
                this.wasNull = (time = ((AbstractCompactExecRow)this.currentRow).getAsTime(columnIndex, cal, this)) == null;
                return time;
            }
            catch (StandardException se) {
                throw EmbedResultSet.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            if (cal == null) {
                cal = this.getCal();
            }
            return dvd.getTime(cal);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final Time getTime(String columnName, Calendar cal) throws SQLException {
        this.checkIfClosed("getTime");
        return this.getTime(this.findColumnName(columnName), cal);
    }

    @Override
    public final Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.checkIfClosed("getTimestamp");
        return this.getTimestamp(this.findColumnName(columnName), cal);
    }

    @Override
    public final Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkIfClosed("getTimestamp");
        if (this.currentRow instanceof AbstractCompactExecRow) {
            this.wasNull = false;
            this.isValid(columnIndex);
            try {
                Timestamp ts;
                if (cal == null) {
                    cal = this.getCal();
                }
                this.wasNull = (ts = ((AbstractCompactExecRow)this.currentRow).getAsTimestamp(columnIndex, cal, this)) == null;
                return ts;
            }
            catch (StandardException se) {
                throw EmbedResultSet.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            if (cal == null) {
                cal = this.getCal();
            }
            return dvd.getTimestamp(cal);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Reader getCharacterStream(int columnIndex) throws SQLException {
        Object syncLock;
        int lmfs;
        this.checkIfClosed("getCharacterStream");
        int colType = this.getColumnType(columnIndex);
        switch (colType) {
            case -1: 
            case 1: 
            case 12: {
                lmfs = this.maxFieldSize;
                break;
            }
            case 2005: 
            case 4002: {
                lmfs = 0;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                try {
                    InputStream is = this.getBinaryStream(columnIndex);
                    if (is == null) {
                        return null;
                    }
                    InputStreamReader r = new InputStreamReader(is, "UTF-16BE");
                    this.currentStream = r;
                    return r;
                }
                catch (UnsupportedEncodingException uee) {
                    throw new SQLException(uee.getMessage());
                }
            }
            default: {
                throw this.dataTypeConversion("java.io.Reader", columnIndex);
            }
        }
        Object object = syncLock = this.getConnectionSynchronization();
        synchronized (object) {
            boolean pushStack = false;
            try {
                this.useStream(columnIndex);
                DataValueDescriptor dvd = this.getColumn(columnIndex);
                this.wasNull = dvd.isNull();
                if (this.wasNull) {
                    Reader reader = null;
                    return reader;
                }
                pushStack = true;
                this.setupContextStack(false);
                StreamStorable ss = (StreamStorable)((Object)dvd);
                InputStream stream = ss.returnStream();
                if (stream == null) {
                    String val = dvd.getString();
                    if (lmfs > 0 && val.length() > lmfs) {
                        val = val.substring(0, lmfs);
                    }
                    StringReader ret = new StringReader(val);
                    this.currentStream = ret;
                    StringReader stringReader = ret;
                    return stringReader;
                }
                UTF8Reader ret = new UTF8Reader(stream, lmfs, this, syncLock);
                this.currentStream = ret;
                UTF8Reader uTF8Reader = ret;
                return uTF8Reader;
            }
            catch (Throwable t) {
                throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
            finally {
                if (pushStack) {
                    this.restoreContextStack();
                }
            }
        }
    }

    @Override
    public final InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkIfClosed("getAsciiStream");
        int colType = this.getColumnType(columnIndex);
        switch (colType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 4002: {
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return this.getBinaryStream(columnIndex);
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream(ASCII)", columnIndex);
            }
        }
        Reader reader = this.getCharacterStream(columnIndex);
        if (reader == null) {
            return null;
        }
        return new ReaderToAscii(reader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final InputStream getBinaryStream(int columnIndex) throws SQLException {
        Object syncLock;
        int lmfs;
        this.checkIfClosed("getBinaryStream");
        int colType = this.getColumnType(columnIndex);
        switch (colType) {
            case -4: 
            case -3: 
            case -2: {
                lmfs = this.maxFieldSize;
                break;
            }
            case 2004: {
                lmfs = 0;
                break;
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream", columnIndex);
            }
        }
        Object object = syncLock = this.getConnectionSynchronization();
        synchronized (object) {
            boolean pushStack = false;
            try {
                this.useStream(columnIndex);
                DataValueDescriptor dvd = this.getColumn(columnIndex);
                this.wasNull = dvd.isNull();
                if (this.wasNull) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                pushStack = true;
                this.setupContextStack(false);
                StreamStorable ss = (StreamStorable)((Object)dvd);
                InputStream stream = ss.returnStream();
                stream = stream == null ? new NewByteArrayInputStream(dvd.getBytes()) : new BinaryToRawStream(stream, dvd);
                if (lmfs > 0) {
                    LimitInputStream limitResultIn = new LimitInputStream(stream);
                    limitResultIn.setLimit(lmfs);
                    stream = limitResultIn;
                }
                this.currentStream = stream;
                InputStream inputStream = stream;
                return inputStream;
            }
            catch (Throwable t) {
                throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
            finally {
                if (pushStack) {
                    this.restoreContextStack();
                }
            }
        }
    }

    @Override
    public final String getString(String columnName) throws SQLException {
        this.checkIfClosed("getString");
        return this.getString(this.findColumnName(columnName));
    }

    @Override
    public final boolean getBoolean(String columnName) throws SQLException {
        this.checkIfClosed("getBoolean");
        return this.getBoolean(this.findColumnName(columnName));
    }

    @Override
    public final byte getByte(String columnName) throws SQLException {
        this.checkIfClosed("getByte");
        return this.getByte(this.findColumnName(columnName));
    }

    @Override
    public final short getShort(String columnName) throws SQLException {
        this.checkIfClosed("getShort");
        return this.getShort(this.findColumnName(columnName));
    }

    @Override
    public final int getInt(String columnName) throws SQLException {
        this.checkIfClosed("getInt");
        return this.getInt(this.findColumnName(columnName));
    }

    @Override
    public final long getLong(String columnName) throws SQLException {
        this.checkIfClosed("getLong");
        return this.getLong(this.findColumnName(columnName));
    }

    @Override
    public final float getFloat(String columnName) throws SQLException {
        this.checkIfClosed("getFloat");
        return this.getFloat(this.findColumnName(columnName));
    }

    @Override
    public final double getDouble(String columnName) throws SQLException {
        this.checkIfClosed("getDouble");
        return this.getDouble(this.findColumnName(columnName));
    }

    @Override
    public final byte[] getBytes(String columnName) throws SQLException {
        this.checkIfClosed("getBytes");
        return this.getBytes(this.findColumnName(columnName));
    }

    @Override
    public final Date getDate(String columnName) throws SQLException {
        this.checkIfClosed("getDate");
        return this.getDate(this.findColumnName(columnName));
    }

    @Override
    public final Time getTime(String columnName) throws SQLException {
        this.checkIfClosed("getTime");
        return this.getTime(this.findColumnName(columnName));
    }

    @Override
    public final Timestamp getTimestamp(String columnName) throws SQLException {
        this.checkIfClosed("getTimestamp");
        return this.getTimestamp(this.findColumnName(columnName));
    }

    @Override
    public final Reader getCharacterStream(String columnName) throws SQLException {
        this.checkIfClosed("getCharacterStream");
        return this.getCharacterStream(this.findColumnName(columnName));
    }

    @Override
    public final InputStream getAsciiStream(String columnName) throws SQLException {
        this.checkIfClosed("getAsciiStream");
        return this.getAsciiStream(this.findColumnName(columnName));
    }

    @Override
    public final InputStream getBinaryStream(String columnName) throws SQLException {
        this.checkIfClosed("getBinaryStream");
        return this.getBinaryStream(this.findColumnName(columnName));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed("getWarnings");
        return this.topWarning;
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.checkIfClosed("clearWarnings");
        this.topWarning = null;
    }

    @Override
    public final String getCursorName() throws SQLException {
        this.checkIfClosed("getCursorName");
        return this.theResults.getCursorName();
    }

    @Override
    public final ResultSetMetaData getMetaData() throws SQLException {
        this.checkIfClosed("getMetaData");
        ResultSetMetaData rMetaData = this.resultDescription.getMetaData();
        if (rMetaData == null) {
            rMetaData = this.factory.newEmbedResultSetMetaData(this.resultDescription.getColumnInfo());
            this.resultDescription.setMetaData(rMetaData);
        }
        return rMetaData;
    }

    @Override
    public final int getHoldability() throws SQLException {
        this.checkIfClosed("getHoldability");
        if (this.theResults.getActivation().getResultSetHoldability()) {
            return 1;
        }
        return 2;
    }

    @Override
    public final Object getObject(int columnIndex) throws SQLException {
        this.checkIfClosed("getObject");
        int colType = this.getColumnType(columnIndex);
        switch (colType) {
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 2005: {
                return this.getClob(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 2004: {
                return this.getBlob(columnIndex);
            }
            case 4002: {
                return this.getClob(columnIndex);
            }
        }
        if (this.currentRow instanceof AbstractCompactExecRow) {
            this.wasNull = false;
            this.isValid(columnIndex);
            try {
                return ((AbstractCompactExecRow)this.currentRow).getAsObject(columnIndex, this);
            }
            catch (StandardException se) {
                throw EmbedResultSet.noStateChangeException(se, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            Object result = dvd.getObject();
            this.wasNull = result == null;
            return result;
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final Object getObject(String columnName) throws SQLException {
        this.checkIfClosed("getObject");
        return this.getObject(this.findColumnName(columnName));
    }

    @Override
    public final int findColumn(String columnName) throws SQLException {
        this.checkIfClosed("findColumn");
        return this.findColumnName(columnName);
    }

    @Override
    public final Statement getStatement() throws SQLException {
        this.checkIfClosed("getStatement");
        return this.applicationStmt;
    }

    public final void setApplicationStatement(Statement applicationStmt) {
        this.applicationStmt = applicationStmt;
    }

    @Override
    public final boolean isBeforeFirst() throws SQLException {
        return this.checkRowPosition(101, "isBeforeFirst");
    }

    @Override
    public final boolean isAfterLast() throws SQLException {
        return this.checkRowPosition(104, "isAfterLast");
    }

    @Override
    public final boolean isFirst() throws SQLException {
        return this.checkRowPosition(102, "isFirst");
    }

    @Override
    public final boolean isLast() throws SQLException {
        return this.checkRowPosition(103, "isLast");
    }

    @Override
    public final void beforeFirst() throws SQLException {
        this.checkScrollCursor("beforeFirst()");
        this.movePosition(5, "beforeFirst");
    }

    @Override
    public final void afterLast() throws SQLException {
        this.checkScrollCursor("afterLast()");
        this.movePosition(6, "afterLast");
    }

    @Override
    public final boolean first() throws SQLException {
        this.checkScrollCursor("first()");
        return this.movePosition(1, "first");
    }

    @Override
    public final boolean last() throws SQLException {
        this.checkScrollCursor("last()");
        return this.movePosition(3, "last");
    }

    @Override
    public final int getRow() throws SQLException {
        this.checkScrollCursor("getRow()");
        return this.theResults.getRowNumber();
    }

    @Override
    public final boolean absolute(int row) throws SQLException {
        this.checkScrollCursor("absolute()");
        return this.movePosition(7, row, "absolute", false);
    }

    @Override
    public final boolean relative(int row) throws SQLException {
        this.checkScrollCursor("relative()");
        return this.movePosition(8, row, "relative", false);
    }

    @Override
    public final boolean previous() throws SQLException {
        this.checkScrollCursor("previous()");
        return this.movePosition(4, "previous");
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        this.checkScrollCursor("setFetchDirection()");
        this.fetchDirection = direction;
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        this.checkIfClosed("getFetchDirection");
        if (this.fetchDirection == 0) {
            if (this.stmt == null) {
                return 1000;
            }
            return this.stmt.getFetchDirection();
        }
        return this.fetchDirection;
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        this.checkIfClosed("setFetchSize");
        if (rows < 0 || this.stmt.getMaxRows() != 0 && rows > this.stmt.getMaxRows()) {
            throw Util.generateCsSQLException("XJ062.S", new Integer(rows));
        }
        if (rows > 0) {
            this.fetchSize = rows;
        }
    }

    @Override
    public final int getFetchSize() throws SQLException {
        this.checkIfClosed("getFetchSize");
        if (this.fetchSize == 0) {
            return this.stmt.getFetchSize();
        }
        return this.fetchSize;
    }

    @Override
    public final int getType() throws SQLException {
        this.checkIfClosed("getType");
        if (this.stmt == null) {
            return 1003;
        }
        return this.stmt.getResultSetType();
    }

    @Override
    public final int getConcurrency() throws SQLException {
        this.checkIfClosed("getConcurrency");
        return this.concurrencyOfThisResultSet;
    }

    @Override
    public final boolean rowUpdated() throws SQLException {
        this.checkIfClosed("rowUpdated");
        this.checkNotOnInsertRow();
        this.checkOnRow();
        boolean rvalue = false;
        try {
            if (this.isForUpdate() && this.getType() == 1004) {
                rvalue = ((ScrollInsensitiveResultSet)this.theResults).isUpdated();
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return rvalue;
    }

    @Override
    public final boolean rowInserted() throws SQLException {
        this.checkIfClosed("rowInserted");
        this.checkNotOnInsertRow();
        this.checkOnRow();
        return false;
    }

    @Override
    public final boolean rowDeleted() throws SQLException {
        this.checkIfClosed("rowUpdated");
        this.checkNotOnInsertRow();
        this.checkOnRow();
        boolean rvalue = false;
        try {
            if (this.isForUpdate() && this.getType() == 1004) {
                rvalue = ((ScrollInsensitiveResultSet)this.theResults).isDeleted();
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return rvalue;
    }

    protected final void checksBeforeUpdateXXX(String methodName, int columnIndex) throws SQLException {
        this.checksBeforeUpdateOrDelete(methodName, columnIndex);
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw Util.generateCsSQLException("XCL14.S", (Object)new Integer(columnIndex), String.valueOf(this.resultDescription.getColumnCount()));
        }
        if (this.resultDescription.getColumnDescriptor(columnIndex).getSourceTableName() == null) {
            throw Util.generateCsSQLException("XJ084.U", methodName);
        }
        if (!this.getMetaData().isWritable(columnIndex)) {
            throw Util.generateCsSQLException("42X31", (Object)this.resultDescription.getColumnDescriptor(columnIndex).getName(), this.getCursorName());
        }
    }

    protected final void checksBeforeUpdateOrDelete(String methodName, int columnIndex) throws SQLException {
        this.checkIfClosed(methodName);
        this.checkUpdatableCursor(methodName);
        if (!this.isOnInsertRow) {
            this.checkOnRow();
        }
    }

    protected final DataValueDescriptor getDVDforColumnToBeUpdated(int columnIndex, String updateMethodName) throws StandardException, SQLException {
        this.checksBeforeUpdateXXX(updateMethodName, columnIndex);
        this.columnGotUpdated[columnIndex - 1] = true;
        this.currentRowHasBeenUpdated = true;
        return this.updateRow.getColumn(columnIndex);
    }

    protected final void checksBeforeInsert() throws SQLException {
        this.checkIfClosed("insertRow");
        this.checkUpdatableCursor("insertRow");
        if (!this.isOnInsertRow) {
            throw this.newSQLException("XJ086.S");
        }
    }

    private void checksBeforeUpdateAsciiStream(int columnIndex) throws SQLException {
        this.checksBeforeUpdateXXX("updateAsciiStream", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (!DataTypeDescriptor.isAsciiStreamAssignable(colType)) {
            throw this.dataTypeConversion(columnIndex, "java.io.InputStream");
        }
    }

    private void checksBeforeUpdateBinaryStream(int columnIndex) throws SQLException {
        this.checksBeforeUpdateXXX("updateBinaryStream", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (!DataTypeDescriptor.isBinaryStreamAssignable(colType)) {
            throw this.dataTypeConversion(columnIndex, "java.io.InputStream");
        }
    }

    private void checksBeforeUpdateCharacterStream(int columnIndex) throws SQLException {
        this.checksBeforeUpdateXXX("updateCharacterStream", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (!DataTypeDescriptor.isCharacterStreamAssignable(colType)) {
            throw this.dataTypeConversion(columnIndex, "java.io.Reader");
        }
    }

    @Override
    public final void updateNull(int columnIndex) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateNull").setToNull();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateBoolean(int columnIndex, boolean x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateBoolean").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateByte(int columnIndex, byte x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateByte").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateShort(int columnIndex, short x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateShort").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateInt(int columnIndex, int x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateInt").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateLong(int columnIndex, long x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateLong").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateFloat(int columnIndex, float x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateFloat").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateDouble(int columnIndex, double x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateDouble").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateString(int columnIndex, String x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateString").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateBytes(int columnIndex, byte[] x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateBytes").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateDate(int columnIndex, Date x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateDate").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateTime(int columnIndex, Time x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateTime").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateTimestamp").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checksBeforeUpdateAsciiStream(columnIndex);
        InputStreamReader r = null;
        if (x != null) {
            try {
                r = new InputStreamReader(x, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                throw new SQLException(uee.getMessage());
            }
        }
        this.updateCharacterStreamInternal(columnIndex, r, false, length, "updateAsciiStream");
    }

    @Override
    public final void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.checksBeforeUpdateAsciiStream(columnIndex);
        InputStreamReader r = null;
        if (x != null) {
            try {
                r = new InputStreamReader(x, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                throw new SQLException(uee.getMessage());
            }
        }
        this.updateCharacterStreamInternal(columnIndex, r, true, -1L, "updateAsciiStream");
    }

    @Override
    public final void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checksBeforeUpdateBinaryStream(columnIndex);
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        this.updateBinaryStreamInternal(columnIndex, x, false, length, "updateBinaryStream");
    }

    @Override
    public final void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.checksBeforeUpdateBinaryStream(columnIndex);
        this.updateBinaryStreamInternal(columnIndex, x, true, -1L, "updateBinaryStream");
    }

    private void updateBinaryStreamInternal(int columnIndex, InputStream x, boolean lengthLess, long length, String updateMethodName) throws SQLException {
        RawToBinaryFormatStream rawStream;
        if (!lengthLess) {
            if (length < 0L) {
                throw this.newSQLException("XJ025.S");
            }
            if (length > Integer.MAX_VALUE) {
                throw this.newSQLException("22003", this.getColumnSQLType(columnIndex), this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
            rawStream = new RawToBinaryFormatStream(x, (int)length);
        } else {
            length = -1L;
            rawStream = new RawToBinaryFormatStream(x, this.getMaxColumnWidth(columnIndex), this.getColumnSQLType(columnIndex));
        }
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, updateMethodName).setValue(rawStream, (int)length);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.checksBeforeUpdateCharacterStream(columnIndex);
        this.updateCharacterStreamInternal(columnIndex, x, false, length, "updateCharacterStream");
    }

    @Override
    public final void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.checksBeforeUpdateCharacterStream(columnIndex);
        this.updateCharacterStreamInternal(columnIndex, x, true, -1L, "updateCharacterStream");
    }

    private void updateCharacterStreamInternal(int columnIndex, Reader reader, boolean lengthLess, long length, String updateMethodName) throws SQLException {
        try {
            ReaderToUTF8Stream utfIn;
            if (reader == null) {
                this.updateNull(columnIndex);
                return;
            }
            int usableLength = -1;
            if (!lengthLess) {
                int colWidth;
                if (length < 0L) {
                    throw this.newSQLException("XJ025.S");
                }
                if (length > Integer.MAX_VALUE) {
                    throw this.newSQLException("22003", this.getColumnSQLType(columnIndex), this.resultDescription.getColumnDescriptor(columnIndex).getName());
                }
                usableLength = (int)length;
                int truncationLength = 0;
                if (this.getColumnType(columnIndex) == 2005 && usableLength > (colWidth = this.getMaxColumnWidth(columnIndex))) {
                    truncationLength = usableLength - colWidth;
                    usableLength = colWidth;
                }
                utfIn = new ReaderToUTF8Stream(reader, usableLength, truncationLength, this.getColumnSQLType(columnIndex));
            } else {
                int colWidth = this.getMaxColumnWidth(columnIndex);
                utfIn = new ReaderToUTF8Stream(reader, colWidth, this.getColumnSQLType(columnIndex));
            }
            this.getDVDforColumnToBeUpdated(columnIndex, updateMethodName).setValue(utfIn, usableLength);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.updateObject(columnIndex, x);
        int colType = this.getColumnType(columnIndex);
        if (colType == 3 || colType == 2) {
            if (scale < 0) {
                throw this.newSQLException("XJ044.S", new Integer(scale));
            }
            try {
                DataValueDescriptor value = this.updateRow.getColumn(columnIndex);
                int origvaluelen = value.getLength();
                ((VariableSizeDataValue)((Object)value)).setWidth(-1, scale, false);
            }
            catch (StandardException t) {
                throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checksBeforeUpdateXXX("updateObject", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType == 2000) {
            try {
                ((UserDataValue)this.getDVDforColumnToBeUpdated(columnIndex, "updateObject")).setValue(x);
                return;
            }
            catch (StandardException t) {
                throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
            }
        }
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        if (x instanceof String) {
            this.updateString(columnIndex, (String)x);
            return;
        }
        if (x instanceof Boolean) {
            this.updateBoolean(columnIndex, (boolean)((Boolean)x));
            return;
        }
        if (x instanceof Short) {
            this.updateShort(columnIndex, (short)((Short)x));
            return;
        }
        if (x instanceof Integer) {
            this.updateInt(columnIndex, (int)((Integer)x));
            return;
        }
        if (x instanceof Long) {
            this.updateLong(columnIndex, (long)((Long)x));
            return;
        }
        if (x instanceof Float) {
            this.updateFloat(columnIndex, ((Float)x).floatValue());
            return;
        }
        if (x instanceof Double) {
            this.updateDouble(columnIndex, (double)((Double)x));
            return;
        }
        if (x instanceof byte[]) {
            this.updateBytes(columnIndex, (byte[])x);
            return;
        }
        if (x instanceof Date) {
            this.updateDate(columnIndex, (Date)x);
            return;
        }
        if (x instanceof Time) {
            this.updateTime(columnIndex, (Time)x);
            return;
        }
        if (x instanceof Timestamp) {
            this.updateTimestamp(columnIndex, (Timestamp)x);
            return;
        }
        if (x instanceof Blob) {
            this.updateBlob(columnIndex, (Blob)x);
            return;
        }
        if (x instanceof Clob) {
            this.updateClob(columnIndex, (Clob)x);
            return;
        }
        throw this.dataTypeConversion(columnIndex, x.getClass().getName());
    }

    @Override
    public final void updateNull(String columnName) throws SQLException {
        this.checkIfClosed("updateNull");
        this.updateNull(this.findColumnName(columnName));
    }

    @Override
    public final void updateBoolean(String columnName, boolean x) throws SQLException {
        this.checkIfClosed("updateBoolean");
        this.updateBoolean(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateByte(String columnName, byte x) throws SQLException {
        this.checkIfClosed("updateByte");
        this.updateByte(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateShort(String columnName, short x) throws SQLException {
        this.checkIfClosed("updateShort");
        this.updateShort(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateInt(String columnName, int x) throws SQLException {
        this.checkIfClosed("updateInt");
        this.updateInt(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateLong(String columnName, long x) throws SQLException {
        this.checkIfClosed("updateLong");
        this.updateLong(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateFloat(String columnName, float x) throws SQLException {
        this.checkIfClosed("updateFloat");
        this.updateFloat(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateDouble(String columnName, double x) throws SQLException {
        this.checkIfClosed("updateDouble");
        this.updateDouble(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateString(String columnName, String x) throws SQLException {
        this.checkIfClosed("updateString");
        this.updateString(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateBytes(String columnName, byte[] x) throws SQLException {
        this.checkIfClosed("updateBytes");
        this.updateBytes(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateDate(String columnName, Date x) throws SQLException {
        this.checkIfClosed("updateDate");
        this.updateDate(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateTime(String columnName, Time x) throws SQLException {
        this.checkIfClosed("updateTime");
        this.updateTime(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.checkIfClosed("updateTimestamp");
        this.updateTimestamp(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(this.findColumnName(columnName), x, length);
    }

    @Override
    public final void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(this.findColumnName(columnName), x, length);
    }

    @Override
    public final void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(this.findColumnName(columnName), reader, length);
    }

    @Override
    public final void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.checkIfClosed("updateObject");
        this.updateObject(this.findColumnName(columnName), x, scale);
    }

    @Override
    public final void updateObject(String columnName, Object x) throws SQLException {
        this.checkIfClosed("updateObject");
        this.updateObject(this.findColumnName(columnName), x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void insertRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.checksBeforeInsert();
            this.setupContextStack(true);
            LanguageConnectionContext lcc = this.getEmbedConnection().getLanguageConnection();
            StatementContext statementContext = null;
            try {
                boolean foundOneColumnAlready = false;
                StringBuilder insertSQL = new StringBuilder("INSERT INTO ");
                StringBuilder valuesSQL = new StringBuilder("VALUES (");
                CursorActivation activation = lcc.lookupCursorActivation(this.getCursorName());
                ExecCursorTableReference targetTable = activation.getPreparedStatement().getTargetTable();
                insertSQL.append(this.getFullBaseTableName(targetTable));
                insertSQL.append(" (");
                for (int i = 1; i <= this.columnCount; ++i) {
                    if (foundOneColumnAlready) {
                        insertSQL.append(",");
                        valuesSQL.append(",");
                    }
                    insertSQL.append(this.quoteSqlIdentifier(this.resultDescription.getColumnDescriptor(i).getName()));
                    if (this.columnGotUpdated[i - 1]) {
                        valuesSQL.append("?");
                    } else {
                        valuesSQL.append("DEFAULT");
                    }
                    foundOneColumnAlready = true;
                }
                insertSQL.append(") ");
                valuesSQL.append(") ");
                insertSQL.append((CharSequence)valuesSQL);
                statementContext = lcc.pushStatementContext(this.isAtomic, false, insertSQL.toString(), null, false, 0L);
                boolean execFlags = false;
                PreparedStatement ps = lcc.prepareInternalStatement(insertSQL.toString(), (short)(execFlags ? 1 : 0));
                Activation act = ps.getActivation(lcc, false, null);
                int paramPosition = 0;
                for (int i = 1; i <= this.columnCount; ++i) {
                    if (!this.columnGotUpdated[i - 1]) continue;
                    act.getParameterValueSet().getParameterForSet(paramPosition++).setValue(this.updateRow.getColumn(i));
                }
                ResultSet rs = ps.execute(act, true, 0L, true, true);
                act.close();
                lcc.popStatementContext(statementContext, null);
                if (statementContext != null) {
                    lcc.popStatementContext(statementContext, null);
                }
            }
            catch (StandardException t) {
                try {
                    throw this.closeOnTransactionError(t);
                }
                catch (Throwable throwable) {
                    if (statementContext != null) {
                        lcc.popStatementContext(statementContext, null);
                    }
                    this.restoreContextStack();
                    throw throwable;
                }
            }
            this.restoreContextStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void updateRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            StatementContext statementContext;
            LanguageConnectionContext lcc;
            block19: {
                this.checksBeforeUpdateOrDelete("updateRow", -1);
                this.checkNotOnInsertRow();
                this.setupContextStack(true);
                lcc = this.getEmbedConnection().getLanguageConnection();
                statementContext = null;
                try {
                    UpdatableResultSet noPutResults;
                    if (!this.currentRowHasBeenUpdated) {
                        return;
                    }
                    if (this.theResults instanceof UpdatableResultSet && (noPutResults = (UpdatableResultSet)((Object)this.theResults)).canUpdateInPlace()) {
                        ((BaseActivation)noPutResults.getActivation()).setUpdatedColumns(this.columnGotUpdated);
                        noPutResults.updateRow(this.updateRow);
                        return;
                    }
                    InternalDistributedSystem dsys = Misc.getDistributedSystem();
                    if (!dsys.isLoner()) {
                        throw new SQLException("updatable result set not implemented", "0A000.S");
                    }
                    lcc.setIgnoreWhereCurrentOfUnsupportedException(true);
                    boolean foundOneColumnAlready = false;
                    StringBuilder updateWhereCurrentOfSQL = new StringBuilder("UPDATE ");
                    CursorActivation activation = lcc.lookupCursorActivation(this.getCursorName());
                    ExecCursorTableReference targetTable = activation.getPreparedStatement().getTargetTable();
                    updateWhereCurrentOfSQL.append(this.getFullBaseTableName(targetTable));
                    updateWhereCurrentOfSQL.append(" SET ");
                    for (int i = 1; i <= this.columnCount; ++i) {
                        if (!this.columnGotUpdated[i - 1]) continue;
                        if (foundOneColumnAlready) {
                            updateWhereCurrentOfSQL.append(",");
                        }
                        updateWhereCurrentOfSQL.append(this.quoteSqlIdentifier(this.resultDescription.getColumnDescriptor(i).getName()) + "=?");
                        foundOneColumnAlready = true;
                    }
                    updateWhereCurrentOfSQL.append(" WHERE CURRENT OF " + this.quoteSqlIdentifier(this.getCursorName()));
                    statementContext = lcc.pushStatementContext(this.isAtomic, false, updateWhereCurrentOfSQL.toString(), null, false, 0L);
                    boolean execFlags = false;
                    PreparedStatement ps = lcc.prepareInternalStatement(updateWhereCurrentOfSQL.toString(), (short)(execFlags ? 1 : 0));
                    Activation act = ps.getActivation(lcc, false, null);
                    int paramPosition = 0;
                    for (int i = 1; i <= this.columnCount; ++i) {
                        if (!this.columnGotUpdated[i - 1]) continue;
                        act.getParameterValueSet().getParameterForSet(paramPosition++).setValue(this.updateRow.getColumn(i));
                    }
                    ps.execute(act, true, 0L, true, true);
                    SQLWarning w = act.getWarnings();
                    if (w != null) {
                        this.addWarning(w);
                    }
                    act.close();
                    if (this.getType() == 1003) {
                        this.currentRow = null;
                    } else {
                        this.movePosition(8, 0, "relative", false);
                    }
                    lcc.popStatementContext(statementContext, null);
                    statementContext = null;
                    if (statementContext == null) break block19;
                }
                catch (StandardException t) {
                    throw this.closeOnTransactionError(t);
                }
                lcc.popStatementContext(statementContext, null);
            }
            this.restoreContextStack();
            this.initializeUpdateRowModifiers();
            lcc.setIgnoreWhereCurrentOfUnsupportedException(false);
            return;
            finally {
                if (statementContext != null) {
                    lcc.popStatementContext(statementContext, null);
                }
                this.restoreContextStack();
                this.initializeUpdateRowModifiers();
                lcc.setIgnoreWhereCurrentOfUnsupportedException(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void deleteRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            StatementContext statementContext;
            LanguageConnectionContext lcc;
            block12: {
                this.checksBeforeUpdateOrDelete("deleteRow", -1);
                this.checkNotOnInsertRow();
                this.setupContextStack(true);
                lcc = this.getEmbedConnection().getLanguageConnection();
                statementContext = null;
                try {
                    UpdatableResultSet noPutResults;
                    if (this.theResults instanceof UpdatableResultSet && (noPutResults = (UpdatableResultSet)((Object)this.theResults)).canUpdateInPlace()) {
                        noPutResults.deleteRowDirectly();
                        return;
                    }
                    InternalDistributedSystem dsys = Misc.getDistributedSystem();
                    if (!dsys.isLoner()) {
                        throw new SQLException("updatable result set not implemented", "0A000.S");
                    }
                    lcc.setIgnoreWhereCurrentOfUnsupportedException(true);
                    StringBuilder deleteWhereCurrentOfSQL = new StringBuilder("DELETE FROM ");
                    CursorActivation activation = lcc.lookupCursorActivation(this.getCursorName());
                    deleteWhereCurrentOfSQL.append(this.getFullBaseTableName(activation.getPreparedStatement().getTargetTable()));
                    deleteWhereCurrentOfSQL.append(" WHERE CURRENT OF " + this.quoteSqlIdentifier(this.getCursorName()));
                    statementContext = lcc.pushStatementContext(this.isAtomic, false, deleteWhereCurrentOfSQL.toString(), null, false, 0L);
                    boolean execFlags = false;
                    PreparedStatement ps = lcc.prepareInternalStatement(deleteWhereCurrentOfSQL.toString(), (short)(execFlags ? 1 : 0));
                    Activation act = ps.getActivation(lcc, false, null);
                    ResultSet rs = ps.execute(act, true, 0L, true, true);
                    SQLWarning w = act.getWarnings();
                    if (w != null) {
                        this.addWarning(w);
                    }
                    act.close();
                    this.currentRow = null;
                    lcc.popStatementContext(statementContext, null);
                    if (statementContext == null) break block12;
                }
                catch (StandardException t) {
                    throw this.closeOnTransactionError(t);
                }
                lcc.popStatementContext(statementContext, null);
            }
            this.restoreContextStack();
            this.initializeUpdateRowModifiers();
            lcc.setIgnoreWhereCurrentOfUnsupportedException(false);
            return;
            finally {
                if (statementContext != null) {
                    lcc.popStatementContext(statementContext, null);
                }
                this.restoreContextStack();
                this.initializeUpdateRowModifiers();
                lcc.setIgnoreWhereCurrentOfUnsupportedException(false);
            }
        }
    }

    private String getFullBaseTableName(ExecCursorTableReference targetTable) {
        if (targetTable.getSchemaName() != null) {
            return this.quoteSqlIdentifier(targetTable.getSchemaName()) + "." + this.quoteSqlIdentifier(targetTable.getBaseName());
        }
        return this.quoteSqlIdentifier(targetTable.getBaseName());
    }

    private String quoteSqlIdentifier(String orgValue) {
        int i = 0;
        int start = 0;
        String retValue = "";
        while ((i = orgValue.indexOf("\"", start) + 1) > 0) {
            retValue = retValue + orgValue.substring(start, i) + "\"";
            start = i;
        }
        retValue = retValue + orgValue.substring(start, orgValue.length());
        return "\"" + retValue + "\"";
    }

    @Override
    public final void refreshRow() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void cancelRowUpdates() throws SQLException {
        this.checksBeforeUpdateOrDelete("cancelRowUpdates", -1);
        this.checkNotOnInsertRow();
        this.initializeUpdateRowModifiers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void moveToInsertRow() throws SQLException {
        this.checkExecIfClosed("moveToInsertRow");
        this.checkUpdatableCursor("moveToInsertRow");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                this.setupContextStack(false);
                this.initializeUpdateRowModifiers();
                this.isOnInsertRow = true;
                for (int i = 1; i <= this.columnGotUpdated.length; ++i) {
                    this.updateRow.setColumn(i, this.resultDescription.getColumnDescriptor(i).getType().getNull());
                }
            }
            catch (Throwable ex) {
                this.handleException(ex);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void moveToCurrentRow() throws SQLException {
        this.checkExecIfClosed("moveToCurrentRow");
        this.checkUpdatableCursor("moveToCurrentRow");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                if (this.isOnInsertRow) {
                    this.initializeUpdateRowModifiers();
                    this.isOnInsertRow = false;
                }
            }
            catch (Throwable ex) {
                this.handleException(ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Blob getBlob(int columnIndex) throws SQLException {
        this.closeCurrentStream();
        this.checkIfClosed("getBlob");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            int colType = this.getColumnType(columnIndex);
            if (colType != 2004) {
                throw this.dataTypeConversion("java.sql.Blob", columnIndex);
            }
            boolean pushStack = false;
            try {
                Object blob;
                DataValueDescriptor dvd = this.getColumn(columnIndex);
                this.wasNull = dvd.isNull();
                if (this.wasNull) {
                    Blob blob2 = null;
                    return blob2;
                }
                if (dvd.getStream() != null) {
                    pushStack = true;
                }
                if (pushStack) {
                    this.setupContextStack(false);
                }
                if ((blob = dvd.getObject()) instanceof BufferedBlob) {
                    BufferedBlob bufferedBlob = (BufferedBlob)blob;
                    return bufferedBlob;
                }
                HarmonySerialBlob harmonySerialBlob = HarmonySerialBlob.wrapBytes(dvd.getBytes());
                return harmonySerialBlob;
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                if (pushStack) {
                    this.restoreContextStack();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Clob getClob(int columnIndex) throws SQLException {
        this.closeCurrentStream();
        this.checkIfClosed("getClob");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            int colType = this.getColumnType(columnIndex);
            switch (colType) {
                case 2005: 
                case 4002: {
                    break;
                }
                default: {
                    throw this.dataTypeConversion("java.sql.Clob", columnIndex);
                }
            }
            boolean pushStack = false;
            try {
                DataValueDescriptor dvd = this.getColumn(columnIndex);
                this.wasNull = dvd.isNull();
                if (this.wasNull) {
                    Clob clob = null;
                    return clob;
                }
                if (dvd.getStream() != null) {
                    pushStack = true;
                }
                if (pushStack) {
                    this.setupContextStack(false);
                }
                if (colType == 2005) {
                    HarmonySerialClob harmonySerialClob = HarmonySerialClob.wrapChars(((SQLChar)dvd).getCharArray(true));
                    return harmonySerialClob;
                }
                HarmonySerialClob harmonySerialClob = new HarmonySerialClob(dvd.getString());
                return harmonySerialClob;
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                if (pushStack) {
                    this.restoreContextStack();
                }
            }
        }
    }

    @Override
    public final Blob getBlob(String columnName) throws SQLException {
        this.checkIfClosed("getBlob");
        return this.getBlob(this.findColumnName(columnName));
    }

    @Override
    public final Clob getClob(String columnName) throws SQLException {
        this.checkIfClosed("getClob");
        return this.getClob(this.findColumnName(columnName));
    }

    @Override
    public final void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.checksBeforeUpdateXXX("updateBlob", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType != 2004) {
            throw this.dataTypeConversion(columnIndex, "java.sql.Blob");
        }
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            long length = x.length();
            this.updateBinaryStreamInternal(columnIndex, x.getBinaryStream(), false, length, "updateBlob");
        }
    }

    @Override
    public final void updateBlob(String columnName, Blob x) throws SQLException {
        this.checkIfClosed("updateBlob");
        this.updateBlob(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateClob(int columnIndex, Clob x) throws SQLException {
        this.checksBeforeUpdateXXX("updateClob", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType != 2005) {
            throw this.dataTypeConversion(columnIndex, "java.sql.Clob");
        }
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            long length = x.length();
            this.updateCharacterStreamInternal(columnIndex, x.getCharacterStream(), false, length, "updateClob");
        }
    }

    @Override
    public final void updateClob(String columnName, Clob x) throws SQLException {
        this.checkIfClosed("updateClob");
        this.updateClob(this.findColumnName(columnName), x);
    }

    protected final int findColumnName(String columnName) throws SQLException {
        if (columnName == null) {
            throw this.newSQLException("XJ018.S");
        }
        int position = this.resultDescription.findColumnInsensitive(columnName);
        if (position == -1) {
            throw this.newSQLException("S0022", columnName);
        }
        return position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeCurrentStream() {
        if (this.currentStream != null) {
            try {
                EmbedResultSet embedResultSet = this;
                synchronized (embedResultSet) {
                    if (this.currentStream != null) {
                        if (this.currentStream instanceof Reader) {
                            ((Reader)this.currentStream).close();
                        } else {
                            ((InputStream)this.currentStream).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.currentStream = null;
            }
        }
    }

    final void checkIfClosed(String operation) throws SQLException {
        if (this.isClosed) {
            if (!this.isClosed) {
                this.closeCurrentStream();
                this.isClosed = true;
            }
            throw this.newSQLException("XCL16.S.0", operation);
        }
    }

    final void checkExecIfClosed(String operation) throws SQLException {
        EmbedConnection embedConn = this.getEmbedConnection();
        Connection appConn = embedConn.getApplicationConnection();
        if (!this.isClosed) {
            if (appConn == embedConn && embedConn.isActive()) {
                return;
            }
        } else {
            this.checkIfClosed(operation);
        }
        if (appConn == null) {
            throw Util.noCurrentConnection();
        }
        if (appConn.isClosed()) {
            this.closeCurrentStream();
            this.isClosed = true;
            throw Util.noCurrentConnection();
        }
    }

    protected final String getSQLText() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getSQLText();
    }

    protected final ParameterValueSet getParameterValueSet() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getParameterValueSet();
    }

    private static boolean isMaxFieldSizeType(int colType) {
        return colType == -2 || colType == -3 || colType == -4 || colType == 1 || colType == 12 || colType == -1;
    }

    final SQLException closeOnTransactionError(Throwable thrownException) throws SQLException {
        int severity;
        StandardException se = null;
        if (thrownException.getClass() == StandardException.class) {
            se = (StandardException)thrownException;
            EmbedStatement.fillInColumnName(se, null, this.theResults.getActivation());
        }
        EmbedResultSet.releaseNonTXLocks(false, this.getEmbedConnection().getLanguageConnectionContext(), this.theResults);
        SQLException sqle = this.handleException(thrownException);
        if (se != null && (severity = se.getSeverity()) == 30000) {
            try {
                this.close();
            }
            catch (Throwable t) {
                sqle.setNextException(this.handleException(t));
            }
        }
        return sqle;
    }

    protected final void isValid(int columnIndex) throws SQLException {
        this.closeCurrentStream();
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw this.newSQLException("S0022", new Integer(columnIndex));
        }
    }

    protected final DataValueDescriptor getColumn(int columnIndex) throws SQLException, StandardException {
        this.isValid(columnIndex);
        if (this.isOnInsertRow || this.currentRowHasBeenUpdated && this.columnGotUpdated[columnIndex - 1]) {
            return this.updateRow.getColumn(columnIndex);
        }
        this.checkOnRow();
        return this.currentRow.getColumn(columnIndex);
    }

    static final SQLException noStateChangeException(Throwable thrownException, String columnName) {
        if (thrownException.getClass() == StandardException.class) {
            EmbedStatement.fillInColumnName((StandardException)thrownException, columnName, null);
        }
        return TransactionResourceImpl.wrapInSQLException(thrownException);
    }

    static final SQLException noStateChangeException(StandardException se, String columnName) {
        EmbedStatement.fillInColumnName(se, columnName, null);
        return TransactionResourceImpl.wrapInSQLException(se);
    }

    final void setDynamicResultSet(EmbedStatement owningStmt) {
        if (owningStmt != null) {
            this.owningStmt = owningStmt;
            this.applicationStmt = owningStmt.applicationStatement;
            this.localConn = owningStmt.getEmbedConnection();
        } else {
            this.localConn = this.localConn.rootConnection;
        }
        if (!(this.theResults instanceof ProcedureProcessorResultSet) && !(this.theResults instanceof OutgoingResultSet)) {
            EmbedStatement.FinalizeStatement finalizer;
            this.singleUseActivation = this.theResults.getActivation();
            if (owningStmt != null && (finalizer = owningStmt.finalizer) != null) {
                finalizer.addSingleUseActivation(this.singleUseActivation);
            }
        }
    }

    public final int compareTo(Object other) {
        EmbedResultSet olrs = (EmbedResultSet)other;
        return this.order - olrs.order;
    }

    private void checkScrollCursor(String methodName) throws SQLException {
        this.checkIfClosed(methodName);
        if (this.stmt.getResultSetType() == 1003) {
            throw Util.newEmbedSQLException("XJ061.S", new Object[]{methodName}, StandardException.getSeverityFromIdentifier("XJ061.S"));
        }
    }

    private void checkUpdatableCursor(String operation) throws SQLException {
        if (this.getConcurrency() != 1008) {
            throw Util.generateCsSQLException("XJ083.U", operation);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkRowPosition(int position, String positionText) throws SQLException {
        this.checkScrollCursor(positionText);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack(false);
            try {
                LanguageConnectionContext lcc = this.getEmbedConnection().getLanguageConnection();
                StatementContext statementContext = lcc.pushStatementContext(this.isAtomic, this.concurrencyOfThisResultSet == 1007, this.getSQLText(), this.getParameterValueSet(), false, 0L);
                boolean result = this.theResults.checkRowPosition(position);
                lcc.popStatementContext(statementContext, null);
                boolean bl = result;
                return bl;
            }
            catch (Throwable t) {
                throw this.closeOnTransactionError(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    @Override
    public final boolean isForUpdate() {
        if (this.theResults instanceof UpdatableResultSet) {
            return ((UpdatableResultSet)((Object)this.theResults)).isForUpdate();
        }
        return false;
    }

    final String getColumnSQLType(int column) {
        return this.resultDescription.getColumnDescriptor(column).getType().getTypeId().getSQLTypeName();
    }

    private final int getMaxColumnWidth(int columnIndex) {
        return this.resultDescription.getColumnDescriptor(columnIndex).getType().getMaximumWidth();
    }

    private final SQLException dataTypeConversion(String targetType, int column) {
        return this.newSQLException("22005", targetType, this.getColumnSQLType(column), this.resultDescription.getColumnDescriptor(column).getName());
    }

    private final SQLException dataTypeConversion(int column, String targetType) {
        return this.newSQLException("22005", this.getColumnSQLType(column), targetType, this.resultDescription.getColumnDescriptor(column).getName());
    }

    final void useStream(int columnIndex) throws SQLException {
        if (this.streamUsedFlags == null) {
            this.streamUsedFlags = new boolean[this.getMetaData().getColumnCount()];
        } else if (this.streamUsedFlags[columnIndex - 1]) {
            throw this.newSQLException("XCL18.S");
        }
        this.streamUsedFlags[columnIndex - 1] = true;
    }

    @Override
    public final boolean isClosed() throws SQLException {
        if (this.isClosed) {
            return true;
        }
        try {
            this.checkExecIfClosed("");
            return false;
        }
        catch (SQLException sqle) {
            return this.isClosed;
        }
    }

    private void addWarning(SQLWarning w) {
        if (this.topWarning == null) {
            this.topWarning = w;
        } else {
            this.topWarning.setNextWarning(w);
        }
    }

    @Override
    public final void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(columnIndex, x, (long)length);
    }

    @Override
    public final void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(columnIndex, x, (long)length);
    }

    @Override
    public final void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(columnIndex, x, (long)length);
    }

    @Override
    public final void updateAsciiStream(String columnName, InputStream x, long length) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(this.findColumnName(columnName), x, length);
    }

    @Override
    public final void updateAsciiStream(String columnName, InputStream x) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateBinaryStream(String columnName, InputStream x, long length) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(this.findColumnName(columnName), x, length);
    }

    @Override
    public final void updateBinaryStream(String columnName, InputStream x) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateCharacterStream(String columnName, Reader reader, long length) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(this.findColumnName(columnName), reader, length);
    }

    @Override
    public final void updateCharacterStream(String columnName, Reader reader) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(this.findColumnName(columnName), reader);
    }

    @Override
    public final void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        this.checksBeforeUpdateXXX("updateBlob", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType != 2004) {
            throw this.dataTypeConversion(columnIndex, "java.sql.Blob");
        }
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            this.updateBinaryStreamInternal(columnIndex, x, false, length, "updateBlob");
        }
    }

    @Override
    public final void updateBlob(int columnIndex, InputStream x) throws SQLException {
        this.checksBeforeUpdateXXX("updateBlob", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType != 2004) {
            throw this.dataTypeConversion(columnIndex, "java.sql.Blob");
        }
        this.updateBinaryStreamInternal(columnIndex, x, true, -1L, "updateBlob");
    }

    @Override
    public final void updateBlob(String columnName, InputStream x, long length) throws SQLException {
        this.checkIfClosed("updateBlob");
        this.updateBlob(this.findColumnName(columnName), x, length);
    }

    @Override
    public final void updateBlob(String columnName, InputStream x) throws SQLException {
        this.checkIfClosed("updateBlob");
        this.updateBlob(this.findColumnName(columnName), x);
    }

    @Override
    public final void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        this.checksBeforeUpdateXXX("updateClob", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType != 2005) {
            throw this.dataTypeConversion(columnIndex, "java.sql.Clob");
        }
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            this.updateCharacterStreamInternal(columnIndex, x, false, length, "updateClob");
        }
    }

    @Override
    public final void updateClob(int columnIndex, Reader x) throws SQLException {
        this.checksBeforeUpdateXXX("updateClob", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType != 2005) {
            throw this.dataTypeConversion(columnIndex, "java.sql.Clob");
        }
        this.updateCharacterStreamInternal(columnIndex, x, true, -1L, "updateClob");
    }

    @Override
    public final void updateClob(String columnName, Reader x, long length) throws SQLException {
        this.checkIfClosed("updateClob");
        this.updateClob(this.findColumnName(columnName), x, length);
    }

    @Override
    public final void updateClob(String columnName, Reader x) throws SQLException {
        this.checkIfClosed("updateClob");
        this.updateClob(this.findColumnName(columnName), x);
    }

    @Override
    public final boolean isNull(int columnIndex) throws SQLException {
        try {
            this.isValid(columnIndex);
            return this.currentRow.isNull(columnIndex) == -7L;
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final int getLength(int columnIndex) throws SQLException {
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            return dvd.getLength();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t, this.resultDescription.getColumnDescriptor(columnIndex).getName());
        }
    }

    @Override
    public final void setWasNull() {
        this.wasNull = true;
    }

    public final boolean candidateForChanges() throws SQLException {
        return this.isForUpdate() && this.stmt.getResultSetType() == 1004;
    }

    public final ExecRow getCurrentRow() {
        return this.currentRow;
    }

    public final ResultSet getSourceResultSet() {
        return this.theResults;
    }

    public final int getResultsetIndex() {
        return this.resultsetIndex;
    }

    public final void setResultsetIndex(int resultsetIndex) {
        this.resultsetIndex = resultsetIndex;
    }

    public final void setResultDescription(ResultDescription resultDescription) {
        this.resultDescription = resultDescription;
        this.columnCount = resultDescription.getColumnCount();
    }

    public final boolean isOutgoingResultSet() {
        if (this.theResults == null) {
            return false;
        }
        return this.theResults instanceof OutgoingResultSet;
    }

    public static void releaseNonTXLocks(boolean isLightWeight, LanguageConnectionContext lcc, ResultSet rs) {
        TXStateProxy tx;
        GemFireTransaction tr;
        if (!(isLightWeight || lcc == null || (tr = (GemFireTransaction)lcc.getTransactionExecute()) == null || tr.isTransactional() && (tx = tr.getCurrentTXStateProxy()) != null && tx.isDirty())) {
            rs.releaseLocks(tr);
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x, long length) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateNString(String columnName, String nString) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateNClob(String columnName, NClob nClob) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateNClob(String columnName, Reader reader) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public NClob getNClob(String colName) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateRowId(String columnName, RowId x) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public SQLXML getSQLXML(String colName) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML xmlObject) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public void updateNClob(String columnName, Reader x, long length) throws SQLException {
        throw new AssertionError((Object)"should have been overridden for JDBC 4.0");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return type.cast(this.getObject(columnIndex));
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return type.cast(this.getObject(columnLabel));
    }

    public void buildResultSetString(StringBuilder builder) {
        if (this.theResults instanceof NoPutResultSet) {
            ((NoPutResultSet)this.theResults).buildQueryPlan(builder, ((NoPutResultSet)this.theResults).getNewPlanContext());
        }
    }

    public final void setIsLocallyProcessing(boolean value) {
        this.isLocallyProcessing = value;
    }
}

