/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.internal.shared.FinalizeHolder;
import com.gemstone.gemfire.internal.shared.FinalizeObject;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineLOB;
import com.pivotal.gemfirexd.internal.iapi.services.io.DerbyIOException;
import com.pivotal.gemfirexd.internal.iapi.services.io.InputStreamUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialBlob;
import com.pivotal.gemfirexd.internal.iapi.types.Resetable;
import com.pivotal.gemfirexd.internal.impl.jdbc.AutoPositioningStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.BinaryToRawStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.ConnectionChild;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.LOBStreamControl;
import com.pivotal.gemfirexd.internal.impl.jdbc.PositionedStoreStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.UpdatableBlobStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public final class EmbedBlob
extends ConnectionChild
implements Blob,
EngineLOB,
DataSerializable.Replaceable {
    private boolean materialized;
    private PositionedStoreStream myStream;
    private int locator = 0;
    private long streamLength = -1L;
    private final int streamPositionOffset;
    private boolean isValid = true;
    private LOBStreamControl control;
    FinalizeEmbedBlob finalizer;

    EmbedBlob(byte[] blobBytes, EmbedConnection con) throws SQLException {
        super(con);
        try {
            this.control = new LOBStreamControl(con.getDBName(), blobBytes);
            this.materialized = true;
            this.streamPositionOffset = Integer.MIN_VALUE;
            con.addLOBReference(this);
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    public EmbedBlob(DataValueDescriptor dvd, EmbedConnection con) throws StandardException {
        super(con);
        SanityManager.ASSERT((!dvd.isNull() ? 1 : 0) != 0, (String)"blob is created on top of a null column");
        InputStream dvdStream = dvd.getStream();
        if (dvdStream == null) {
            this.materialized = true;
            this.streamPositionOffset = Integer.MIN_VALUE;
            byte[] dvdBytes = dvd.getBytes();
            SanityManager.ASSERT((dvdBytes != null ? 1 : 0) != 0, (String)"blob has a null value underneath");
            try {
                this.control = new LOBStreamControl(this.getEmbedConnection().getDBName(), dvdBytes);
            }
            catch (IOException e) {
                throw StandardException.newException("XJ022.S", e);
            }
        }
        this.materialized = false;
        SanityManager.ASSERT((boolean)(dvdStream instanceof Resetable));
        this.myStream = new PositionedStoreStream(dvdStream);
        try {
            this.myStream.initStream();
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("40XD0")) {
                throw StandardException.newException("XJ073.S");
            }
            throw se;
        }
        try {
            BinaryToRawStream tmpStream = new BinaryToRawStream(this.myStream, con);
            this.streamPositionOffset = (int)this.myStream.getPosition();
            this.streamLength = tmpStream.getLength();
            tmpStream.close();
            this.finalizer = new FinalizeEmbedBlob(this, this.myStream);
        }
        catch (DerbyIOException dioe) {
            if (dioe.getSQLState() != null) {
                throw StandardException.newPreLocalizedException(dioe.getSQLState(), dioe, dioe.getLocalizedMessage());
            }
            throw StandardException.newException("XCL30.S", dioe);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XCL30.S", ioe);
        }
        if (con != null) {
            con.addLOBReference(this);
        }
    }

    private long setBlobPosition(long logicalPos) throws StandardException, IOException {
        SanityManager.ASSERT((logicalPos >= 0L ? 1 : 0) != 0);
        if (this.materialized) {
            if (logicalPos >= this.control.getLength()) {
                throw StandardException.newException("XJ076.S", new Long(logicalPos));
            }
        } else {
            try {
                this.myStream.reposition(logicalPos + (long)this.streamPositionOffset);
            }
            catch (EOFException eofe) {
                throw StandardException.newException("XJ076.S", (Throwable)eofe, (Object)new Long(logicalPos));
            }
        }
        return logicalPos;
    }

    private int read(long pos) throws IOException, StandardException {
        int c;
        if (this.materialized) {
            if (pos >= this.control.getLength()) {
                return -1;
            }
            c = this.control.read(pos);
        } else {
            this.myStream.reposition(pos + (long)this.streamPositionOffset);
            c = this.myStream.read();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        this.checkValidity();
        try {
            if (this.materialized) {
                return this.control.getLength();
            }
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        if (this.streamLength != -1L) {
            return this.streamLength;
        }
        boolean pushStack = false;
        try {
            Object object = this.getConnectionSynchronization();
            synchronized (object) {
                try {
                    pushStack = this.getEmbedConnection().isActive();
                    if (pushStack) {
                        this.setupContextStack(false);
                    }
                    this.myStream.resetStream();
                    BinaryToRawStream tmpStream = new BinaryToRawStream(this.myStream, this);
                    this.streamLength = 0L;
                    SanityManager.ASSERT((tmpStream.getLength() == -1 ? 1 : 0) != 0);
                    while (true) {
                        long skipped;
                        SanityManager.ASSERT(((skipped = tmpStream.skip(Integer.MAX_VALUE)) >= 0L ? 1 : 0) != 0);
                        this.streamLength += skipped;
                        if (skipped != 0L) continue;
                        if (tmpStream.read() == -1) break;
                        ++this.streamLength;
                    }
                    tmpStream.close();
                    long l = this.streamLength;
                    return l;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable t) {
                        throw this.handleMyExceptions(t);
                    }
                }
            }
        }
        finally {
            if (pushStack) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBytes(long startPos, int length) throws SQLException {
        this.checkValidity();
        boolean pushStack = false;
        try {
            byte[] result;
            if (startPos < 1L) {
                throw StandardException.newException("XJ070.S", new Long(startPos));
            }
            if (length < 0) {
                throw StandardException.newException("XJ071.S", new Integer(length));
            }
            if (this.materialized) {
                result = new byte[length];
                int sz = this.control.read(result, 0, result.length, startPos - 1L);
                if (sz == -1) {
                    byte[] byArray = new byte[]{};
                    return byArray;
                }
                if (sz < length) {
                    byte[] tmparray = new byte[sz];
                    System.arraycopy(result, 0, tmparray, 0, sz);
                    result = tmparray;
                }
            } else {
                Object object = this.getConnectionSynchronization();
                synchronized (object) {
                    pushStack = this.getEmbedConnection().isActive();
                    if (pushStack) {
                        this.setupContextStack(false);
                    }
                    this.setBlobPosition(startPos - 1L);
                    result = new byte[length];
                    int n = InputStreamUtil.readLoop((InputStream)this.myStream, (byte[])result, (int)0, (int)length);
                    if (n < length) {
                        byte[] result2 = new byte[n];
                        System.arraycopy(result, 0, result2, 0, n);
                        byte[] byArray = result2;
                        return byArray;
                    }
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (StandardException e) {
            if (!e.getMessageId().equals("XJ079.S")) throw this.handleMyExceptions(e);
            e = StandardException.newException("XJ076.S", new Long(startPos));
            throw this.handleMyExceptions(e);
        }
        catch (Throwable t) {
            throw this.handleMyExceptions(t);
        }
        finally {
            if (pushStack) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkValidity();
        boolean pushStack = false;
        try {
            if (this.materialized) {
                InputStream inputStream = this.control.getInputStream(0L);
                return inputStream;
            }
            Object object = this.getConnectionSynchronization();
            synchronized (object) {
                try {
                    pushStack = this.getEmbedConnection().isActive();
                    if (pushStack) {
                        this.setupContextStack(false);
                    }
                    this.myStream.resetStream();
                    UpdatableBlobStream updatableBlobStream = new UpdatableBlobStream(this, new AutoPositioningStream(this, this.myStream, this));
                    return updatableBlobStream;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable t) {
                        throw this.handleMyExceptions(t);
                    }
                }
            }
        }
        finally {
            if (pushStack) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkMatch(byte[] pattern, long pos) throws IOException, StandardException {
        for (int i = 1; i < pattern.length; ++i) {
            int b;
            if ((b = this.read(pos++)) >= 0 && b == pattern[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long position(Blob pattern, long start) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkMatch(Blob pattern, long pos) throws IOException, StandardException {
        int b2;
        InputStream pStream;
        try {
            pStream = pattern.getBinaryStream();
        }
        catch (SQLException e) {
            return false;
        }
        if (pStream == null) {
            return false;
        }
        int b1 = pStream.read();
        if (b1 < 0) {
            return false;
        }
        do {
            if ((b1 = pStream.read()) >= 0) continue;
            return true;
        } while (b1 == (b2 = this.read(pos++)) && b2 >= 0);
        return false;
    }

    private SQLException handleMyExceptions(Throwable t) throws SQLException {
        if (t instanceof StandardException && ((StandardException)t).getMessageId().equals("40XD0")) {
            t = StandardException.newException("XJ073.S");
        }
        return this.handleException(t);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkValidity();
        try {
            if (this.materialized) {
                if (pos - 1L > this.length()) {
                    throw Util.generateCsSQLException("XJ076.S", new Long(pos));
                }
                if (pos < 1L) {
                    throw Util.generateCsSQLException("XJ070.S", new Long(pos));
                }
                len = (int)this.control.write(bytes, offset, len, pos - 1L);
            } else {
                this.control = new LOBStreamControl(this.getEmbedConnection().getDBName());
                this.control.copyData(this.myStream, this.length());
                len = (int)this.control.write(bytes, offset, len, pos - 1L);
                this.myStream.close();
                this.streamLength = -1L;
                this.materialized = true;
                this.clearFinalizer();
            }
            return len;
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkValidity();
        if (pos - 1L > this.length()) {
            throw Util.generateCsSQLException("XJ076.S", new Long(pos));
        }
        if (pos < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(pos));
        }
        try {
            if (this.materialized) {
                return this.control.getOutputStream(pos - 1L);
            }
            this.control = new LOBStreamControl(this.getEmbedConnection().getDBName());
            this.control.copyData(this.myStream, pos - 1L);
            this.myStream.close();
            this.streamLength = -1L;
            this.materialized = true;
            this.clearFinalizer();
            return this.control.getOutputStream(pos - 1L);
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (len > this.length()) {
            throw Util.generateCsSQLException("XJ079.S", new Long(len));
        }
        try {
            if (this.materialized) {
                this.control.truncate(len);
            } else {
                this.setBlobPosition(0L);
                this.control = new LOBStreamControl(this.getEmbedConnection().getDBName());
                this.control.copyData(this.myStream, len);
                this.myStream.close();
                this.streamLength = -1L;
                this.materialized = true;
                this.clearFinalizer();
            }
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    @Override
    public void free() throws SQLException {
        if (!this.isValid) {
            return;
        }
        this.isValid = false;
        if (this.locator != 0) {
            this.localConn.removeLOBMapping(this.locator);
        }
        this.streamLength = -1L;
        if (!this.materialized) {
            this.myStream.closeStream();
            this.myStream = null;
            this.clearFinalizer();
        } else {
            try {
                this.control.free();
                this.control = null;
            }
            catch (IOException e) {
                throw Util.setStreamFailure(e);
            }
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkValidity();
        if (pos <= 0L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(pos));
        }
        if (length < 0L) {
            throw Util.generateCsSQLException("XJ071.S", new Long(length));
        }
        if (length > this.length() - pos) {
            throw Util.generateCsSQLException("XJ087.S", (Object)new Long(pos), new Long(length));
        }
        try {
            return new UpdatableBlobStream(this, this.getBinaryStream(), pos - 1L, length);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
    }

    private void checkValidity() throws SQLException {
        this.getEmbedConnection().checkIfClosed();
        if (!this.isValid) {
            throw this.newSQLException("XJ215.S");
        }
    }

    boolean isMaterialized() {
        return this.materialized;
    }

    @Override
    public int getLocator() {
        if (this.locator == 0 && this.localConn != null) {
            this.locator = this.localConn.addLOBMapping(this);
        }
        return this.locator;
    }

    public Object replace() throws IOException {
        try {
            byte[] bytes = this.getBytes(1L, (int)this.length());
            return HarmonySerialBlob.wrapBytes(bytes);
        }
        catch (Exception e) {
            throw new IOException(e.toString(), e);
        }
    }

    private final void clearFinalizer() {
        FinalizeEmbedBlob finalizer = this.finalizer;
        if (finalizer != null) {
            finalizer.clearAll();
            this.finalizer = null;
        }
    }

    static final class FinalizeEmbedBlob
    extends FinalizeObject {
        private PositionedStoreStream myStream;

        public FinalizeEmbedBlob(EmbedBlob blob, PositionedStoreStream myStream) {
            super((Object)blob, true);
            this.myStream = myStream;
        }

        public final FinalizeHolder getHolder() {
            return FinalizeEmbedBlob.getServerHolder();
        }

        protected void clearThis() {
            this.myStream = null;
        }

        protected final boolean doFinalize() {
            PositionedStoreStream stream = this.myStream;
            if (stream != null) {
                stream.closeStream();
                this.myStream = null;
            }
            return true;
        }
    }
}

