/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.pivotal.gemfirexd.internal.impl.drda.CcsidManager;
import java.nio.ByteBuffer;

class EbcdicCcsidManager
extends CcsidManager {
    private static final int[] conversionArrayToEbcdic = new int[]{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 37, 11, 12, 13, 14, 15, 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31, 64, 79, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122, 94, 76, 126, 110, 111, 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214, 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 74, 224, 90, 95, 109, 121, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150, 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 192, 187, 208, 161, 7, 32, 33, 34, 35, 36, 21, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27, 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, 255, 65, 170, 176, 177, 159, 178, 106, 181, 189, 180, 154, 138, 186, 202, 175, 188, 144, 143, 234, 250, 190, 160, 182, 179, 157, 218, 155, 139, 183, 184, 185, 171, 100, 101, 98, 102, 99, 103, 158, 104, 116, 113, 114, 115, 120, 117, 118, 119, 172, 105, 237, 238, 235, 239, 236, 191, 128, 253, 254, 251, 252, 173, 174, 89, 68, 69, 66, 70, 67, 71, 156, 72, 84, 81, 82, 83, 88, 85, 86, 87, 140, 73, 205, 206, 203, 207, 204, 225, 112, 221, 222, 219, 220, 141, 142, 223};
    private static final int[] conversionArrayToUCS2 = new int[]{0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15, 16, 17, 18, 19, 157, 133, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31, 128, 129, 130, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7, 144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26, 32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 91, 46, 60, 40, 43, 33, 38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 93, 36, 42, 41, 59, 94, 45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 166, 44, 37, 95, 62, 63, 248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34, 216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177, 176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164, 181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174, 162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 172, 124, 175, 168, 180, 215, 123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245, 125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255, 92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159};

    EbcdicCcsidManager() {
        super((byte)64, (byte)75, new byte[]{-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41});
    }

    @Override
    byte[] convertFromUCS2(String sourceString) {
        ByteBuffer buf = ByteBuffer.allocate(sourceString.length());
        this.convertFromUCS2(sourceString, buf);
        return buf.array();
    }

    @Override
    void convertFromUCS2(String sourceString, ByteBuffer buffer) {
        for (int i = 0; i < sourceString.length(); ++i) {
            char c = sourceString.charAt(i);
            if (c > '\u00ff') {
                buffer.put((byte)63);
                continue;
            }
            buffer.put((byte)conversionArrayToEbcdic[c]);
        }
    }

    @Override
    String convertToUCS2(byte[] sourceBytes) {
        int i = 0;
        char[] theChars = new char[sourceBytes.length];
        int num = 0;
        for (i = 0; i < sourceBytes.length; ++i) {
            num = sourceBytes[i] < 0 ? sourceBytes[i] + 256 : sourceBytes[i];
            theChars[i] = (char)conversionArrayToUCS2[num];
        }
        return new String(theChars);
    }

    @Override
    String convertToUCS2(byte[] sourceBytes, int offset, int numToConvert) {
        int i = 0;
        int j = 0;
        char[] theChars = new char[numToConvert];
        int num = 0;
        for (i = offset; i < offset + numToConvert; ++i) {
            num = sourceBytes[i] < 0 ? sourceBytes[i] + 256 : sourceBytes[i];
            theChars[j] = (char)conversionArrayToUCS2[num];
            ++j;
        }
        return new String(theChars);
    }
}

