/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineResultSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.drda.ReEncodedInputStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;

class EXTDTAInputStream
extends InputStream {
    private InputStream binaryInputStream = null;
    int ndrdaType;
    EngineResultSet rs;
    int columnNumber;
    private Clob _clob;
    private Blob _blob;

    private EXTDTAInputStream(ResultSet rs, int columnNumber, int ndrdaType) {
        this.rs = (EngineResultSet)rs;
        this.columnNumber = columnNumber;
        this.ndrdaType = ndrdaType;
    }

    private EXTDTAInputStream(Clob clob, int ndrdaType) {
        this._clob = clob;
        this.ndrdaType = ndrdaType;
    }

    private EXTDTAInputStream(Blob blob, int ndrdaType) {
        this._blob = blob;
        this.ndrdaType = ndrdaType;
    }

    public static EXTDTAInputStream getEXTDTAStream(ResultSet rs, int column, int drdaType) throws SQLException {
        int ndrdaType = drdaType | 1;
        if (!(rs instanceof EngineResultSet)) {
            switch (ndrdaType) {
                case 201: {
                    Blob blob = rs.getBlob(column);
                    return blob != null ? new EXTDTAInputStream(blob, ndrdaType) : null;
                }
                case 207: {
                    Clob clob = rs.getClob(column);
                    return clob != null ? new EXTDTAInputStream(clob, ndrdaType) : null;
                }
            }
            EXTDTAInputStream.badDRDAType(ndrdaType);
            return null;
        }
        return new EXTDTAInputStream(rs, column, ndrdaType);
    }

    public static EXTDTAInputStream getEXTDTAStream(CallableStatement cs, int column, int drdaType) throws SQLException {
        int ndrdaType = drdaType | 1;
        switch (ndrdaType) {
            case 201: {
                Blob blob = cs.getBlob(column);
                if (blob == null) {
                    return null;
                }
                return new EXTDTAInputStream(blob, ndrdaType);
            }
            case 207: {
                Clob clob = cs.getClob(column);
                if (clob == null) {
                    return null;
                }
                return new EXTDTAInputStream(clob, ndrdaType);
            }
        }
        EXTDTAInputStream.badDRDAType(ndrdaType);
        return null;
    }

    @Override
    public int read() throws IOException {
        return this.binaryInputStream.read();
    }

    @Override
    public int available() throws IOException {
        return this.binaryInputStream.available();
    }

    @Override
    public void close() throws IOException {
        if (this.binaryInputStream != null) {
            this.binaryInputStream.close();
        }
        this.binaryInputStream = null;
    }

    public boolean equals(Object arg0) {
        return this.binaryInputStream.equals(arg0);
    }

    public int hashCode() {
        return this.binaryInputStream.hashCode();
    }

    @Override
    public void mark(int arg0) {
        this.binaryInputStream.mark(arg0);
    }

    @Override
    public boolean markSupported() {
        return this.binaryInputStream.markSupported();
    }

    @Override
    public int read(byte[] arg0) throws IOException {
        return this.binaryInputStream.read(arg0);
    }

    @Override
    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        return this.binaryInputStream.read(arg0, arg1, arg2);
    }

    @Override
    public void reset() throws IOException {
        this.binaryInputStream.reset();
    }

    @Override
    public long skip(long arg0) throws IOException {
        if (arg0 < 0L) {
            return 0L;
        }
        return this.binaryInputStream.skip(arg0);
    }

    protected boolean isEmptyStream() throws SQLException {
        return this.length() == 0L;
    }

    private long length() throws SQLException {
        if (this.rs != null) {
            return this.rs.getLength(this.columnNumber);
        }
        if (this._clob != null) {
            return this._clob.length();
        }
        return this._blob.length();
    }

    public void initInputStream() throws SQLException {
        InputStream is = null;
        Reader r = null;
        if (this.ndrdaType == 201) {
            is = this.getBinaryStream();
            if (is == null) {
                return;
            }
        } else if (this.ndrdaType == 207) {
            try {
                r = this.getCharacterStream();
                if (r == null) {
                    return;
                }
                is = new ReEncodedInputStream(r);
            }
            catch (UnsupportedEncodingException e) {
                throw Util.javaException(e);
            }
            catch (IOException e) {
                throw Util.javaException(e);
            }
        } else {
            EXTDTAInputStream.badDRDAType(this.ndrdaType);
        }
        if (is != null && !is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        this.binaryInputStream = is;
    }

    private InputStream getBinaryStream() throws SQLException {
        if (this.rs != null) {
            return this.rs.getBinaryStream(this.columnNumber);
        }
        return this._blob.getBinaryStream();
    }

    private Reader getCharacterStream() throws SQLException {
        if (this.rs != null) {
            return this.rs.getCharacterStream(this.columnNumber);
        }
        return this._clob.getCharacterStream();
    }

    private static void badDRDAType(int drdaType) {
        SanityManager.THROWASSERT((String)("NDRDAType: " + drdaType + " not valid EXTDTA object type"));
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean isNull() throws SQLException {
        if (this.rs != null) {
            return this.rs.isNull(this.columnNumber);
        }
        return this._clob == null && this._blob == null;
    }
}

