/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.util;

import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.BitSet;

@SuppressWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"})
public final class JBitSet {
    private final BitSet bitSet;
    private int size;

    public JBitSet(int size) {
        this.bitSet = new BitSet(size);
        this.size = size;
    }

    private JBitSet(BitSet bitSet, int size) {
        this.bitSet = bitSet;
        this.size = size;
    }

    public void setTo(JBitSet sourceBitSet) {
        SanityManager.ASSERT((this.size == sourceBitSet.size() ? 1 : 0) != 0, (String)"JBitSets are expected to be the same size");
        this.and(sourceBitSet);
        this.or(sourceBitSet);
    }

    public boolean contains(JBitSet jBitSet) {
        SanityManager.ASSERT((this.size == jBitSet.size() ? 1 : 0) != 0, (String)"JBitSets are expected to be the same size");
        for (int bitIndex = 0; bitIndex < this.size; ++bitIndex) {
            if (!jBitSet.bitSet.get(bitIndex) || this.bitSet.get(bitIndex)) continue;
            return false;
        }
        return true;
    }

    public boolean hasSingleBitSet() {
        boolean found = false;
        for (int bitIndex = 0; bitIndex < this.size; ++bitIndex) {
            if (!this.bitSet.get(bitIndex)) continue;
            if (found) {
                return false;
            }
            found = true;
        }
        return found;
    }

    public int getFirstSetBit() {
        for (int bitIndex = 0; bitIndex < this.size; ++bitIndex) {
            if (!this.bitSet.get(bitIndex)) continue;
            return bitIndex;
        }
        return -1;
    }

    public void grow(int newSize) {
        SanityManager.ASSERT((newSize > this.size ? 1 : 0) != 0, (String)"New size is expected to be larger than current size");
        this.size = newSize;
    }

    public void clearAll() {
        for (int bitIndex = 0; bitIndex < this.size; ++bitIndex) {
            if (!this.bitSet.get(bitIndex)) continue;
            this.bitSet.clear(bitIndex);
        }
    }

    public String toString() {
        return this.bitSet.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JBitSet)) {
            SanityManager.ASSERT((boolean)(obj instanceof JBitSet), (String)("obj is expected to be a JBitSet " + obj));
        }
        return this.bitSet.equals(((JBitSet)obj).bitSet);
    }

    public int hashCode() {
        return this.bitSet.hashCode();
    }

    public Object clone() {
        return new JBitSet((BitSet)this.bitSet.clone(), this.size);
    }

    public boolean get(int bitIndex) {
        return this.bitSet.get(bitIndex);
    }

    public void set(int bitIndex) {
        this.bitSet.set(bitIndex);
    }

    public void clear(int bitIndex) {
        this.bitSet.clear(bitIndex);
    }

    public void and(JBitSet set) {
        this.bitSet.and(set.bitSet);
    }

    public void or(JBitSet set) {
        this.bitSet.or(set.bitSet);
    }

    public void xor(JBitSet set) {
        this.bitSet.xor(set.bitSet);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    public int getNextSetBit(int start) {
        for (int bitIndex = start; bitIndex < this.size; ++bitIndex) {
            if (!this.bitSet.get(bitIndex)) continue;
            return bitIndex;
        }
        return -1;
    }

    public boolean hasAllBitSet() {
        for (int bitIndex = 0; bitIndex < this.size; ++bitIndex) {
            if (this.bitSet.get(bitIndex)) continue;
            return false;
        }
        return true;
    }

    public int noOfBitsSet() {
        int count = 0;
        int i = this.bitSet.nextSetBit(0);
        while (i >= 0) {
            ++count;
            i = this.bitSet.nextSetBit(i + 1);
        }
        return count;
    }
}

