/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ByteArray {
    private byte[] array;
    private int offset;
    private int length;

    public ByteArray(byte[] array, int offset, int length) {
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    public ByteArray(byte[] array) {
        this(array, 0, array.length);
    }

    public ByteArray() {
    }

    public void setBytes(byte[] array) {
        this.array = array;
        this.offset = 0;
        this.length = array.length;
    }

    public void setBytes(byte[] array, int length) {
        this.array = array;
        this.offset = 0;
        this.length = length;
    }

    public void setBytes(byte[] array, int offset, int length) {
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    public boolean equals(Object other) {
        if (other instanceof ByteArray) {
            ByteArray ob = (ByteArray)other;
            return ByteArray.equals(this.array, this.offset, this.length, ob.array, ob.offset, ob.length);
        }
        return false;
    }

    public int hashCode() {
        byte[] larray = this.array;
        int hash = this.length;
        for (int i = 0; i < this.length; ++i) {
            hash += larray[i + this.offset];
        }
        return hash;
    }

    public final byte[] getArray() {
        return this.array;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int newLength) {
        this.length = newLength;
    }

    public void readExternal(ObjectInput in) throws IOException {
        int len = this.length = in.readInt();
        this.offset = 0;
        this.array = new byte[len];
        in.readFully(this.array, 0, len);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.length);
        out.write(this.array, this.offset, this.length);
    }

    private static boolean equals(byte[] a, int aOffset, int aLength, byte[] b, int bOffset, int bLength) {
        if (aLength != bLength) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[i + aOffset] == b[i + bOffset]) continue;
            return false;
        }
        return true;
    }
}

