/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataType;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.spark.unsafe.Platform;

public final class SQLTinyint
extends NumberDataType {
    static final int TINYINT_LENGTH = 1;
    private byte value;
    private boolean isnull;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLTinyint.class);

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    public SQLTinyint() {
        this.isnull = true;
    }

    public SQLTinyint(byte val) {
        this.value = val;
    }

    public SQLTinyint(byte val, boolean isnull) {
        this.value = val;
        this.isnull = isnull;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public byte getByte() {
        return this.value;
    }

    @Override
    public short getShort() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        return this.value != 0;
    }

    @Override
    public String getString() {
        return this.isNull() ? null : Byte.toString(this.value);
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public Object getObject() {
        return this.isNull() ? null : Integer.valueOf(this.value);
    }

    @Override
    public String getTypeName() {
        return "TINYINT";
    }

    @Override
    public int getTypeFormatId() {
        return 199;
    }

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0);
        out.writeByte(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.value = in.readByte();
        this.isnull = false;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.value = in.readByte();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        this.value = 0;
        this.isnull = true;
    }

    @Override
    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        int otherValue;
        int thisValue = this.getInt();
        if (thisValue == (otherValue = arg.getInt())) {
            return 0;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor getClone() {
        return new SQLTinyint(this.value, this.isnull);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLTinyint();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getByte(colNumber);
        this.isnull = isNullable && resultSet.wasNull();
    }

    @Override
    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, -6);
            return;
        }
        ps.setByte(position, this.value);
    }

    @Override
    public final void setInto(ResultSet rs, int position) throws SQLException, StandardException {
        rs.updateByte(position, this.value);
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        if (theValue == null) {
            this.value = 0;
            this.isnull = true;
        } else {
            try {
                this.value = Byte.valueOf(theValue.trim());
            }
            catch (NumberFormatException nfe) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    @Override
    public void setValue(byte theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(short theValue) throws StandardException {
        if (theValue > 127 || theValue < -128) {
            throw StandardException.newException("22003", (Object)"TINYINT", (Object)null);
        }
        this.value = (byte)theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(int theValue) throws StandardException {
        if (theValue > 127 || theValue < -128) {
            throw StandardException.newException("22003", (Object)"TINYINT", (Object)null);
        }
        this.value = (byte)theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(long theValue) throws StandardException {
        if (theValue > 127L || theValue < -128L) {
            throw StandardException.newException("22003", (Object)"TINYINT", (Object)null);
        }
        this.value = (byte)theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeREAL(theValue)) > 127.0f || theValue < -128.0f) {
            throw StandardException.newException("22003", (Object)"TINYINT", (Object)null);
        }
        float floorValue = (float)Math.floor(theValue);
        this.value = (byte)floorValue;
        this.isnull = false;
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeDOUBLE(theValue)) > 127.0 || theValue < -128.0) {
            throw this.outOfRange();
        }
        double floorValue = Math.floor(theValue);
        this.value = (byte)floorValue;
        this.isnull = false;
    }

    @Override
    public void setValue(boolean theValue) {
        this.value = theValue ? (byte)1 : 0;
        this.isnull = false;
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getByte());
    }

    @Override
    public int typePrecedence() {
        return 30;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getByte() == right.getByte());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getByte() != right.getByte());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getByte() < right.getByte());
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getByte() > right.getByte());
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getByte() <= right.getByte());
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getByte() >= right.getByte());
    }

    @Override
    public NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLTinyint();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        int product2 = left.getByte() * right.getByte();
        result.setValue(product2);
        return result;
    }

    @Override
    public NumberDataValue mod(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLTinyint();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        byte byteDivisor = divisor.getByte();
        if (byteDivisor == 0) {
            throw StandardException.newException("22012");
        }
        result.setValue(dividend.getByte() % byteDivisor);
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLTinyint();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        byte operandValue = this.getByte();
        result.setValue((int)(-operandValue));
        return result;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.value < 0;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Byte.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(this.getTypeId());
            out.writeByte(this.value);
            return;
        }
        this.writeNullDVD(out);
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        this.value = dis.readByte();
        this.isnull = false;
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        assert (!this.isNull());
        dos.writeByte(this.value);
    }

    @Override
    public final int getLengthInBytes(DataTypeDescriptor dtd) {
        if (!this.isNull()) {
            return 1;
        }
        return 0;
    }

    @Override
    public final int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        outBytes[offset] = this.value;
        return 1;
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        assert (columnWidth == 1) : columnWidth;
        this.value = inBytes[offset];
        return 1;
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        assert (columnWidth == 1) : columnWidth;
        this.value = Platform.getByte(null, (long)memOffset);
        return 1;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        assert (!this.isNull());
        return ResolverUtils.addByteToBucketHash((byte)this.value, (int)hash, (int)this.getTypeFormatId());
    }

    static final byte getAsByte(byte[] inBytes, int offset) {
        return inBytes[offset];
    }

    static final byte getAsByte(UnsafeWrapper unsafe, long memOffset) {
        return unsafe.getByte(memOffset);
    }

    @Override
    public byte getTypeId() {
        return 55;
    }
}

