/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBinary;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;

public class SQLBit
extends SQLBinary {
    @Override
    public Object getObject() throws StandardException {
        return this.getBytes();
    }

    @Override
    public String getTypeName() {
        return "CHAR () FOR BIT DATA";
    }

    @Override
    int getMaxMemoryUsage() {
        return 255;
    }

    @Override
    public int getTypeFormatId() {
        return 87;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLBit();
    }

    @Override
    public final void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.setValue(resultSet.getBytes(colNumber));
    }

    @Override
    public int typePrecedence() {
        return 140;
    }

    @Override
    final void setObject(Object theValue) throws StandardException {
        this.setValue((byte[])theValue);
    }

    public SQLBit() {
    }

    public SQLBit(byte[] val) {
        this.dataValue = val;
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        int desiredWidth = desiredType.getMaximumWidth();
        this.setValue(source.getBytes());
        this.setWidth(desiredWidth, 0, true);
    }

    @Override
    public void setWidth(int desiredWidth, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this.getValue() == null) {
            return;
        }
        int sourceWidth = this.dataValue.length;
        if (sourceWidth < desiredWidth) {
            byte[] actualData = new byte[desiredWidth];
            System.arraycopy(this.dataValue, 0, actualData, 0, this.dataValue.length);
            Arrays.fill(actualData, this.dataValue.length, actualData.length, (byte)32);
            this.dataValue = actualData;
        } else if (sourceWidth > desiredWidth) {
            if (errorOnTrunc) {
                for (int i = desiredWidth; i < this.dataValue.length; ++i) {
                    if (this.dataValue[i] == 32) continue;
                    throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)StringUtil.formatForPrint(this.toString()), (Object)String.valueOf(desiredWidth));
                }
            }
            byte[] shrunkData = new byte[desiredWidth];
            System.arraycopy(this.dataValue, 0, shrunkData, 0, desiredWidth);
            this.dataValue = shrunkData;
        }
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        byte[] value;
        assert (!this.isNull());
        try {
            value = this.getValueAsBytes();
        }
        catch (SQLException sqle) {
            throw GemFireXDRuntimeException.newRuntimeException(null, sqle);
        }
        int typeId = this.getTypeFormatId();
        hash = ResolverUtils.addBytesToBucketHash((byte[])value, (int)hash, (int)typeId);
        for (int i = value.length; i < maxWidth; ++i) {
            hash = ResolverUtils.addByteToBucketHash((byte)32, (int)hash, (int)typeId);
        }
        return hash;
    }
}

