/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraInfo;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class BinarySQLHybridType
extends DataType {
    final DataValueDescriptor sqlValue;
    byte[] byteValue;
    long offsetAndWidth;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(BinarySQLHybridType.class);

    public static DataValueDescriptor getHybridType(DataValueDescriptor sqlValue, DataTypeDescriptor targetType, GemFireContainer container) throws StandardException {
        if (container != null && !container.isByteArrayStore()) {
            return sqlValue;
        }
        if (sqlValue.getClass() == BinarySQLHybridType.class) {
            assert (BinarySQLHybridType.isEquivalentType(((BinarySQLHybridType)sqlValue).sqlValue, targetType)) : "target=" + targetType.getTypeId().getTypeFormatId() + " binary types underlying value=" + ((BinarySQLHybridType)sqlValue).sqlValue.getTypeFormatId();
            return sqlValue;
        }
        if (!sqlValue.isNull()) {
            sqlValue = BinarySQLHybridType.transformToEquivalent(sqlValue, true, targetType);
            byte[] byteValue = null;
            long offsetAndWidth = 0L;
            return new BinarySQLHybridType(sqlValue, byteValue, offsetAndWidth);
        }
        return sqlValue;
    }

    public static DataValueDescriptor getHybridTypeIfNeeded(DataValueDescriptor sqlValue, DataTypeDescriptor targetType) throws StandardException {
        if (sqlValue.getClass() == BinarySQLHybridType.class) {
            assert (BinarySQLHybridType.isEquivalentType(((BinarySQLHybridType)sqlValue).sqlValue, targetType)) : "target=" + targetType.getTypeId().getTypeFormatId() + " binary types underlying value=" + ((BinarySQLHybridType)sqlValue).sqlValue.getTypeFormatId();
            return sqlValue;
        }
        if (!sqlValue.isNull()) {
            return BinarySQLHybridType.transformToEquivalent(sqlValue, true, targetType);
        }
        return sqlValue;
    }

    private BinarySQLHybridType(DataValueDescriptor sqlValue, byte[] byteValue, long offsetAndWidth) {
        this.sqlValue = sqlValue;
        this.byteValue = byteValue;
        this.offsetAndWidth = offsetAndWidth;
    }

    public static boolean needsTransformToEquivalent(DataValueDescriptor sqlValue, DataTypeDescriptor targetDTD) throws StandardException {
        return !BinarySQLHybridType.isEquivalentType(sqlValue, targetDTD);
    }

    public static DataValueDescriptor transformToEquivalent(DataValueDescriptor sqlValue, boolean notNull, DataTypeDescriptor targetDTD) throws StandardException {
        if (BinarySQLHybridType.isEquivalentType(sqlValue, targetDTD)) {
            return sqlValue;
        }
        DataValueDescriptor tgtDVD = targetDTD.getNull();
        if (notNull) {
            tgtDVD.setValue(sqlValue);
        }
        return tgtDVD;
    }

    public static boolean isEquivalentType(DataValueDescriptor sqlValue, DataTypeDescriptor targetDTD) throws StandardException {
        int targetType;
        int existingType = sqlValue.getTypeFormatId();
        if (existingType == (targetType = targetDTD.getDVDTypeFormatId())) {
            return true;
        }
        return BinarySQLHybridType.isStringType(existingType) ? BinarySQLHybridType.isStringType(targetType) : (BinarySQLHybridType.isNumericType(existingType) ? BinarySQLHybridType.isNumericType(targetType) : (BinarySQLHybridType.isDateTimeType(existingType) ? BinarySQLHybridType.isDateTimeType(targetType) : BinarySQLHybridType.isBinaryType(existingType) && BinarySQLHybridType.isBinaryType(targetType)));
    }

    public static boolean isNumericType(int dvdFormatId) {
        switch (dvdFormatId) {
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 199: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringType(int dvdFormatId) {
        switch (dvdFormatId) {
            case 78: 
            case 85: 
            case 235: 
            case 447: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDateTimeType(int dvdFormatId) {
        switch (dvdFormatId) {
            case 31: 
            case 298: 
            case 299: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinaryType(int dvdFormatId) {
        switch (dvdFormatId) {
            case 87: 
            case 88: 
            case 234: 
            case 443: {
                return true;
            }
        }
        return false;
    }

    public final byte[] getByteValue() {
        return this.byteValue;
    }

    public final DataValueDescriptor getSQLValue() {
        return this.sqlValue;
    }

    @Override
    public boolean compare(int op, ExecRow row, boolean byteArrayStore, int logicalPosition, boolean orderedNulls, boolean unknownRV) throws StandardException {
        assert (byteArrayStore) : "unexpected ExecRow of type " + row.getClass().getName() + ": " + row;
        return BinarySQLHybridType.compare(op, (AbstractCompactExecRow)row, this.sqlValue, this.byteValue, this.offsetAndWidth, logicalPosition, orderedNulls, unknownRV);
    }

    public static final boolean compare(int op, AbstractCompactExecRow compactRow, DataValueDescriptor thisValue, byte[] thisByteValue, long thisOffsetAndWidth, int logicalPosition, boolean orderedNulls, boolean unknownRV) throws StandardException {
        long rhsOffsetWidth;
        byte[] rhsBytes;
        long rhsAddr;
        OffHeapByteSource rhsBS;
        if (!orderedNulls && (thisValue.isNull() || compactRow.isNull(logicalPosition) == -7L)) {
            return unknownRV;
        }
        RowFormatter rf = compactRow.getRowFormatter();
        Object rhs = compactRow.getByteSource(logicalPosition);
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        if (rhs == null || rhs.getClass() == byte[].class) {
            rhsBS = null;
            rhsAddr = 0L;
            rhsBytes = (byte[])rhs;
            rhsOffsetWidth = rf.getOffsetAndWidth(logicalPosition, rhsBytes);
        } else {
            rhsBytes = null;
            rhsBS = (OffHeapByteSource)((Object)rhs);
            int bytesLen = rhsBS.getLength();
            rhsAddr = rhsBS.getUnsafeAddress(0, bytesLen);
            rhsOffsetWidth = rf.getOffsetAndWidth(logicalPosition, unsafe, rhsAddr, bytesLen);
        }
        int result = -Integer.signum(thisValue != null ? DataTypeUtilities.compare(unsafe, thisValue, rhsBytes, rhsAddr, rhsBS, rhsOffsetWidth, false, true, rf.getColumnDescriptor(logicalPosition - 1)) : DataTypeUtilities.compare(unsafe, thisByteValue, 0L, null, rhsBytes, rhsAddr, rhsBS, thisOffsetAndWidth, rhsOffsetWidth, false, true, rf.getColumnDescriptor(logicalPosition - 1)));
        if (!(orderedNulls || result != DataTypeUtilities.NULL_MAX && result != DataTypeUtilities.NULL_MIN)) {
            return unknownRV;
        }
        return BinarySQLHybridType.applyOp(result, op);
    }

    @Override
    public boolean compare(int op, CompactCompositeKey key, int logicalPosition, boolean orderedNulls, boolean unknownRV) throws StandardException {
        return BinarySQLHybridType.compare(op, key, this.sqlValue, this.byteValue, this.offsetAndWidth, logicalPosition, orderedNulls, unknownRV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean compare(int op, CompactCompositeKey key, DataValueDescriptor thisValue, byte[] thisByteValue, long thisOffsetAndWidth, int logicalPosition, boolean orderedNulls, boolean unknownRV) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        OffHeapByteSource rhsBS = null;
        long rhsAddr = 0L;
        ExtraInfo containerInfo = key.getExtraInfo();
        if (containerInfo == null) {
            throw RegionEntryUtils.checkCacheForNullTableInfo("BinarySQLHybridType#compare");
        }
        int tries = 1;
        try {
            long rhsOffsetWidth;
            RowFormatter rf;
            byte[] rhsBytes;
            block14: {
                do {
                    if ((rhsBytes = key.getKeyBytes()) != null) {
                        rf = containerInfo.getPrimaryKeyFormatter();
                        rhsOffsetWidth = rf.getOffsetAndWidth(logicalPosition, rhsBytes);
                        break block14;
                    }
                    Object valueByteSource = key.getValueByteSource();
                    if (valueByteSource != null) {
                        if (valueByteSource.getClass() == byte[].class) {
                            rhsBytes = (byte[])valueByteSource;
                            rf = containerInfo.getRowFormatter(rhsBytes);
                            int[] keyPositions = containerInfo.getPrimaryKeyColumns();
                            logicalPosition = keyPositions[logicalPosition - 1];
                            rhsOffsetWidth = rf.getOffsetAndWidth(logicalPosition, rhsBytes);
                        } else {
                            rhsBS = (OffHeapByteSource)((Object)valueByteSource);
                            int bytesLen = rhsBS.getLength();
                            rhsAddr = rhsBS.getUnsafeAddress(0, bytesLen);
                            rf = containerInfo.getRowFormatter(rhsAddr, rhsBS);
                            int[] keyPositions = containerInfo.getPrimaryKeyColumns();
                            logicalPosition = keyPositions[logicalPosition - 1];
                            rhsOffsetWidth = rf.getOffsetAndWidth(logicalPosition, unsafe, rhsAddr, bytesLen);
                        }
                        break block14;
                    }
                    if (tries % 1000 != 0) continue;
                    Thread.yield();
                } while (tries++ <= 10000000);
                throw RegionEntryUtils.checkCacheForNullKeyValue("BinarySQLHybridType#compare");
            }
            if (!orderedNulls && (rhsOffsetWidth == -7L || thisValue.isNull())) {
                boolean valueByteSource = unknownRV;
                return valueByteSource;
            }
            int result = -Integer.signum(thisValue != null ? DataTypeUtilities.compare(unsafe, thisValue, rhsBytes, rhsAddr, rhsBS, rhsOffsetWidth, false, true, rf.getColumnDescriptor(logicalPosition - 1)) : DataTypeUtilities.compare(unsafe, thisByteValue, 0L, null, rhsBytes, rhsAddr, rhsBS, thisOffsetAndWidth, rhsOffsetWidth, false, true, rf.getColumnDescriptor(logicalPosition - 1)));
            if (!(orderedNulls || result != DataTypeUtilities.NULL_MAX && result != DataTypeUtilities.NULL_MIN)) {
                boolean bl = unknownRV;
                return bl;
            }
            boolean bl = BinarySQLHybridType.applyOp(result, op);
            return bl;
        }
        finally {
            if (rhsBS != null) {
                rhsBS.release();
            }
        }
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        if (other.getClass() != BinarySQLHybridType.class) {
            return this.sqlValue.compare(other);
        }
        return this.sqlValue.compare(((BinarySQLHybridType)other).sqlValue);
    }

    @Override
    public String getTypeName() {
        return this.sqlValue.getTypeName();
    }

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (this.byteValue != null) {
            sz += this.byteValue.length;
        }
        return sz;
    }

    @Override
    public DataValueDescriptor getClone() {
        return new BinarySQLHybridType(this.sqlValue, this.byteValue, this.offsetAndWidth);
    }

    @Override
    public int getLength() throws StandardException {
        return this.sqlValue.getLength();
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return null;
    }

    @Override
    public String getString() throws StandardException {
        return this.sqlValue.getString();
    }

    @Override
    public void readExternalFromArray(ArrayInputStream ais) throws IOException, ClassNotFoundException {
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws StandardException, SQLException {
    }

    @Override
    public boolean isNull() {
        return this.sqlValue.isNull();
    }

    @Override
    public void restoreToNull() {
        this.sqlValue.restoreToNull();
        this.byteValue = null;
        this.offsetAndWidth = -7L;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int getTypeFormatId() {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.getClass());
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        throw new UnsupportedOperationException("unexpected invocation for " + this.getClass());
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        throw new UnsupportedOperationException("unexpected invocation");
    }

    @Override
    public void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("unexpected invocation");
    }
}

